/*
 * Decompiled with CFR 0.152.
 */
package com.android.framework.protobuf.nano;

import com.android.framework.protobuf.nano.CodedInputByteBufferNano;
import com.android.framework.protobuf.nano.CodedOutputByteBufferNano;
import com.android.framework.protobuf.nano.InvalidProtocolBufferNanoException;
import com.android.framework.protobuf.nano.MessageNanoPrinter;
import java.io.IOException;
import java.util.Arrays;

public abstract class MessageNano {
    protected volatile int cachedSize = -1;

    public int getCachedSize() {
        if (this.cachedSize < 0) {
            this.getSerializedSize();
        }
        return this.cachedSize;
    }

    public int getSerializedSize() {
        int size;
        this.cachedSize = size = this.computeSerializedSize();
        return size;
    }

    protected int computeSerializedSize() {
        return 0;
    }

    public void writeTo(CodedOutputByteBufferNano output) throws IOException {
    }

    public abstract MessageNano mergeFrom(CodedInputByteBufferNano var1) throws IOException;

    public static byte[] toByteArray(MessageNano msg) {
        byte[] result = new byte[msg.getSerializedSize()];
        MessageNano.toByteArray(msg, result, 0, result.length);
        return result;
    }

    public static void toByteArray(MessageNano msg, byte[] data, int offset2, int length) {
        try {
            CodedOutputByteBufferNano output = CodedOutputByteBufferNano.newInstance(data, offset2, length);
            msg.writeTo(output);
            output.checkNoSpaceLeft();
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    public static <T extends MessageNano> T mergeFrom(T msg, byte[] data) throws InvalidProtocolBufferNanoException {
        return MessageNano.mergeFrom(msg, data, 0, data.length);
    }

    public static <T extends MessageNano> T mergeFrom(T msg, byte[] data, int off, int len) throws InvalidProtocolBufferNanoException {
        try {
            CodedInputByteBufferNano input = CodedInputByteBufferNano.newInstance(data, off, len);
            msg.mergeFrom(input);
            input.checkLastTagWas(0);
            return msg;
        }
        catch (InvalidProtocolBufferNanoException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).");
        }
    }

    public static boolean messageNanoEquals(MessageNano a, MessageNano b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        int serializedSize = a.getSerializedSize();
        if (b.getSerializedSize() != serializedSize) {
            return false;
        }
        byte[] aByteArray = new byte[serializedSize];
        byte[] bByteArray = new byte[serializedSize];
        MessageNano.toByteArray(a, aByteArray, 0, serializedSize);
        MessageNano.toByteArray(b, bByteArray, 0, serializedSize);
        return Arrays.equals(aByteArray, bByteArray);
    }

    public String toString() {
        return MessageNanoPrinter.print(this);
    }

    public MessageNano clone() throws CloneNotSupportedException {
        return (MessageNano)super.clone();
    }
}

