/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers;

import com.android.i18n.phonenumbers.AlternateFormatsCountryCodeSet;
import com.android.i18n.phonenumbers.MetadataLoader;
import com.android.i18n.phonenumbers.Phonemetadata;
import com.android.i18n.phonenumbers.ShortNumbersRegionCodeSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

class MetadataManager {
    static final String MULTI_FILE_PHONE_NUMBER_METADATA_FILE_PREFIX = "/com/android/i18n/phonenumbers/data/PhoneNumberMetadataProto";
    static final String SINGLE_FILE_PHONE_NUMBER_METADATA_FILE_NAME = "/com/android/i18n/phonenumbers/data/SingleFilePhoneNumberMetadataProto";
    private static final String ALTERNATE_FORMATS_FILE_PREFIX = "/com/android/i18n/phonenumbers/data/PhoneNumberAlternateFormatsProto";
    private static final String SHORT_NUMBER_METADATA_FILE_PREFIX = "/com/android/i18n/phonenumbers/data/ShortNumberMetadataProto";
    static final MetadataLoader DEFAULT_METADATA_LOADER = new MetadataLoader(){

        @Override
        public InputStream loadMetadata(String metadataFileName) {
            return MetadataManager.class.getResourceAsStream(metadataFileName);
        }
    };
    private static final Logger logger = Logger.getLogger(MetadataManager.class.getName());
    private static final ConcurrentHashMap<Integer, Phonemetadata.PhoneMetadata> alternateFormatsMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Phonemetadata.PhoneMetadata> shortNumberMetadataMap = new ConcurrentHashMap();
    private static final Set<Integer> alternateFormatsCountryCodes = AlternateFormatsCountryCodeSet.getCountryCodeSet();
    private static final Set<String> shortNumberMetadataRegionCodes = ShortNumbersRegionCodeSet.getRegionCodeSet();

    private MetadataManager() {
    }

    static Phonemetadata.PhoneMetadata getAlternateFormatsForCountry(int countryCallingCode) {
        if (!alternateFormatsCountryCodes.contains(countryCallingCode)) {
            return null;
        }
        return MetadataManager.getMetadataFromMultiFilePrefix(countryCallingCode, alternateFormatsMap, ALTERNATE_FORMATS_FILE_PREFIX, DEFAULT_METADATA_LOADER);
    }

    static Phonemetadata.PhoneMetadata getShortNumberMetadataForRegion(String regionCode) {
        if (!shortNumberMetadataRegionCodes.contains(regionCode)) {
            return null;
        }
        return MetadataManager.getMetadataFromMultiFilePrefix(regionCode, shortNumberMetadataMap, SHORT_NUMBER_METADATA_FILE_PREFIX, DEFAULT_METADATA_LOADER);
    }

    static Set<String> getSupportedShortNumberRegions() {
        return Collections.unmodifiableSet(shortNumberMetadataRegionCodes);
    }

    static <T> Phonemetadata.PhoneMetadata getMetadataFromMultiFilePrefix(T key, ConcurrentHashMap<T, Phonemetadata.PhoneMetadata> map2, String filePrefix, MetadataLoader metadataLoader) {
        Phonemetadata.PhoneMetadata oldValue;
        Phonemetadata.PhoneMetadata metadata = map2.get(key);
        if (metadata != null) {
            return metadata;
        }
        String fileName = filePrefix + "_" + key;
        List<Phonemetadata.PhoneMetadata> metadataList = MetadataManager.getMetadataFromSingleFileName(fileName, metadataLoader);
        if (metadataList.size() > 1) {
            logger.log(Level.WARNING, "more than one metadata in file " + fileName);
        }
        return (oldValue = map2.putIfAbsent(key, metadata = metadataList.get(0))) != null ? oldValue : metadata;
    }

    static SingleFileMetadataMaps getSingleFileMetadataMaps(AtomicReference<SingleFileMetadataMaps> ref, String fileName, MetadataLoader metadataLoader) {
        SingleFileMetadataMaps maps = ref.get();
        if (maps != null) {
            return maps;
        }
        maps = SingleFileMetadataMaps.load(fileName, metadataLoader);
        ref.compareAndSet(null, maps);
        return ref.get();
    }

    private static List<Phonemetadata.PhoneMetadata> getMetadataFromSingleFileName(String fileName, MetadataLoader metadataLoader) {
        InputStream source = metadataLoader.loadMetadata(fileName);
        if (source == null) {
            throw new IllegalStateException("missing metadata: " + fileName);
        }
        Phonemetadata.PhoneMetadataCollection metadataCollection = MetadataManager.loadMetadataAndCloseInput(source);
        List<Phonemetadata.PhoneMetadata> metadataList = metadataCollection.getMetadataList();
        if (metadataList.size() == 0) {
            throw new IllegalStateException("empty metadata: " + fileName);
        }
        return metadataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Phonemetadata.PhoneMetadataCollection loadMetadataAndCloseInput(InputStream source) {
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ObjectInputStream(source);
            }
            catch (IOException e) {
                throw new RuntimeException("cannot load/parse metadata", e);
            }
            Phonemetadata.PhoneMetadataCollection metadataCollection = new Phonemetadata.PhoneMetadataCollection();
            try {
                metadataCollection.readExternal(ois);
            }
            catch (IOException e) {
                throw new RuntimeException("cannot load/parse metadata", e);
            }
            Phonemetadata.PhoneMetadataCollection phoneMetadataCollection = metadataCollection;
            return phoneMetadataCollection;
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                } else {
                    source.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing input stream (ignored)", e);
            }
        }
    }

    static class SingleFileMetadataMaps {
        private final Map<String, Phonemetadata.PhoneMetadata> regionCodeToMetadata;
        private final Map<Integer, Phonemetadata.PhoneMetadata> countryCallingCodeToMetadata;

        static SingleFileMetadataMaps load(String fileName, MetadataLoader metadataLoader) {
            List<Phonemetadata.PhoneMetadata> metadataList = MetadataManager.getMetadataFromSingleFileName(fileName, metadataLoader);
            HashMap<String, Phonemetadata.PhoneMetadata> regionCodeToMetadata = new HashMap<String, Phonemetadata.PhoneMetadata>();
            HashMap<Integer, Phonemetadata.PhoneMetadata> countryCallingCodeToMetadata = new HashMap<Integer, Phonemetadata.PhoneMetadata>();
            for (Phonemetadata.PhoneMetadata metadata : metadataList) {
                String regionCode = metadata.getId();
                if ("001".equals(regionCode)) {
                    countryCallingCodeToMetadata.put(metadata.getCountryCode(), metadata);
                    continue;
                }
                regionCodeToMetadata.put(regionCode, metadata);
            }
            return new SingleFileMetadataMaps(regionCodeToMetadata, countryCallingCodeToMetadata);
        }

        private SingleFileMetadataMaps(Map<String, Phonemetadata.PhoneMetadata> regionCodeToMetadata, Map<Integer, Phonemetadata.PhoneMetadata> countryCallingCodeToMetadata) {
            this.regionCodeToMetadata = Collections.unmodifiableMap(regionCodeToMetadata);
            this.countryCallingCodeToMetadata = Collections.unmodifiableMap(countryCallingCodeToMetadata);
        }

        Phonemetadata.PhoneMetadata get(String regionCode) {
            return this.regionCodeToMetadata.get(regionCode);
        }

        Phonemetadata.PhoneMetadata get(int countryCallingCode) {
            return this.countryCallingCodeToMetadata.get(countryCallingCode);
        }
    }
}

