/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers.prefixmapper;

import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.i18n.phonenumbers.prefixmapper.DefaultMapStorage;
import com.android.i18n.phonenumbers.prefixmapper.FlyweightMapStorage;
import com.android.i18n.phonenumbers.prefixmapper.PhonePrefixMapStorageStrategy;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.logging.Logger;

public class PhonePrefixMap
implements Externalizable {
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    private static final Logger logger = Logger.getLogger(PhonePrefixMap.class.getName());
    private PhonePrefixMapStorageStrategy phonePrefixMapStorage;

    PhonePrefixMapStorageStrategy getPhonePrefixMapStorage() {
        return this.phonePrefixMapStorage;
    }

    private static int getSizeOfPhonePrefixMapStorage(PhonePrefixMapStorageStrategy mapStorage, SortedMap<Integer, String> phonePrefixMap) throws IOException {
        mapStorage.readFromSortedMap(phonePrefixMap);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        mapStorage.writeExternal(objectOutputStream);
        objectOutputStream.flush();
        int sizeOfStorage = byteArrayOutputStream.size();
        objectOutputStream.close();
        return sizeOfStorage;
    }

    private PhonePrefixMapStorageStrategy createDefaultMapStorage() {
        return new DefaultMapStorage();
    }

    private PhonePrefixMapStorageStrategy createFlyweightMapStorage() {
        return new FlyweightMapStorage();
    }

    PhonePrefixMapStorageStrategy getSmallerMapStorage(SortedMap<Integer, String> phonePrefixMap) {
        try {
            PhonePrefixMapStorageStrategy flyweightMapStorage = this.createFlyweightMapStorage();
            int sizeOfFlyweightMapStorage = PhonePrefixMap.getSizeOfPhonePrefixMapStorage(flyweightMapStorage, phonePrefixMap);
            PhonePrefixMapStorageStrategy defaultMapStorage = this.createDefaultMapStorage();
            int sizeOfDefaultMapStorage = PhonePrefixMap.getSizeOfPhonePrefixMapStorage(defaultMapStorage, phonePrefixMap);
            return sizeOfFlyweightMapStorage < sizeOfDefaultMapStorage ? flyweightMapStorage : defaultMapStorage;
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
            return this.createFlyweightMapStorage();
        }
    }

    public void readPhonePrefixMap(SortedMap<Integer, String> sortedPhonePrefixMap) {
        this.phonePrefixMapStorage = this.getSmallerMapStorage(sortedPhonePrefixMap);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        boolean useFlyweightMapStorage = objectInput.readBoolean();
        this.phonePrefixMapStorage = useFlyweightMapStorage ? new FlyweightMapStorage() : new DefaultMapStorage();
        this.phonePrefixMapStorage.readExternal(objectInput);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.phonePrefixMapStorage instanceof FlyweightMapStorage);
        this.phonePrefixMapStorage.writeExternal(objectOutput);
    }

    String lookup(long number) {
        int numOfEntries = this.phonePrefixMapStorage.getNumOfEntries();
        if (numOfEntries == 0) {
            return null;
        }
        long phonePrefix = number;
        int currentIndex = numOfEntries - 1;
        SortedSet<Integer> currentSetOfLengths = this.phonePrefixMapStorage.getPossibleLengths();
        while (currentSetOfLengths.size() > 0) {
            Integer possibleLength = (Integer)currentSetOfLengths.last();
            String phonePrefixStr = String.valueOf(phonePrefix);
            if (phonePrefixStr.length() > possibleLength) {
                phonePrefix = Long.parseLong(phonePrefixStr.substring(0, possibleLength));
            }
            if ((currentIndex = this.binarySearch(0, currentIndex, phonePrefix)) < 0) {
                return null;
            }
            int currentPrefix = this.phonePrefixMapStorage.getPrefix(currentIndex);
            if (phonePrefix == (long)currentPrefix) {
                return this.phonePrefixMapStorage.getDescription(currentIndex);
            }
            currentSetOfLengths = currentSetOfLengths.headSet(possibleLength);
        }
        return null;
    }

    public String lookup(Phonenumber.PhoneNumber number) {
        long phonePrefix = Long.parseLong(number.getCountryCode() + this.phoneUtil.getNationalSignificantNumber(number));
        return this.lookup(phonePrefix);
    }

    private int binarySearch(int start, int end, long value2) {
        int current = 0;
        while (start <= end) {
            current = start + end >>> 1;
            int currentValue = this.phonePrefixMapStorage.getPrefix(current);
            if ((long)currentValue == value2) {
                return current;
            }
            if ((long)currentValue > value2) {
                end = --current;
                continue;
            }
            start = current + 1;
        }
        return current;
    }

    public String toString() {
        return this.phonePrefixMapStorage.toString();
    }
}

