/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.timezone.internal;

import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import java.nio.ByteOrder;

public class Memory {
    private Memory() {
    }

    public static int peekInt(byte[] src, int offset2, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (src[offset2++] & 0xFF) << 24 | (src[offset2++] & 0xFF) << 16 | (src[offset2++] & 0xFF) << 8 | (src[offset2] & 0xFF) << 0;
        }
        return (src[offset2++] & 0xFF) << 0 | (src[offset2++] & 0xFF) << 8 | (src[offset2++] & 0xFF) << 16 | (src[offset2] & 0xFF) << 24;
    }

    public static long peekLong(byte[] src, int offset2, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int h = (src[offset2++] & 0xFF) << 24 | (src[offset2++] & 0xFF) << 16 | (src[offset2++] & 0xFF) << 8 | (src[offset2++] & 0xFF) << 0;
            int l = (src[offset2++] & 0xFF) << 24 | (src[offset2++] & 0xFF) << 16 | (src[offset2++] & 0xFF) << 8 | (src[offset2] & 0xFF) << 0;
            return (long)h << 32 | (long)l & 0xFFFFFFFFL;
        }
        int l = (src[offset2++] & 0xFF) << 0 | (src[offset2++] & 0xFF) << 8 | (src[offset2++] & 0xFF) << 16 | (src[offset2++] & 0xFF) << 24;
        int h = (src[offset2++] & 0xFF) << 0 | (src[offset2++] & 0xFF) << 8 | (src[offset2++] & 0xFF) << 16 | (src[offset2] & 0xFF) << 24;
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    public static short peekShort(byte[] src, int offset2, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (short)(src[offset2] << 8 | src[offset2 + 1] & 0xFF);
        }
        return (short)(src[offset2 + 1] << 8 | src[offset2] & 0xFF);
    }

    public static void pokeInt(byte[] dst, int offset2, int value2, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset2++] = (byte)(value2 >> 24 & 0xFF);
            dst[offset2++] = (byte)(value2 >> 16 & 0xFF);
            dst[offset2++] = (byte)(value2 >> 8 & 0xFF);
            dst[offset2] = (byte)(value2 >> 0 & 0xFF);
        } else {
            dst[offset2++] = (byte)(value2 >> 0 & 0xFF);
            dst[offset2++] = (byte)(value2 >> 8 & 0xFF);
            dst[offset2++] = (byte)(value2 >> 16 & 0xFF);
            dst[offset2] = (byte)(value2 >> 24 & 0xFF);
        }
    }

    public static void pokeLong(byte[] dst, int offset2, long value2, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int i = (int)(value2 >> 32);
            dst[offset2++] = (byte)(i >> 24 & 0xFF);
            dst[offset2++] = (byte)(i >> 16 & 0xFF);
            dst[offset2++] = (byte)(i >> 8 & 0xFF);
            dst[offset2++] = (byte)(i >> 0 & 0xFF);
            i = (int)value2;
            dst[offset2++] = (byte)(i >> 24 & 0xFF);
            dst[offset2++] = (byte)(i >> 16 & 0xFF);
            dst[offset2++] = (byte)(i >> 8 & 0xFF);
            dst[offset2] = (byte)(i >> 0 & 0xFF);
        } else {
            int i = (int)value2;
            dst[offset2++] = (byte)(i >> 0 & 0xFF);
            dst[offset2++] = (byte)(i >> 8 & 0xFF);
            dst[offset2++] = (byte)(i >> 16 & 0xFF);
            dst[offset2++] = (byte)(i >> 24 & 0xFF);
            i = (int)(value2 >> 32);
            dst[offset2++] = (byte)(i >> 0 & 0xFF);
            dst[offset2++] = (byte)(i >> 8 & 0xFF);
            dst[offset2++] = (byte)(i >> 16 & 0xFF);
            dst[offset2] = (byte)(i >> 24 & 0xFF);
        }
    }

    public static void pokeShort(byte[] dst, int offset2, short value2, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset2++] = (byte)(value2 >> 8 & 0xFF);
            dst[offset2] = (byte)(value2 >> 0 & 0xFF);
        } else {
            dst[offset2++] = (byte)(value2 >> 0 & 0xFF);
            dst[offset2] = (byte)(value2 >> 8 & 0xFF);
        }
    }

    @FastNative
    public static byte peekByte(long l) {
        return (byte)OverrideMethod.invokeI("com.android.i18n.timezone.internal.Memory#peekByte(J)B", true, null);
    }

    public static int peekInt(long address, boolean swap) {
        int result = Memory.peekIntNative(address);
        if (swap) {
            result = Integer.reverseBytes(result);
        }
        return result;
    }

    @FastNative
    private static int peekIntNative(long l) {
        return OverrideMethod.invokeI("com.android.i18n.timezone.internal.Memory#peekIntNative(J)I", true, null);
    }

    public static long peekLong(long address, boolean swap) {
        long result = Memory.peekLongNative(address);
        if (swap) {
            result = Long.reverseBytes(result);
        }
        return result;
    }

    @FastNative
    private static long peekLongNative(long l) {
        return OverrideMethod.invokeL("com.android.i18n.timezone.internal.Memory#peekLongNative(J)J", true, null);
    }

    public static short peekShort(long address, boolean swap) {
        short result = Memory.peekShortNative(address);
        if (swap) {
            result = Short.reverseBytes(result);
        }
        return result;
    }

    @FastNative
    private static short peekShortNative(long l) {
        return (short)OverrideMethod.invokeI("com.android.i18n.timezone.internal.Memory#peekShortNative(J)S", true, null);
    }

    @FastNative
    public static void peekByteArray(long l, byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#peekByteArray(J[BII)V", true, null);
    }

    @FastNative
    public static void peekCharArray(long l, char[] cArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#peekCharArray(J[CIIZ)V", true, null);
    }

    @FastNative
    public static void peekDoubleArray(long l, double[] dArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#peekDoubleArray(J[DIIZ)V", true, null);
    }

    @FastNative
    public static void peekFloatArray(long l, float[] fArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#peekFloatArray(J[FIIZ)V", true, null);
    }

    @FastNative
    public static void peekIntArray(long l, int[] nArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#peekIntArray(J[IIIZ)V", true, null);
    }

    @FastNative
    public static void peekLongArray(long l, long[] lArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#peekLongArray(J[JIIZ)V", true, null);
    }

    @FastNative
    public static void peekShortArray(long l, short[] sArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#peekShortArray(J[SIIZ)V", true, null);
    }

    @FastNative
    public static void pokeByte(long l, byte by) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#pokeByte(JB)V", true, null);
    }

    public static void pokeInt(long address, int value2, boolean swap) {
        if (swap) {
            value2 = Integer.reverseBytes(value2);
        }
        Memory.pokeIntNative(address, value2);
    }

    @FastNative
    private static void pokeIntNative(long l, int n) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#pokeIntNative(JI)V", true, null);
    }

    public static void pokeLong(long address, long value2, boolean swap) {
        if (swap) {
            value2 = Long.reverseBytes(value2);
        }
        Memory.pokeLongNative(address, value2);
    }

    @FastNative
    private static void pokeLongNative(long l, long l2) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#pokeLongNative(JJ)V", true, null);
    }

    public static void pokeShort(long address, short value2, boolean swap) {
        if (swap) {
            value2 = Short.reverseBytes(value2);
        }
        Memory.pokeShortNative(address, value2);
    }

    @FastNative
    private static void pokeShortNative(long l, short s) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#pokeShortNative(JS)V", true, null);
    }

    public static void pokeByteArray(long l, byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#pokeByteArray(J[BII)V", true, null);
    }

    public static void pokeCharArray(long l, char[] cArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#pokeCharArray(J[CIIZ)V", true, null);
    }

    public static void pokeDoubleArray(long l, double[] dArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#pokeDoubleArray(J[DIIZ)V", true, null);
    }

    public static void pokeFloatArray(long l, float[] fArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#pokeFloatArray(J[FIIZ)V", true, null);
    }

    public static void pokeIntArray(long l, int[] nArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#pokeIntArray(J[IIIZ)V", true, null);
    }

    public static void pokeLongArray(long l, long[] lArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#pokeLongArray(J[JIIZ)V", true, null);
    }

    public static void pokeShortArray(long l, short[] sArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("com.android.i18n.timezone.internal.Memory#pokeShortArray(J[SIIZ)V", true, null);
    }
}

