/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims.internal;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telecom.VideoProfile;

public interface IImsVideoCallCallback
extends IInterface {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/telephony/java/com/android/ims/internal/IImsVideoCallCallback.aidl:34:1:34:69")
    public void receiveSessionModifyRequest(VideoProfile var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/telephony/java/com/android/ims/internal/IImsVideoCallCallback.aidl:37:1:37:69")
    public void receiveSessionModifyResponse(int var1, VideoProfile var2, VideoProfile var3) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/telephony/java/com/android/ims/internal/IImsVideoCallCallback.aidl:41:1:41:69")
    public void handleCallSessionEvent(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/telephony/java/com/android/ims/internal/IImsVideoCallCallback.aidl:44:1:44:69")
    public void changePeerDimensions(int var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/telephony/java/com/android/ims/internal/IImsVideoCallCallback.aidl:47:1:47:69")
    public void changeCallDataUsage(long var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/telephony/java/com/android/ims/internal/IImsVideoCallCallback.aidl:50:1:50:69")
    public void changeCameraCapabilities(VideoProfile.CameraCapabilities var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/telephony/java/com/android/ims/internal/IImsVideoCallCallback.aidl:53:1:53:69")
    public void changeVideoQuality(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsVideoCallCallback {
        public static final String DESCRIPTOR = "com.android.ims.internal.IImsVideoCallCallback";
        static final int TRANSACTION_receiveSessionModifyRequest = 1;
        static final int TRANSACTION_receiveSessionModifyResponse = 2;
        static final int TRANSACTION_handleCallSessionEvent = 3;
        static final int TRANSACTION_changePeerDimensions = 4;
        static final int TRANSACTION_changeCallDataUsage = 5;
        static final int TRANSACTION_changeCameraCapabilities = 6;
        static final int TRANSACTION_changeVideoQuality = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IImsVideoCallCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IImsVideoCallCallback) {
                return (IImsVideoCallCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "receiveSessionModifyRequest";
                }
                case 2: {
                    return "receiveSessionModifyResponse";
                }
                case 3: {
                    return "handleCallSessionEvent";
                }
                case 4: {
                    return "changePeerDimensions";
                }
                case 5: {
                    return "changeCallDataUsage";
                }
                case 6: {
                    return "changeCameraCapabilities";
                }
                case 7: {
                    return "changeVideoQuality";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    VideoProfile _arg0 = data.readTypedObject(VideoProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.receiveSessionModifyRequest(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    VideoProfile _arg1 = data.readTypedObject(VideoProfile.CREATOR);
                    VideoProfile _arg2 = data.readTypedObject(VideoProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.receiveSessionModifyResponse(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.handleCallSessionEvent(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.changePeerDimensions(_arg0, _arg1);
                    break;
                }
                case 5: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.changeCallDataUsage(_arg0);
                    break;
                }
                case 6: {
                    VideoProfile.CameraCapabilities _arg0 = data.readTypedObject(VideoProfile.CameraCapabilities.CREATOR);
                    data.enforceNoDataAvail();
                    this.changeCameraCapabilities(_arg0);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.changeVideoQuality(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IImsVideoCallCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveSessionModifyRequest(VideoProfile videoProfile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(videoProfile, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveSessionModifyResponse(int status, VideoProfile requestedProfile, VideoProfile responseProfile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeTypedObject(requestedProfile, 0);
                    _data.writeTypedObject(responseProfile, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleCallSessionEvent(int event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(event);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void changePeerDimensions(int width2, int height2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(width2);
                    _data.writeInt(height2);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void changeCallDataUsage(long dataUsage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(dataUsage);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void changeCameraCapabilities(VideoProfile.CameraCapabilities cameraCapabilities) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(cameraCapabilities, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void changeVideoQuality(int videoQuality) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(videoQuality);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsVideoCallCallback {
        @Override
        public void receiveSessionModifyRequest(VideoProfile videoProfile) throws RemoteException {
        }

        @Override
        public void receiveSessionModifyResponse(int status, VideoProfile requestedProfile, VideoProfile responseProfile) throws RemoteException {
        }

        @Override
        public void handleCallSessionEvent(int event) throws RemoteException {
        }

        @Override
        public void changePeerDimensions(int width2, int height2) throws RemoteException {
        }

        @Override
        public void changeCallDataUsage(long dataUsage) throws RemoteException {
        }

        @Override
        public void changeCameraCapabilities(VideoProfile.CameraCapabilities cameraCapabilities) throws RemoteException {
        }

        @Override
        public void changeVideoQuality(int videoQuality) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

