/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManager;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.UserHandle;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.app.ChooserActivity;
import com.android.internal.app.ResolverListAdapter;
import com.android.internal.app.chooser.DisplayResolveInfo;
import com.android.internal.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ChooserTargetActionsDialogFragment
extends DialogFragment
implements DialogInterface.OnClickListener {
    protected ArrayList<DisplayResolveInfo> mTargetInfos = new ArrayList();
    protected UserHandle mUserHandle;
    protected String mShortcutId;
    protected String mShortcutTitle;
    protected boolean mIsShortcutPinned;
    protected IntentFilter mIntentFilter;
    public static final String USER_HANDLE_KEY = "user_handle";
    public static final String TARGET_INFOS_KEY = "target_infos";
    public static final String SHORTCUT_ID_KEY = "shortcut_id";
    public static final String SHORTCUT_TITLE_KEY = "shortcut_title";
    public static final String IS_SHORTCUT_PINNED_KEY = "is_shortcut_pinned";
    public static final String INTENT_FILTER_KEY = "intent_filter";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.setStateFromBundle(savedInstanceState);
        } else {
            this.setStateFromBundle(this.getArguments());
        }
    }

    void setStateFromBundle(Bundle b) {
        this.mTargetInfos = (ArrayList)b.get(TARGET_INFOS_KEY);
        this.mUserHandle = (UserHandle)b.get(USER_HANDLE_KEY);
        this.mShortcutId = b.getString(SHORTCUT_ID_KEY);
        this.mShortcutTitle = b.getString(SHORTCUT_TITLE_KEY);
        this.mIsShortcutPinned = b.getBoolean(IS_SHORTCUT_PINNED_KEY);
        this.mIntentFilter = (IntentFilter)b.get(INTENT_FILTER_KEY);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(USER_HANDLE_KEY, this.mUserHandle);
        outState.putParcelableArrayList(TARGET_INFOS_KEY, this.mTargetInfos);
        outState.putString(SHORTCUT_ID_KEY, this.mShortcutId);
        outState.putBoolean(IS_SHORTCUT_PINNED_KEY, this.mIsShortcutPinned);
        outState.putString(SHORTCUT_TITLE_KEY, this.mShortcutTitle);
        outState.putParcelable(INTENT_FILTER_KEY, this.mIntentFilter);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.setStateFromBundle(savedInstanceState);
        } else {
            this.setStateFromBundle(this.getArguments());
        }
        Optional.of(this.getDialog()).map(Dialog::getWindow).ifPresent(window -> window.setBackgroundDrawable(new ColorDrawable(0)));
        List<Pair<Drawable, CharSequence>> items = this.mTargetInfos.stream().map(dri -> new Pair<Drawable, CharSequence>(this.getItemIcon((DisplayResolveInfo)dri), this.getItemLabel((DisplayResolveInfo)dri))).collect(Collectors.toList());
        View v = inflater.inflate(17367131, container, false);
        TextView title = (TextView)v.findViewById(16908310);
        ImageView icon2 = (ImageView)v.findViewById(16908294);
        RecyclerView rv = (RecyclerView)v.findViewById(16909180);
        ResolverListAdapter.ResolveInfoPresentationGetter pg = this.getProvidingAppPresentationGetter();
        title.setText(this.isShortcutTarget() ? this.mShortcutTitle : pg.getLabel());
        icon2.setImageDrawable(pg.getIcon(this.mUserHandle));
        rv.setAdapter(new VHAdapter(items));
        return v;
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        if (this.isShortcutTarget()) {
            this.toggleShortcutPinned(this.mTargetInfos.get(which).getResolvedComponentName());
        } else {
            this.pinComponent(this.mTargetInfos.get(which).getResolvedComponentName());
        }
        ((ChooserActivity)this.getActivity()).handlePackagesChanged();
        this.dismiss();
    }

    private void toggleShortcutPinned(ComponentName name) {
        if (this.mIntentFilter == null) {
            return;
        }
        List<String> pinnedShortcuts = ChooserTargetActionsDialogFragment.getPinnedShortcutsFromPackageAsUser(this.getContext(), this.mUserHandle, this.mIntentFilter, name.getPackageName());
        if (this.mIsShortcutPinned) {
            pinnedShortcuts.remove(this.mShortcutId);
        } else {
            pinnedShortcuts.add(this.mShortcutId);
        }
        this.getContext().getSystemService(LauncherApps.class).pinShortcuts(name.getPackageName(), pinnedShortcuts, this.mUserHandle);
    }

    private static List<String> getPinnedShortcutsFromPackageAsUser(Context context, UserHandle user, IntentFilter filter2, String packageName) {
        Context contextAsUser = context.createContextAsUser(user, 0);
        List<ShortcutManager.ShareShortcutInfo> targets = contextAsUser.getSystemService(ShortcutManager.class).getShareTargets(filter2);
        return targets.stream().map(ShortcutManager.ShareShortcutInfo::getShortcutInfo).filter(s -> s.isPinned() && s.getPackage().equals(packageName)).map(ShortcutInfo::getId).collect(Collectors.toList());
    }

    private void pinComponent(ComponentName name) {
        SharedPreferences sp = ChooserActivity.getPinnedSharedPrefs(this.getContext());
        String key = name.flattenToString();
        boolean currentVal = sp.getBoolean(name.flattenToString(), false);
        if (currentVal) {
            sp.edit().remove(key).apply();
        } else {
            sp.edit().putBoolean(key, true).apply();
        }
    }

    private Drawable getPinIcon(boolean isPinned) {
        return isPinned ? this.getContext().getDrawable(17302382) : this.getContext().getDrawable(17302370);
    }

    private CharSequence getPinLabel(boolean isPinned, CharSequence targetLabel) {
        return isPinned ? this.getResources().getString(17041653, targetLabel) : this.getResources().getString(17041312, targetLabel);
    }

    protected CharSequence getItemLabel(DisplayResolveInfo dri) {
        PackageManager pm = this.getContext().getPackageManager();
        return this.getPinLabel(this.isPinned(dri), this.isShortcutTarget() ? this.mShortcutTitle : dri.getResolveInfo().loadLabel(pm));
    }

    protected Drawable getItemIcon(DisplayResolveInfo dri) {
        return this.getPinIcon(this.isPinned(dri));
    }

    private ResolverListAdapter.ResolveInfoPresentationGetter getProvidingAppPresentationGetter() {
        ActivityManager am = (ActivityManager)this.getContext().getSystemService("activity");
        int iconDpi = am.getLauncherLargeIconDensity();
        return new ResolverListAdapter.ResolveInfoPresentationGetter(this.getContext(), iconDpi, this.mTargetInfos.get(0).getResolveInfo());
    }

    private boolean isPinned(DisplayResolveInfo dri) {
        return this.isShortcutTarget() ? this.mIsShortcutPinned : dri.isPinned();
    }

    private boolean isShortcutTarget() {
        return this.mShortcutId != null;
    }

    class VH
    extends RecyclerView.ViewHolder {
        TextView mLabel;
        ImageView mIcon;

        VH(View itemView) {
            super(itemView);
            this.mLabel = (TextView)itemView.findViewById(16909579);
            this.mIcon = (ImageView)itemView.findViewById(16908294);
        }

        public void bind(Pair<Drawable, CharSequence> item, int position) {
            this.mLabel.setText((CharSequence)item.second);
            if (item.first == null) {
                this.mIcon.setVisibility(8);
            } else {
                this.mIcon.setVisibility(0);
                this.mIcon.setImageDrawable((Drawable)item.first);
            }
            this.itemView.setOnClickListener(v -> ChooserTargetActionsDialogFragment.this.onClick(ChooserTargetActionsDialogFragment.this.getDialog(), position));
        }
    }

    class VHAdapter
    extends RecyclerView.Adapter<VH> {
        List<Pair<Drawable, CharSequence>> mItems;

        VHAdapter(List<Pair<Drawable, CharSequence>> items) {
            this.mItems = items;
        }

        @Override
        public VH onCreateViewHolder(ViewGroup parent, int viewType) {
            return new VH(LayoutInflater.from(parent.getContext()).inflate(17367132, parent, false));
        }

        @Override
        public void onBindViewHolder(VH holder, int position) {
            holder.bind(this.mItems.get(position), position);
        }

        @Override
        public int getItemCount() {
            return this.mItems.size();
        }
    }
}

