/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.AlertDialog;
import android.content.Context;
import android.media.MediaRouter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import java.util.Comparator;

public class MediaRouteChooserDialog
extends AlertDialog {
    private final MediaRouter mRouter;
    private final MediaRouterCallback mCallback;
    private final boolean mShowProgressBarWhenEmpty;
    private int mRouteTypes;
    private View.OnClickListener mExtendedSettingsClickListener;
    private RouteAdapter mAdapter;
    private ListView mListView;
    private Button mExtendedSettingsButton;
    private boolean mAttachedToWindow;

    public MediaRouteChooserDialog(Context context, int theme) {
        this(context, theme, true);
    }

    public MediaRouteChooserDialog(Context context, int theme, boolean showProgressBarWhenEmpty) {
        super(context, theme);
        this.mRouter = (MediaRouter)context.getSystemService("media_router");
        this.mCallback = new MediaRouterCallback();
        this.mShowProgressBarWhenEmpty = showProgressBarWhenEmpty;
    }

    public int getRouteTypes() {
        return this.mRouteTypes;
    }

    public void setRouteTypes(int types) {
        if (this.mRouteTypes != types) {
            this.mRouteTypes = types;
            if (this.mAttachedToWindow) {
                this.mRouter.removeCallback(this.mCallback);
                this.mRouter.addCallback(types, this.mCallback, 1);
            }
            this.refreshRoutes();
        }
    }

    public void setExtendedSettingsClickListener(View.OnClickListener listener2) {
        if (listener2 != this.mExtendedSettingsClickListener) {
            this.mExtendedSettingsClickListener = listener2;
            this.updateExtendedSettingsButton();
        }
    }

    public boolean onFilterRoute(MediaRouter.RouteInfo route) {
        return !route.isDefault() && route.isEnabled() && route.matchesTypes(this.mRouteTypes);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.setView(LayoutInflater.from(this.getContext()).inflate(17367205, null));
        this.setTitle(this.mRouteTypes == 4 ? 17040674 : 17040673);
        this.setIcon(MediaRouteChooserDialog.isLightTheme(this.getContext()) ? 17302693 : 17302692);
        super.onCreate(savedInstanceState);
        Object emptyView = this.findViewById(16908292);
        this.mAdapter = new RouteAdapter(this.getContext());
        this.mListView = (ListView)this.findViewById(16909215);
        this.mListView.setAdapter(this.mAdapter);
        this.mListView.setOnItemClickListener(this.mAdapter);
        this.mListView.setEmptyView((View)emptyView);
        this.mExtendedSettingsButton = (Button)this.findViewById(16909214);
        this.updateExtendedSettingsButton();
        if (!this.mShowProgressBarWhenEmpty) {
            ((View)this.findViewById(16909216)).setVisibility(8);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)((View)emptyView).getLayoutParams();
            params.gravity = 17;
            ((View)emptyView).setLayoutParams(params);
        }
    }

    private void updateExtendedSettingsButton() {
        if (this.mExtendedSettingsButton != null) {
            this.mExtendedSettingsButton.setOnClickListener(this.mExtendedSettingsClickListener);
            this.mExtendedSettingsButton.setVisibility(this.mExtendedSettingsClickListener != null ? 0 : 8);
        }
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        this.mRouter.addCallback(this.mRouteTypes, this.mCallback, 1);
        this.refreshRoutes();
    }

    @Override
    public void onDetachedFromWindow() {
        this.mAttachedToWindow = false;
        this.mRouter.removeCallback(this.mCallback);
        super.onDetachedFromWindow();
    }

    public void refreshRoutes() {
        if (this.mAttachedToWindow) {
            this.mAdapter.update();
        }
    }

    static boolean isLightTheme(Context context) {
        TypedValue value2 = new TypedValue();
        return context.getTheme().resolveAttribute(16844176, value2, true) && value2.data != 0;
    }

    private static class RouteComparator
    implements Comparator<MediaRouter.RouteInfo> {
        public static final RouteComparator sInstance = new RouteComparator();

        private RouteComparator() {
        }

        @Override
        public int compare(MediaRouter.RouteInfo lhs, MediaRouter.RouteInfo rhs) {
            return lhs.getName().toString().compareTo(rhs.getName().toString());
        }
    }

    private class MediaRouterCallback
    extends MediaRouter.SimpleCallback {
        private MediaRouterCallback() {
        }

        @Override
        public void onRouteAdded(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteChooserDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteRemoved(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteChooserDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteChanged(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteChooserDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteSelected(MediaRouter router, int type, MediaRouter.RouteInfo info) {
            MediaRouteChooserDialog.this.dismiss();
        }
    }

    private class RouteAdapter
    extends ArrayAdapter<MediaRouter.RouteInfo>
    implements AdapterView.OnItemClickListener {
        private final LayoutInflater mInflater;

        public RouteAdapter(Context context) {
            super(context, 0);
            this.mInflater = LayoutInflater.from(context);
        }

        public void update() {
            this.clear();
            int count = MediaRouteChooserDialog.this.mRouter.getRouteCount();
            for (int i = 0; i < count; ++i) {
                MediaRouter.RouteInfo route = MediaRouteChooserDialog.this.mRouter.getRouteAt(i);
                if (!MediaRouteChooserDialog.this.onFilterRoute(route)) continue;
                this.add(route);
            }
            this.sort(RouteComparator.sInstance);
            this.notifyDataSetChanged();
        }

        @Override
        public boolean areAllItemsEnabled() {
            return false;
        }

        @Override
        public boolean isEnabled(int position) {
            return ((MediaRouter.RouteInfo)this.getItem(position)).isEnabled();
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View view2 = convertView;
            if (view2 == null) {
                view2 = this.mInflater.inflate(17367207, parent, false);
            }
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)this.getItem(position);
            TextView text1 = (TextView)view2.findViewById(16908308);
            TextView text2 = (TextView)view2.findViewById(16908309);
            text1.setText(route.getName());
            CharSequence description = route.getDescription();
            if (TextUtils.isEmpty(description)) {
                text2.setVisibility(8);
                text2.setText("");
            } else {
                text2.setVisibility(0);
                text2.setText(description);
            }
            view2.setEnabled(route.isEnabled());
            return view2;
        }

        @Override
        public void onItemClick(AdapterView<?> parent, View view2, int position, long id2) {
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)this.getItem(position);
            if (route.isEnabled()) {
                route.select();
                MediaRouteChooserDialog.this.dismiss();
            }
        }
    }
}

