/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.animation.ObjectAnimator;
import android.app.ActionBar;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.AnalogClock;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.android.internal.lang.System_Delegate;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.json.JSONObject;

public class PlatLogoActivity
extends Activity {
    private static final String TAG = "PlatLogoActivity";
    private static final String S_EGG_UNLOCK_SETTING = "egg_mode_s";
    private SettableAnalogClock mClock;
    private ImageView mLogo;
    private BubblesDrawable mBg;
    static final String TOUCH_STATS = "touch.stats";
    double mPressureMin = 0.0;
    double mPressureMax = -1.0;
    private static final String[][] EMOJI_SETS = new String[][]{{"\ud83c\udf47", "\ud83c\udf48", "\ud83c\udf49", "\ud83c\udf4a", "\ud83c\udf4b", "\ud83c\udf4c", "\ud83c\udf4d", "\ud83e\udd6d", "\ud83c\udf4e", "\ud83c\udf4f", "\ud83c\udf50", "\ud83c\udf51", "\ud83c\udf52", "\ud83c\udf53", "\ud83e\uded0", "\ud83e\udd5d"}, {"\ud83d\ude3a", "\ud83d\ude38", "\ud83d\ude39", "\ud83d\ude3b", "\ud83d\ude3c", "\ud83d\ude3d", "\ud83d\ude40", "\ud83d\ude3f", "\ud83d\ude3e"}, {"\ud83d\ude00", "\ud83d\ude03", "\ud83d\ude04", "\ud83d\ude01", "\ud83d\ude06", "\ud83d\ude05", "\ud83e\udd23", "\ud83d\ude02", "\ud83d\ude42", "\ud83d\ude43", "\ud83e\udee0", "\ud83d\ude09", "\ud83d\ude0a", "\ud83d\ude07", "\ud83e\udd70", "\ud83d\ude0d", "\ud83e\udd29", "\ud83d\ude18", "\ud83d\ude17", "\u263a\ufe0f", "\ud83d\ude1a", "\ud83d\ude19", "\ud83e\udd72", "\ud83d\ude0b", "\ud83d\ude1b", "\ud83d\ude1c", "\ud83e\udd2a", "\ud83d\ude1d", "\ud83e\udd11", "\ud83e\udd17", "\ud83e\udd2d", "\ud83e\udee2", "\ud83e\udee3", "\ud83e\udd2b", "\ud83e\udd14", "\ud83e\udee1", "\ud83e\udd10", "\ud83e\udd28", "\ud83d\ude10", "\ud83d\ude11", "\ud83d\ude36", "\ud83e\udee5", "\ud83d\ude0f", "\ud83d\ude12", "\ud83d\ude44", "\ud83d\ude2c", "\ud83e\udd25", "\ud83d\ude0c", "\ud83d\ude14", "\ud83d\ude2a", "\ud83e\udd24", "\ud83d\ude34", "\ud83d\ude37"}, {"\ud83e\udd29", "\ud83d\ude0d", "\ud83e\udd70", "\ud83d\ude18", "\ud83e\udd73", "\ud83e\udd72", "\ud83e\udd79"}, {"\ud83e\udee0"}, {"\ud83d\udc98", "\ud83d\udc9d", "\ud83d\udc96", "\ud83d\udc97", "\ud83d\udc93", "\ud83d\udc9e", "\ud83d\udc95", "\u2763", "\ud83d\udc94", "\u2764", "\ud83e\udde1", "\ud83d\udc9b", "\ud83d\udc9a", "\ud83d\udc99", "\ud83d\udc9c", "\ud83e\udd0e", "\ud83d\udda4", "\ud83e\udd0d"}, {"\ud83d\udc7d", "\ud83d\udef8", "\u2728", "\ud83c\udf1f", "\ud83d\udcab", "\ud83d\ude80", "\ud83e\ude90", "\ud83c\udf19", "\u2b50", "\ud83c\udf0d"}, {"\ud83c\udf11", "\ud83c\udf12", "\ud83c\udf13", "\ud83c\udf14", "\ud83c\udf15", "\ud83c\udf16", "\ud83c\udf17", "\ud83c\udf18"}, {"\ud83d\udc19", "\ud83e\udeb8", "\ud83e\udd91", "\ud83e\udd80", "\ud83e\udd90", "\ud83d\udc21", "\ud83e\udd9e", "\ud83d\udc20", "\ud83d\udc1f", "\ud83d\udc33", "\ud83d\udc0b", "\ud83d\udc2c", "\ud83e\udee7", "\ud83c\udf0a", "\ud83e\udd88"}, {"\ud83d\ude48", "\ud83d\ude49", "\ud83d\ude4a", "\ud83d\udc35", "\ud83d\udc12"}, {"\u2648", "\u2649", "\u264a", "\u264b", "\u264c", "\u264d", "\u264e", "\u264f", "\u2650", "\u2651", "\u2652", "\u2653"}, {"\ud83d\udd5b", "\ud83d\udd67", "\ud83d\udd50", "\ud83d\udd5c", "\ud83d\udd51", "\ud83d\udd5d", "\ud83d\udd52", "\ud83d\udd5e", "\ud83d\udd53", "\ud83d\udd5f", "\ud83d\udd54", "\ud83d\udd60", "\ud83d\udd55", "\ud83d\udd61", "\ud83d\udd56", "\ud83d\udd62", "\ud83d\udd57", "\ud83d\udd63", "\ud83d\udd58", "\ud83d\udd64", "\ud83d\udd59", "\ud83d\udd65", "\ud83d\udd5a", "\ud83d\udd66"}, {"\ud83c\udf3a", "\ud83c\udf38", "\ud83d\udcae", "\ud83c\udff5\ufe0f", "\ud83c\udf3c", "\ud83c\udf3f"}, {"\ud83d\udc22", "\u2728", "\ud83c\udf1f", "\ud83d\udc51"}};

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setNavigationBarColor(0);
        this.getWindow().setStatusBarColor(0);
        ActionBar ab = this.getActionBar();
        if (ab != null) {
            ab.hide();
        }
        FrameLayout layout2 = new FrameLayout(this);
        this.mClock = new SettableAnalogClock(this);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        float dp = dm.density;
        int minSide = Math.min(dm.widthPixels, dm.heightPixels);
        int widgetSize = (int)((double)minSide * 0.75);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(widgetSize, widgetSize);
        lp.gravity = 17;
        layout2.addView((View)this.mClock, lp);
        this.mLogo = new ImageView(this);
        this.mLogo.setVisibility(8);
        this.mLogo.setImageResource(17303180);
        layout2.addView((View)this.mLogo, lp);
        this.mBg = new BubblesDrawable();
        this.mBg.setLevel(0);
        this.mBg.avoid = widgetSize / 2;
        this.mBg.padding = 0.5f * dp;
        this.mBg.minR = 1.0f * dp;
        layout2.setBackground(this.mBg);
        layout2.setOnLongClickListener(this.mBg);
        this.setContentView(layout2);
    }

    private boolean shouldWriteSettings() {
        return this.getPackageName().equals("android");
    }

    private void launchNextStage(boolean locked) {
        this.mClock.animate().alpha(0.0f).scaleX(0.5f).scaleY(0.5f).withEndAction(() -> this.mClock.setVisibility(8)).start();
        this.mLogo.setAlpha(0.0f);
        this.mLogo.setScaleX(0.5f);
        this.mLogo.setScaleY(0.5f);
        this.mLogo.setVisibility(0);
        this.mLogo.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).setInterpolator(new OvershootInterpolator()).start();
        this.mLogo.postDelayed(() -> {
            ObjectAnimator anim2 = ObjectAnimator.ofInt((Object)this.mBg, "level", 0, 10000);
            anim2.setInterpolator(new DecelerateInterpolator(1.0f));
            anim2.start();
        }, 500L);
        ContentResolver cr = this.getContentResolver();
        try {
            if (this.shouldWriteSettings()) {
                Log.v(TAG, "Saving egg unlock=" + locked);
                this.syncTouchPressure();
                Settings.System.putLong(cr, S_EGG_UNLOCK_SETTING, locked ? 0L : System_Delegate.currentTimeMillis());
            }
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Can't write settings", e);
        }
        try {
            this.startActivity(new Intent("android.intent.action.MAIN").setFlags(0x10008000).addCategory("com.android.internal.category.PLATLOGO"));
        }
        catch (ActivityNotFoundException ex) {
            Log.e("com.android.internal.app.PlatLogoActivity", "No more eggs.");
        }
    }

    private void measureTouchPressure(MotionEvent event) {
        float pressure = event.getPressure();
        switch (event.getActionMasked()) {
            case 0: {
                if (!(this.mPressureMax < 0.0)) break;
                this.mPressureMin = this.mPressureMax = (double)pressure;
                break;
            }
            case 2: {
                if ((double)pressure < this.mPressureMin) {
                    this.mPressureMin = pressure;
                }
                if (!((double)pressure > this.mPressureMax)) break;
                this.mPressureMax = pressure;
            }
        }
    }

    private void syncTouchPressure() {
        try {
            String touchDataJson = Settings.System.getString(this.getContentResolver(), TOUCH_STATS);
            JSONObject touchData = new JSONObject(touchDataJson != null ? touchDataJson : "{}");
            if (touchData.has("min")) {
                this.mPressureMin = Math.min(this.mPressureMin, touchData.getDouble("min"));
            }
            if (touchData.has("max")) {
                this.mPressureMax = Math.max(this.mPressureMax, touchData.getDouble("max"));
            }
            if (this.mPressureMax >= 0.0) {
                touchData.put("min", this.mPressureMin);
                touchData.put("max", this.mPressureMax);
                if (this.shouldWriteSettings()) {
                    Settings.System.putString(this.getContentResolver(), TOUCH_STATS, touchData.toString());
                }
            }
        }
        catch (Exception e) {
            Log.e("com.android.internal.app.PlatLogoActivity", "Can't write touch settings", e);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        this.syncTouchPressure();
    }

    @Override
    public void onStop() {
        this.syncTouchPressure();
        super.onStop();
    }

    class BubblesDrawable
    extends Drawable
    implements View.OnLongClickListener {
        private static final int MAX_BUBBS = 2000;
        private final int[] mColorIds = new int[]{17170519, 17170520, 17170521, 17170506, 17170507, 17170508};
        private int[] mColors = new int[this.mColorIds.length];
        private int mEmojiSet = -1;
        private final Bubble[] mBubbs = new Bubble[2000];
        private int mNumBubbs;
        private final Paint mPaint = new Paint(1);
        public float avoid = 0.0f;
        public float padding = 0.0f;
        public float minR = 0.0f;

        BubblesDrawable() {
            for (int i = 0; i < this.mColorIds.length; ++i) {
                this.mColors[i] = PlatLogoActivity.this.getColor(this.mColorIds[i]);
            }
            for (int j = 0; j < this.mBubbs.length; ++j) {
                this.mBubbs[j] = new Bubble();
            }
        }

        @Override
        public void draw(Canvas canvas) {
            if (this.getLevel() == 0) {
                return;
            }
            float f = (float)this.getLevel() / 10000.0f;
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setTextAlign(Paint.Align.CENTER);
            int drawn = 0;
            for (int j = 0; j < this.mNumBubbs; ++j) {
                if (this.mBubbs[j].color == 0 || this.mBubbs[j].r == 0.0f) continue;
                if (this.mBubbs[j].text != null) {
                    this.mPaint.setTextSize(this.mBubbs[j].r * 1.75f);
                    canvas.drawText(this.mBubbs[j].text, this.mBubbs[j].x, this.mBubbs[j].y + this.mBubbs[j].r * f * 0.6f, this.mPaint);
                } else {
                    this.mPaint.setColor(this.mBubbs[j].color);
                    canvas.drawCircle(this.mBubbs[j].x, this.mBubbs[j].y, this.mBubbs[j].r * f, this.mPaint);
                }
                ++drawn;
            }
        }

        public void chooseEmojiSet() {
            this.mEmojiSet = (int)(Math.random() * (double)EMOJI_SETS.length);
            String[] emojiSet = EMOJI_SETS[this.mEmojiSet];
            for (int j = 0; j < this.mBubbs.length; ++j) {
                this.mBubbs[j].text = emojiSet[(int)(Math.random() * (double)emojiSet.length)];
            }
            this.invalidateSelf();
        }

        @Override
        protected boolean onLevelChange(int level) {
            this.invalidateSelf();
            return true;
        }

        @Override
        protected void onBoundsChange(Rect bounds2) {
            super.onBoundsChange(bounds2);
            this.randomize();
        }

        private void randomize() {
            float w = this.getBounds().width();
            float h = this.getBounds().height();
            float maxR = Math.min(w, h) / 3.0f;
            this.mNumBubbs = 0;
            if (this.avoid > 0.0f) {
                this.mBubbs[this.mNumBubbs].x = w / 2.0f;
                this.mBubbs[this.mNumBubbs].y = h / 2.0f;
                this.mBubbs[this.mNumBubbs].r = this.avoid;
                this.mBubbs[this.mNumBubbs].color = 0;
                ++this.mNumBubbs;
            }
            block0: for (int j = 0; j < 2000; ++j) {
                int tries = 5;
                while (tries-- > 0) {
                    float x = (float)Math.random() * w;
                    float y = (float)Math.random() * h;
                    float r = Math.min(Math.min(x, w - x), Math.min(y, h - y));
                    for (int i = 0; i < this.mNumBubbs && !((r = (float)Math.min((double)r, Math.hypot(x - this.mBubbs[i].x, y - this.mBubbs[i].y) - (double)this.mBubbs[i].r - (double)this.padding)) < this.minR); ++i) {
                    }
                    if (!(r >= this.minR)) continue;
                    r = Math.min(maxR, r);
                    this.mBubbs[this.mNumBubbs].x = x;
                    this.mBubbs[this.mNumBubbs].y = y;
                    this.mBubbs[this.mNumBubbs].r = r;
                    this.mBubbs[this.mNumBubbs].color = this.mColors[(int)(Math.random() * (double)this.mColors.length)];
                    ++this.mNumBubbs;
                    continue block0;
                }
            }
            Log.v(PlatLogoActivity.TAG, String.format("successfully placed %d bubbles (%d%%)", this.mNumBubbs, (int)(100.0f * (float)this.mNumBubbs / 2000.0f)));
        }

        @Override
        public void setAlpha(int alpha) {
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
        }

        @Override
        public int getOpacity() {
            return -3;
        }

        @Override
        public boolean onLongClick(View v) {
            if (this.getLevel() == 0) {
                return false;
            }
            this.chooseEmojiSet();
            return true;
        }
    }

    static class Bubble {
        public float x;
        public float y;
        public float r;
        public int color;
        public String text = null;

        Bubble() {
        }
    }

    public class SettableAnalogClock
    extends AnalogClock {
        private int mOverrideHour;
        private int mOverrideMinute;
        private boolean mOverride;

        public SettableAnalogClock(Context context) {
            super(context);
            this.mOverrideHour = -1;
            this.mOverrideMinute = -1;
            this.mOverride = false;
        }

        @Override
        protected Instant now() {
            Instant realNow = super.now();
            ZoneId tz = Clock.systemDefaultZone().getZone();
            ZonedDateTime zdTime = realNow.atZone(tz);
            if (this.mOverride) {
                if (this.mOverrideHour < 0) {
                    this.mOverrideHour = zdTime.getHour();
                }
                return Clock.fixed(zdTime.withHour(this.mOverrideHour).withMinute(this.mOverrideMinute).withSecond(0).toInstant(), tz).instant();
            }
            return realNow;
        }

        double toPositiveDegrees(double rad) {
            return (Math.toDegrees(rad) + 360.0 - 90.0) % 360.0;
        }

        @Override
        public boolean onTouchEvent(MotionEvent ev) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mOverride = true;
                }
                case 2: {
                    PlatLogoActivity.this.measureTouchPressure(ev);
                    float x = ev.getX();
                    float y = ev.getY();
                    float cx = (float)this.getWidth() / 2.0f;
                    float cy = (float)this.getHeight() / 2.0f;
                    float angle = (float)this.toPositiveDegrees(Math.atan2(x - cx, y - cy));
                    int minutes = (75 - (int)(angle / 6.0f)) % 60;
                    int minuteDelta = minutes - this.mOverrideMinute;
                    if (minuteDelta != 0) {
                        if (Math.abs(minuteDelta) > 45 && this.mOverrideHour >= 0) {
                            int hourDelta = minuteDelta < 0 ? 1 : -1;
                            this.mOverrideHour = (this.mOverrideHour + 24 + hourDelta) % 24;
                        }
                        this.mOverrideMinute = minutes;
                        if (this.mOverrideMinute == 0) {
                            this.performHapticFeedback(0);
                            if (this.getScaleX() == 1.0f) {
                                this.setScaleX(1.05f);
                                this.setScaleY(1.05f);
                                this.animate().scaleX(1.0f).scaleY(1.0f).setDuration(150L).start();
                            }
                        } else {
                            this.performHapticFeedback(4);
                        }
                        this.onTimeChanged();
                        this.postInvalidate();
                    }
                    return true;
                }
                case 1: {
                    if (this.mOverrideMinute == 0 && this.mOverrideHour % 12 == 1) {
                        Log.v(PlatLogoActivity.TAG, "13:00");
                        this.performHapticFeedback(0);
                        PlatLogoActivity.this.launchNextStage(false);
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

