/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.os.UserHandle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AbstractMultiProfilePagerAdapter;
import com.android.internal.app.ResolverListAdapter;

@VisibleForTesting
public class ResolverMultiProfilePagerAdapter
extends AbstractMultiProfilePagerAdapter {
    private final ResolverProfileDescriptor[] mItems;
    private final boolean mShouldShowNoCrossProfileIntentsEmptyState;
    private boolean mUseLayoutWithDefault;

    ResolverMultiProfilePagerAdapter(Context context, ResolverListAdapter adapter, UserHandle personalProfileUserHandle, UserHandle workProfileUserHandle) {
        super(context, 0, personalProfileUserHandle, workProfileUserHandle);
        this.mItems = new ResolverProfileDescriptor[]{this.createProfileDescriptor(adapter)};
        this.mShouldShowNoCrossProfileIntentsEmptyState = true;
    }

    ResolverMultiProfilePagerAdapter(Context context, ResolverListAdapter personalAdapter, ResolverListAdapter workAdapter, @AbstractMultiProfilePagerAdapter.Profile int defaultProfile, UserHandle personalProfileUserHandle, UserHandle workProfileUserHandle, boolean shouldShowNoCrossProfileIntentsEmptyState) {
        super(context, defaultProfile, personalProfileUserHandle, workProfileUserHandle);
        this.mItems = new ResolverProfileDescriptor[]{this.createProfileDescriptor(personalAdapter), this.createProfileDescriptor(workAdapter)};
        this.mShouldShowNoCrossProfileIntentsEmptyState = shouldShowNoCrossProfileIntentsEmptyState;
    }

    private ResolverProfileDescriptor createProfileDescriptor(ResolverListAdapter adapter) {
        LayoutInflater inflater = LayoutInflater.from(this.getContext());
        ViewGroup rootView = (ViewGroup)inflater.inflate(17367294, null, false);
        return new ResolverProfileDescriptor(rootView, adapter);
    }

    ListView getListViewForIndex(int index) {
        return this.getItem((int)index).listView;
    }

    @Override
    ResolverProfileDescriptor getItem(int pageIndex) {
        return this.mItems[pageIndex];
    }

    @Override
    int getItemCount() {
        return this.mItems.length;
    }

    @Override
    void setupListAdapter(int pageIndex) {
        ListView listView = this.getItem((int)pageIndex).listView;
        listView.setAdapter(this.getItem((int)pageIndex).resolverListAdapter);
    }

    @Override
    @VisibleForTesting
    public ResolverListAdapter getAdapterForIndex(int pageIndex) {
        return this.mItems[pageIndex].resolverListAdapter;
    }

    @Override
    public ViewGroup instantiateItem(ViewGroup container, int position) {
        this.setupListAdapter(position);
        return super.instantiateItem(container, position);
    }

    @Override
    ResolverListAdapter getListAdapterForUserHandle(UserHandle userHandle) {
        if (this.getActiveListAdapter().getUserHandle().equals(userHandle)) {
            return this.getActiveListAdapter();
        }
        if (this.getInactiveListAdapter() != null && this.getInactiveListAdapter().getUserHandle().equals(userHandle)) {
            return this.getInactiveListAdapter();
        }
        return null;
    }

    @Override
    @VisibleForTesting
    public ResolverListAdapter getActiveListAdapter() {
        return this.getAdapterForIndex(this.getCurrentPage());
    }

    @Override
    @VisibleForTesting
    public ResolverListAdapter getInactiveListAdapter() {
        if (this.getCount() == 1) {
            return null;
        }
        return this.getAdapterForIndex(1 - this.getCurrentPage());
    }

    @Override
    public ResolverListAdapter getPersonalListAdapter() {
        return this.getAdapterForIndex(0);
    }

    @Override
    public ResolverListAdapter getWorkListAdapter() {
        return this.getAdapterForIndex(1);
    }

    @Override
    ResolverListAdapter getCurrentRootAdapter() {
        return this.getActiveListAdapter();
    }

    @Override
    ListView getActiveAdapterView() {
        return this.getListViewForIndex(this.getCurrentPage());
    }

    @Override
    ViewGroup getInactiveAdapterView() {
        if (this.getCount() == 1) {
            return null;
        }
        return this.getListViewForIndex(1 - this.getCurrentPage());
    }

    @Override
    String getMetricsCategory() {
        return "intent_resolver";
    }

    @Override
    boolean allowShowNoCrossProfileIntentsEmptyState() {
        return this.mShouldShowNoCrossProfileIntentsEmptyState;
    }

    @Override
    protected void showWorkProfileOffEmptyState(ResolverListAdapter activeListAdapter, View.OnClickListener listener2) {
        this.showEmptyState(activeListAdapter, this.getWorkAppPausedTitle(), null, listener2);
    }

    @Override
    protected void showNoPersonalToWorkIntentsEmptyState(ResolverListAdapter activeListAdapter) {
        this.showEmptyState(activeListAdapter, this.getCrossProfileBlockedTitle(), this.getCantAccessWorkMessage());
    }

    @Override
    protected void showNoWorkToPersonalIntentsEmptyState(ResolverListAdapter activeListAdapter) {
        this.showEmptyState(activeListAdapter, this.getCrossProfileBlockedTitle(), this.getCantAccessPersonalMessage());
    }

    @Override
    protected void showNoPersonalAppsAvailableEmptyState(ResolverListAdapter listAdapter) {
        this.showEmptyState(listAdapter, this.getNoPersonalAppsAvailableMessage(), null);
    }

    @Override
    protected void showNoWorkAppsAvailableEmptyState(ResolverListAdapter listAdapter) {
        this.showEmptyState(listAdapter, this.getNoWorkAppsAvailableMessage(), null);
    }

    private String getWorkAppPausedTitle() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_WORK_PAUSED_TITLE", () -> this.getContext().getString(17041402));
    }

    private String getCrossProfileBlockedTitle() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_CROSS_PROFILE_BLOCKED_TITLE", () -> this.getContext().getString(17041396));
    }

    private String getCantAccessWorkMessage() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_CANT_ACCESS_WORK", () -> this.getContext().getString(17041393));
    }

    private String getCantAccessPersonalMessage() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_CANT_ACCESS_PERSONAL", () -> this.getContext().getString(17041392));
    }

    private String getNoWorkAppsAvailableMessage() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_NO_WORK_APPS", () -> this.getContext().getString(17041398));
    }

    private String getNoPersonalAppsAvailableMessage() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_NO_PERSONAL_APPS", () -> this.getContext().getString(17041397));
    }

    void setUseLayoutWithDefault(boolean useLayoutWithDefault) {
        this.mUseLayoutWithDefault = useLayoutWithDefault;
    }

    @Override
    protected void setupContainerPadding(View container) {
        int bottom2 = this.mUseLayoutWithDefault ? container.getPaddingBottom() : 0;
        container.setPadding(container.getPaddingLeft(), container.getPaddingTop(), container.getPaddingRight(), bottom2);
    }

    class ResolverProfileDescriptor
    extends AbstractMultiProfilePagerAdapter.ProfileDescriptor {
        private ResolverListAdapter resolverListAdapter;
        final ListView listView;

        ResolverProfileDescriptor(ViewGroup rootView, ResolverListAdapter adapter) {
            super(rootView);
            this.resolverListAdapter = adapter;
            this.listView = (ListView)rootView.findViewById(16909418);
        }
    }
}

