/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.content.res.Configuration;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.internal.app.LocaleHelper;
import com.android.internal.app.LocaleStore;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public class SuggestedLocaleAdapter
extends BaseAdapter
implements Filterable {
    private static final int TYPE_HEADER_SUGGESTED = 0;
    private static final int TYPE_HEADER_ALL_OTHERS = 1;
    private static final int TYPE_LOCALE = 2;
    private static final int TYPE_SYSTEM_LANGUAGE_FOR_APP_LANGUAGE_PICKER = 3;
    private static final int TYPE_CURRENT_LOCALE = 4;
    private static final int MIN_REGIONS_FOR_SUGGESTIONS = 6;
    private static final int APP_LANGUAGE_PICKER_TYPE_COUNT = 5;
    private static final int SYSTEM_LANGUAGE_TYPE_COUNT = 3;
    private static final int SYSTEM_LANGUAGE_WITHOUT_HEADER_TYPE_COUNT = 1;
    private ArrayList<LocaleStore.LocaleInfo> mLocaleOptions;
    private ArrayList<LocaleStore.LocaleInfo> mOriginalLocaleOptions;
    private int mSuggestionCount;
    private final boolean mCountryMode;
    private LayoutInflater mInflater;
    private Locale mDisplayLocale = null;
    private Context mContextOverride = null;
    private String mAppPackageName;

    public SuggestedLocaleAdapter(Set<LocaleStore.LocaleInfo> localeOptions, boolean countryMode) {
        this(localeOptions, countryMode, null);
    }

    public SuggestedLocaleAdapter(Set<LocaleStore.LocaleInfo> localeOptions, boolean countryMode, String appPackageName) {
        this.mCountryMode = countryMode;
        this.mLocaleOptions = new ArrayList(localeOptions.size());
        this.mAppPackageName = appPackageName;
        for (LocaleStore.LocaleInfo li : localeOptions) {
            if (li.isSuggested()) {
                ++this.mSuggestionCount;
            }
            this.mLocaleOptions.add(li);
        }
    }

    @Override
    public boolean areAllItemsEnabled() {
        return false;
    }

    @Override
    public boolean isEnabled(int position) {
        return this.getItemViewType(position) == 2 || this.getItemViewType(position) == 3 || this.getItemViewType(position) == 4;
    }

    @Override
    public int getItemViewType(int position) {
        if (!this.showHeaders()) {
            LocaleStore.LocaleInfo item = (LocaleStore.LocaleInfo)this.getItem(position);
            if (item.isSystemLocale()) {
                return 3;
            }
            if (item.isAppCurrentLocale()) {
                return 4;
            }
            return 2;
        }
        if (position == 0) {
            return 0;
        }
        if (position == this.mSuggestionCount + 1) {
            return 1;
        }
        LocaleStore.LocaleInfo item = (LocaleStore.LocaleInfo)this.getItem(position);
        if (item.isSystemLocale()) {
            return 3;
        }
        if (item.isAppCurrentLocale()) {
            return 4;
        }
        return 2;
    }

    @Override
    public int getViewTypeCount() {
        if (!TextUtils.isEmpty(this.mAppPackageName) && this.showHeaders()) {
            return 5;
        }
        if (this.showHeaders()) {
            return 3;
        }
        return 1;
    }

    @Override
    public int getCount() {
        if (this.showHeaders()) {
            return this.mLocaleOptions.size() + 2;
        }
        return this.mLocaleOptions.size();
    }

    @Override
    public Object getItem(int position) {
        int offset2 = 0;
        if (this.showHeaders()) {
            offset2 = position > this.mSuggestionCount ? -2 : -1;
        }
        return this.mLocaleOptions.get(position + offset2);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public void setDisplayLocale(Context context, Locale locale) {
        if (locale == null) {
            this.mDisplayLocale = null;
            this.mContextOverride = null;
        } else if (!locale.equals(this.mDisplayLocale)) {
            this.mDisplayLocale = locale;
            Configuration configOverride = new Configuration();
            configOverride.setLocale(locale);
            this.mContextOverride = context.createConfigurationContext(configOverride);
        }
    }

    private void setTextTo(TextView textView, int resId) {
        if (this.mContextOverride == null) {
            textView.setText(resId);
        } else {
            textView.setText(this.mContextOverride.getText(resId));
        }
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null && this.mInflater == null) {
            this.mInflater = LayoutInflater.from(parent.getContext());
        }
        int itemType = this.getItemViewType(position);
        View itemView = this.getNewViewIfNeeded(convertView, parent, itemType, position);
        switch (itemType) {
            case 0: 
            case 1: {
                TextView textView = (TextView)itemView;
                if (itemType == 0) {
                    this.setTextTo(textView, 17040580);
                } else if (this.mCountryMode) {
                    this.setTextTo(textView, 17041372);
                } else {
                    this.setTextTo(textView, 17040579);
                }
                textView.setTextLocale(this.mDisplayLocale != null ? this.mDisplayLocale : AndroidLocale.getDefault());
                break;
            }
            case 3: {
                TextView title = ((LocaleStore.LocaleInfo)this.getItem(position)).isAppCurrentLocale() ? (TextView)itemView.findViewById(16909166) : (TextView)itemView.findViewById(16909186);
                title.setText(17041618);
                break;
            }
            case 4: {
                this.updateTextView(itemView, (TextView)itemView.findViewById(16909166), position);
                break;
            }
            default: {
                this.updateTextView(itemView, (TextView)itemView.findViewById(16909186), position);
            }
        }
        return itemView;
    }

    private View getNewViewIfNeeded(View convertView, ViewGroup parent, int itemType, int position) {
        View updatedView = convertView;
        switch (itemType) {
            case 0: 
            case 1: {
                boolean shouldReuseView;
                boolean bl = shouldReuseView = convertView instanceof TextView && convertView.findViewById(16909165) != null;
                if (shouldReuseView) break;
                updatedView = this.mInflater.inflate(17367194, parent, false);
                break;
            }
            case 3: {
                boolean shouldReuseView;
                if (((LocaleStore.LocaleInfo)this.getItem(position)).isAppCurrentLocale()) {
                    boolean shouldReuseView2;
                    boolean bl = shouldReuseView2 = convertView instanceof LinearLayout && convertView.findViewById(16909166) != null;
                    if (shouldReuseView2) break;
                    updatedView = this.mInflater.inflate(17367097, parent, false);
                    this.addStateDescriptionIntoCurrentLocaleItem(updatedView);
                    break;
                }
                boolean bl = shouldReuseView = convertView instanceof TextView && convertView.findViewById(16909186) != null;
                if (shouldReuseView) break;
                updatedView = this.mInflater.inflate(0x1090099, parent, false);
                break;
            }
            case 4: {
                boolean shouldReuseView;
                boolean bl = shouldReuseView = convertView instanceof LinearLayout && convertView.findViewById(16909166) != null;
                if (shouldReuseView) break;
                updatedView = this.mInflater.inflate(17367097, parent, false);
                this.addStateDescriptionIntoCurrentLocaleItem(updatedView);
                break;
            }
            default: {
                boolean shouldReuseView;
                boolean bl = shouldReuseView = convertView instanceof TextView && convertView.findViewById(16909186) != null;
                if (shouldReuseView) break;
                updatedView = this.mInflater.inflate(0x1090099, parent, false);
            }
        }
        return updatedView;
    }

    private boolean showHeaders() {
        if (this.mCountryMode && this.mLocaleOptions.size() < 6) {
            return false;
        }
        return this.mSuggestionCount != 0 && this.mSuggestionCount != this.mLocaleOptions.size();
    }

    public void sort(LocaleHelper.LocaleInfoComparator comp) {
        Collections.sort(this.mLocaleOptions, comp);
    }

    @Override
    public Filter getFilter() {
        return new FilterByNativeAndUiNames();
    }

    private void updateTextView(View convertView, TextView text, int position) {
        LocaleStore.LocaleInfo item = (LocaleStore.LocaleInfo)this.getItem(position);
        text.setText(item.getLabel(this.mCountryMode));
        text.setTextLocale(item.getLocale());
        text.setContentDescription(item.getContentDescription(this.mCountryMode));
        if (this.mCountryMode) {
            int layoutDir = TextUtils.getLayoutDirectionFromLocale(item.getParent());
            convertView.setLayoutDirection(layoutDir);
            text.setTextDirection(layoutDir == 1 ? 4 : 3);
        }
    }

    private void addStateDescriptionIntoCurrentLocaleItem(View root) {
        String description = root.getContext().getResources().getString(17039862);
        root.setStateDescription(description);
    }

    class FilterByNativeAndUiNames
    extends Filter {
        FilterByNativeAndUiNames() {
        }

        @Override
        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            Filter.FilterResults results = new Filter.FilterResults();
            if (SuggestedLocaleAdapter.this.mOriginalLocaleOptions == null) {
                SuggestedLocaleAdapter.this.mOriginalLocaleOptions = new ArrayList<LocaleStore.LocaleInfo>(SuggestedLocaleAdapter.this.mLocaleOptions);
            }
            ArrayList<LocaleStore.LocaleInfo> values2 = new ArrayList<LocaleStore.LocaleInfo>(SuggestedLocaleAdapter.this.mOriginalLocaleOptions);
            if (prefix == null || prefix.length() == 0) {
                results.values = values2;
                results.count = values2.size();
            } else {
                Locale locale = AndroidLocale.getDefault();
                String prefixString = LocaleHelper.normalizeForSearch(prefix.toString(), locale);
                int count = values2.size();
                ArrayList<LocaleStore.LocaleInfo> newValues = new ArrayList<LocaleStore.LocaleInfo>();
                for (int i = 0; i < count; ++i) {
                    LocaleStore.LocaleInfo value2 = values2.get(i);
                    String nameToCheck = LocaleHelper.normalizeForSearch(value2.getFullNameInUiLanguage(), locale);
                    String nativeNameToCheck = LocaleHelper.normalizeForSearch(value2.getFullNameNative(), locale);
                    if (!this.wordMatches(nativeNameToCheck, prefixString) && !this.wordMatches(nameToCheck, prefixString)) continue;
                    newValues.add(value2);
                }
                results.values = newValues;
                results.count = newValues.size();
            }
            return results;
        }

        boolean wordMatches(String valueText, String prefixString) {
            String[] words;
            if (valueText.startsWith(prefixString)) {
                return true;
            }
            for (String word : words = valueText.split(" ")) {
                if (!word.startsWith(prefixString)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            SuggestedLocaleAdapter.this.mLocaleOptions = (ArrayList)results.values;
            SuggestedLocaleAdapter.this.mSuggestionCount = 0;
            for (LocaleStore.LocaleInfo li : SuggestedLocaleAdapter.this.mLocaleOptions) {
                if (!li.isSuggested()) continue;
                ++SuggestedLocaleAdapter.this.mSuggestionCount;
            }
            if (results.count > 0) {
                SuggestedLocaleAdapter.this.notifyDataSetChanged();
            } else {
                SuggestedLocaleAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

