/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.compat;

import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FrameworkStatsLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ChangeReporter {
    private static final String TAG = "CompatibilityChangeReporter";
    private int mSource;
    @GuardedBy(value={"mReportedChanges"})
    private final Map<Integer, Set<ChangeReport>> mReportedChanges;
    private boolean mDebugLogAll;
    public static final int STATE_UNKNOWN_STATE = 0;
    public static final int STATE_ENABLED = 1;
    public static final int STATE_DISABLED = 2;
    public static final int STATE_LOGGED = 3;
    public static final int SOURCE_UNKNOWN_SOURCE = 0;
    public static final int SOURCE_APP_PROCESS = 1;
    public static final int SOURCE_SYSTEM_SERVER = 2;

    public ChangeReporter(int source) {
        this.mSource = source;
        this.mReportedChanges = new HashMap<Integer, Set<ChangeReport>>();
        this.mDebugLogAll = false;
    }

    public void reportChange(int uid, long changeId, int state) {
        if (this.shouldWriteToStatsLog(uid, changeId, state)) {
            FrameworkStatsLog.write(228, uid, changeId, state, this.mSource);
        }
        if (this.shouldWriteToDebug(uid, changeId, state)) {
            this.debugLog(uid, changeId, state);
        }
        this.markAsReported(uid, new ChangeReport(changeId, state));
    }

    public void startDebugLogAll() {
        this.mDebugLogAll = true;
    }

    public void stopDebugLogAll() {
        this.mDebugLogAll = false;
    }

    @VisibleForTesting
    public boolean shouldWriteToStatsLog(int uid, long changeId, int state) {
        return !this.isAlreadyReported(uid, new ChangeReport(changeId, state));
    }

    @VisibleForTesting
    public boolean shouldWriteToDebug(int uid, long changeId, int state) {
        return this.mDebugLogAll || !this.isAlreadyReported(uid, new ChangeReport(changeId, state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlreadyReported(int uid, ChangeReport report) {
        Map<Integer, Set<ChangeReport>> map2 = this.mReportedChanges;
        synchronized (map2) {
            Set<ChangeReport> reportedChangesForUid = this.mReportedChanges.get(uid);
            if (reportedChangesForUid == null) {
                return false;
            }
            return reportedChangesForUid.contains(report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAsReported(int uid, ChangeReport report) {
        Map<Integer, Set<ChangeReport>> map2 = this.mReportedChanges;
        synchronized (map2) {
            Set<ChangeReport> reportedChangesForUid = this.mReportedChanges.get(uid);
            if (reportedChangesForUid == null) {
                this.mReportedChanges.put(uid, new HashSet());
                reportedChangesForUid = this.mReportedChanges.get(uid);
            }
            reportedChangesForUid.add(report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetReportedChanges(int uid) {
        Map<Integer, Set<ChangeReport>> map2 = this.mReportedChanges;
        synchronized (map2) {
            this.mReportedChanges.remove(uid);
        }
    }

    private void debugLog(int uid, long changeId, int state) {
        String message = TextUtils.formatSimple("Compat change id reported: %d; UID %d; state: %s", changeId, uid, ChangeReporter.stateToString(state));
        if (this.mSource == 2) {
            Slog.d(TAG, message);
        } else {
            Log.d(TAG, message);
        }
    }

    private static String stateToString(int state) {
        switch (state) {
            case 3: {
                return "LOGGED";
            }
            case 1: {
                return "ENABLED";
            }
            case 2: {
                return "DISABLED";
            }
        }
        return "UNKNOWN";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Source {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }

    private static class ChangeReport {
        long mChangeId;
        int mState;

        ChangeReport(long changeId, int state) {
            this.mChangeId = changeId;
            this.mState = state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangeReport that = (ChangeReport)o;
            return this.mChangeId == that.mChangeId && this.mState == that.mState;
        }

        public int hashCode() {
            return Objects.hash(this.mChangeId, this.mState);
        }
    }
}

