/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.listeners;

import android.os.RemoteException;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.listeners.ListenerTransport;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class ListenerTransportManager<TTransport extends ListenerTransport<?>> {
    @GuardedBy(value={"mRegistrations"})
    private final Map<Object, WeakReference<TTransport>> mRegistrations;

    protected ListenerTransportManager(boolean allowServerSideTransportRemoval) {
        this.mRegistrations = allowServerSideTransportRemoval ? new WeakHashMap<Object, WeakReference<TTransport>>() : new ArrayMap<Object, WeakReference<TTransport>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Object key, TTransport transport) {
        try {
            Map<Object, WeakReference<TTransport>> map2 = this.mRegistrations;
            synchronized (map2) {
                WeakReference<TTransport> oldTransportRef = this.mRegistrations.get(key);
                ListenerTransport oldTransport = oldTransportRef != null ? (ListenerTransport)oldTransportRef.get() : null;
                if (oldTransport == null) {
                    this.registerTransport(transport);
                } else {
                    this.registerTransport(transport, oldTransport);
                    oldTransport.unregister();
                }
                this.mRegistrations.put(key, new WeakReference<TTransport>(transport));
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Object key) {
        try {
            Map<Object, WeakReference<TTransport>> map2 = this.mRegistrations;
            synchronized (map2) {
                ListenerTransport transport;
                WeakReference<TTransport> transportRef = this.mRegistrations.remove(key);
                if (transportRef != null && (transport = (ListenerTransport)transportRef.get()) != null) {
                    transport.unregister();
                    this.unregisterTransport(transport);
                }
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    protected abstract void registerTransport(TTransport var1) throws RemoteException;

    protected void registerTransport(TTransport transport, TTransport oldTransport) throws RemoteException {
        this.registerTransport(transport);
        try {
            this.unregisterTransport(oldTransport);
        }
        catch (RemoteException e) {
            try {
                this.unregisterTransport(transport);
            }
            catch (RemoteException suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }

    protected abstract void unregisterTransport(TTransport var1) throws RemoteException;
}

