/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.org.bouncycastle.asn1;

import com.android.internal.org.bouncycastle.asn1.ASN1Encodable;
import com.android.internal.org.bouncycastle.asn1.ASN1Primitive;
import com.android.internal.org.bouncycastle.asn1.DEROutputStream;
import com.android.internal.org.bouncycastle.asn1.DLOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class ASN1OutputStream {
    private OutputStream os;

    public static ASN1OutputStream create(OutputStream out) {
        return new ASN1OutputStream(out);
    }

    public static ASN1OutputStream create(OutputStream out, String encoding) {
        if (encoding.equals("DER")) {
            return new DEROutputStream(out);
        }
        if (encoding.equals("DL")) {
            return new DLOutputStream(out);
        }
        return new ASN1OutputStream(out);
    }

    public ASN1OutputStream(OutputStream os) {
        this.os = os;
    }

    void writeLength(int length) throws IOException {
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            this.write((byte)(size | 0x80));
            for (int i = (size - 1) * 8; i >= 0; i -= 8) {
                this.write((byte)(length >> i));
            }
        } else {
            this.write((byte)length);
        }
    }

    void write(int b) throws IOException {
        this.os.write(b);
    }

    void write(byte[] bytes, int off, int len) throws IOException {
        this.os.write(bytes, off, len);
    }

    void writeElements(ASN1Encodable[] elements) throws IOException {
        int count = elements.length;
        for (int i = 0; i < count; ++i) {
            ASN1Primitive primitive = elements[i].toASN1Primitive();
            this.writePrimitive(primitive, true);
        }
    }

    void writeElements(Enumeration elements) throws IOException {
        while (elements.hasMoreElements()) {
            ASN1Primitive primitive = ((ASN1Encodable)elements.nextElement()).toASN1Primitive();
            this.writePrimitive(primitive, true);
        }
    }

    void writeEncoded(boolean withTag, int tag2, byte contents) throws IOException {
        if (withTag) {
            this.write(tag2);
        }
        this.writeLength(1);
        this.write(contents);
    }

    void writeEncoded(boolean withTag, int tag2, byte[] contents) throws IOException {
        if (withTag) {
            this.write(tag2);
        }
        this.writeLength(contents.length);
        this.write(contents, 0, contents.length);
    }

    void writeEncoded(boolean withTag, int tag2, byte[] contents, int contentsOff, int contentsLen) throws IOException {
        if (withTag) {
            this.write(tag2);
        }
        this.writeLength(contentsLen);
        this.write(contents, contentsOff, contentsLen);
    }

    void writeEncoded(boolean withTag, int tag2, byte headByte, byte[] tailBytes) throws IOException {
        if (withTag) {
            this.write(tag2);
        }
        this.writeLength(1 + tailBytes.length);
        this.write(headByte);
        this.write(tailBytes, 0, tailBytes.length);
    }

    void writeEncoded(boolean withTag, int tag2, byte headByte, byte[] body, int bodyOff, int bodyLen, byte tailByte) throws IOException {
        if (withTag) {
            this.write(tag2);
        }
        this.writeLength(2 + bodyLen);
        this.write(headByte);
        this.write(body, bodyOff, bodyLen);
        this.write(tailByte);
    }

    void writeEncoded(boolean withTag, int flags, int tagNo, byte[] contents) throws IOException {
        this.writeTag(withTag, flags, tagNo);
        this.writeLength(contents.length);
        this.write(contents, 0, contents.length);
    }

    void writeEncodedIndef(boolean withTag, int flags, int tagNo, byte[] contents) throws IOException {
        this.writeTag(withTag, flags, tagNo);
        this.write(128);
        this.write(contents, 0, contents.length);
        this.write(0);
        this.write(0);
    }

    void writeEncodedIndef(boolean withTag, int tag2, ASN1Encodable[] elements) throws IOException {
        if (withTag) {
            this.write(tag2);
        }
        this.write(128);
        this.writeElements(elements);
        this.write(0);
        this.write(0);
    }

    void writeEncodedIndef(boolean withTag, int tag2, Enumeration elements) throws IOException {
        if (withTag) {
            this.write(tag2);
        }
        this.write(128);
        this.writeElements(elements);
        this.write(0);
        this.write(0);
    }

    void writeTag(boolean withTag, int flags, int tagNo) throws IOException {
        if (!withTag) {
            return;
        }
        if (tagNo < 31) {
            this.write(flags | tagNo);
        } else {
            this.write(flags | 0x1F);
            if (tagNo < 128) {
                this.write(tagNo);
            } else {
                byte[] stack = new byte[5];
                int pos = stack.length;
                stack[--pos] = (byte)(tagNo & 0x7F);
                do {
                    stack[--pos] = (byte)((tagNo >>= 7) & 0x7F | 0x80);
                } while (tagNo > 127);
                this.write(stack, pos, stack.length - pos);
            }
        }
    }

    public void writeObject(ASN1Encodable obj) throws IOException {
        if (null == obj) {
            throw new IOException("null object detected");
        }
        this.writePrimitive(obj.toASN1Primitive(), true);
        this.flushInternal();
    }

    public void writeObject(ASN1Primitive primitive) throws IOException {
        if (null == primitive) {
            throw new IOException("null object detected");
        }
        this.writePrimitive(primitive, true);
        this.flushInternal();
    }

    void writePrimitive(ASN1Primitive primitive, boolean withTag) throws IOException {
        primitive.encode(this, withTag);
    }

    public void close() throws IOException {
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    void flushInternal() throws IOException {
    }

    DEROutputStream getDERSubStream() {
        return new DEROutputStream(this.os);
    }

    ASN1OutputStream getDLSubStream() {
        return new DLOutputStream(this.os);
    }
}

