/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;

public class AmbientDisplayPowerCalculator
extends PowerCalculator {
    private final UsageBasedPowerEstimator[] mPowerEstimators;

    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return powerComponent == 15;
    }

    public AmbientDisplayPowerCalculator(PowerProfile powerProfile) {
        int numDisplays = powerProfile.getNumDisplays();
        this.mPowerEstimators = new UsageBasedPowerEstimator[numDisplays];
        for (int display = 0; display < numDisplays; ++display) {
            this.mPowerEstimators[display] = new UsageBasedPowerEstimator(powerProfile.getAveragePowerForOrdinal("ambient.on.display", display));
        }
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        long measuredEnergyUC = batteryStats.getScreenDozeMeasuredBatteryConsumptionUC();
        int powerModel = AmbientDisplayPowerCalculator.getPowerModel(measuredEnergyUC, query);
        long durationMs = this.calculateDuration(batteryStats, rawRealtimeUs, 0);
        double powerMah = this.calculateTotalPower(powerModel, batteryStats, rawRealtimeUs, measuredEnergyUC);
        ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(0).setUsageDurationMillis(15, durationMs)).setConsumedPower(15, powerMah, powerModel);
    }

    private long calculateDuration(BatteryStats batteryStats, long rawRealtimeUs, int statsType) {
        return batteryStats.getScreenDozeTime(rawRealtimeUs, statsType) / 1000L;
    }

    private double calculateTotalPower(int powerModel, BatteryStats batteryStats, long rawRealtimeUs, long consumptionUC) {
        switch (powerModel) {
            case 2: {
                return AmbientDisplayPowerCalculator.uCtoMah(consumptionUC);
            }
        }
        return this.calculateEstimatedPower(batteryStats, rawRealtimeUs);
    }

    private double calculateEstimatedPower(BatteryStats batteryStats, long rawRealtimeUs) {
        int numDisplays = this.mPowerEstimators.length;
        double power = 0.0;
        for (int display = 0; display < numDisplays; ++display) {
            long dozeTime = batteryStats.getDisplayScreenDozeTime(display, rawRealtimeUs) / 1000L;
            power += this.mPowerEstimators[display].calculatePower(dozeTime);
        }
        return power;
    }
}

