/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.Parcel;
import android.util.SparseArray;
import com.android.internal.os.BatteryStatsHistory;

public class BatteryStatsHistoryIterator {
    private static final boolean DEBUG = false;
    private static final String TAG = "BatteryStatsHistoryItr";
    private final BatteryStatsHistory mBatteryStatsHistory;
    private final BatteryStats.HistoryStepDetails mReadHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    private final SparseArray<BatteryStats.HistoryTag> mHistoryTags = new SparseArray();

    public BatteryStatsHistoryIterator(BatteryStatsHistory history) {
        this.mBatteryStatsHistory = history;
        this.mBatteryStatsHistory.startIteratingHistory();
    }

    public boolean next(BatteryStats.HistoryItem out) {
        Parcel p = this.mBatteryStatsHistory.getNextParcel(out);
        if (p == null) {
            this.mBatteryStatsHistory.finishIteratingHistory();
            return false;
        }
        long lastRealtimeMs = out.time;
        long lastWalltimeMs = out.currentTime;
        this.readHistoryDelta(p, out);
        if (out.cmd != 5 && out.cmd != 7 && lastWalltimeMs != 0L) {
            out.currentTime = lastWalltimeMs + (out.time - lastRealtimeMs);
        }
        return true;
    }

    void readHistoryDelta(Parcel src, BatteryStats.HistoryItem cur) {
        int batteryLevelInt;
        int firstToken = src.readInt();
        int deltaTimeToken = firstToken & 0x7FFFF;
        cur.cmd = 0;
        cur.numReadInts = 1;
        if (deltaTimeToken < 524285) {
            cur.time += (long)deltaTimeToken;
        } else {
            if (deltaTimeToken == 524285) {
                cur.readFromParcel(src);
                return;
            }
            if (deltaTimeToken == 524286) {
                int delta = src.readInt();
                cur.time += (long)delta;
                ++cur.numReadInts;
            } else {
                long delta = src.readLong();
                cur.time += delta;
                cur.numReadInts += 2;
            }
        }
        if ((firstToken & 0x80000) != 0) {
            batteryLevelInt = src.readInt();
            BatteryStatsHistoryIterator.readBatteryLevelInt(batteryLevelInt, cur);
            ++cur.numReadInts;
        } else {
            batteryLevelInt = 0;
        }
        if ((firstToken & 0x100000) != 0) {
            int stateInt = src.readInt();
            cur.states = firstToken & 0xFE000000 | stateInt & 0xFFFFFF;
            cur.batteryStatus = (byte)(stateInt >> 29 & 7);
            cur.batteryHealth = (byte)(stateInt >> 26 & 7);
            cur.batteryPlugType = (byte)(stateInt >> 24 & 3);
            switch (cur.batteryPlugType) {
                case 1: {
                    cur.batteryPlugType = 1;
                    break;
                }
                case 2: {
                    cur.batteryPlugType = (byte)2;
                    break;
                }
                case 3: {
                    cur.batteryPlugType = (byte)4;
                }
            }
            ++cur.numReadInts;
        } else {
            cur.states = firstToken & 0xFE000000 | cur.states & 0xFFFFFF;
        }
        if ((firstToken & 0x200000) != 0) {
            cur.states2 = src.readInt();
        }
        if ((firstToken & 0x400000) != 0) {
            int indexes = src.readInt();
            int wakeLockIndex = indexes & 0xFFFF;
            int wakeReasonIndex = indexes >> 16 & 0xFFFF;
            cur.wakelockTag = this.readHistoryTag(src, wakeLockIndex, cur.localWakelockTag) ? cur.localWakelockTag : null;
            cur.wakeReasonTag = this.readHistoryTag(src, wakeReasonIndex, cur.localWakeReasonTag) ? cur.localWakeReasonTag : null;
            ++cur.numReadInts;
        } else {
            cur.wakelockTag = null;
            cur.wakeReasonTag = null;
        }
        if ((firstToken & 0x800000) != 0) {
            cur.eventTag = cur.localEventTag;
            int codeAndIndex = src.readInt();
            cur.eventCode = codeAndIndex & 0xFFFF;
            int index = codeAndIndex >> 16 & 0xFFFF;
            cur.eventTag = this.readHistoryTag(src, index, cur.localEventTag) ? cur.localEventTag : null;
            ++cur.numReadInts;
        } else {
            cur.eventCode = 0;
        }
        if ((batteryLevelInt & 1) != 0) {
            cur.stepDetails = this.mReadHistoryStepDetails;
            cur.stepDetails.readFromParcel(src);
        } else {
            cur.stepDetails = null;
        }
        if ((firstToken & 0x1000000) != 0) {
            cur.batteryChargeUah = src.readInt();
        }
        cur.modemRailChargeMah = src.readDouble();
        cur.wifiRailChargeMah = src.readDouble();
    }

    private boolean readHistoryTag(Parcel src, int index, BatteryStats.HistoryTag outTag) {
        if (index == 65535) {
            return false;
        }
        if ((index & 0x8000) != 0) {
            BatteryStats.HistoryTag tag2 = new BatteryStats.HistoryTag();
            tag2.readFromParcel(src);
            tag2.poolIdx = index & 0xFFFF7FFF;
            this.mHistoryTags.put(tag2.poolIdx, tag2);
            outTag.setTo(tag2);
        } else {
            BatteryStats.HistoryTag historyTag = this.mHistoryTags.get(index);
            if (historyTag != null) {
                outTag.setTo(historyTag);
            } else {
                outTag.string = null;
                outTag.uid = 0;
            }
            outTag.poolIdx = index;
        }
        return true;
    }

    private static void readBatteryLevelInt(int batteryLevelInt, BatteryStats.HistoryItem out) {
        out.batteryLevel = (byte)((batteryLevelInt & 0xFE000000) >>> 25);
        out.batteryTemperature = (short)((batteryLevelInt & 0x1FF8000) >>> 15);
        out.batteryVoltage = (char)((batteryLevelInt & 0x7FFE) >>> 1);
    }
}

