/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.util.SparseArray;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import java.util.Arrays;

public class BluetoothPowerCalculator
extends PowerCalculator {
    private static final String TAG = "BluetoothPowerCalc";
    private static final boolean DEBUG = false;
    private static final BatteryConsumer.Key[] UNINITIALIZED_KEYS = new BatteryConsumer.Key[0];
    private final double mIdleMa;
    private final double mRxMa;
    private final double mTxMa;
    private final boolean mHasBluetoothPowerController;

    public BluetoothPowerCalculator(PowerProfile profile) {
        this.mIdleMa = profile.getAveragePower("bluetooth.controller.idle");
        this.mRxMa = profile.getAveragePower("bluetooth.controller.rx");
        this.mTxMa = profile.getAveragePower("bluetooth.controller.tx");
        this.mHasBluetoothPowerController = this.mIdleMa != 0.0 && this.mRxMa != 0.0 && this.mTxMa != 0.0;
    }

    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return powerComponent == 2;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        if (!batteryStats.hasBluetoothActivityReporting()) {
            return;
        }
        BatteryConsumer.Key[] keys = UNINITIALIZED_KEYS;
        PowerAndDuration powerAndDuration = new PowerAndDuration();
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder2.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            if (keys == UNINITIALIZED_KEYS) {
                if (query.isProcessStateDataNeeded()) {
                    keys = app.getKeys(2);
                    powerAndDuration.keys = keys;
                    powerAndDuration.powerPerKeyMah = new double[keys.length];
                } else {
                    keys = null;
                }
            }
            this.calculateApp(app, powerAndDuration, query);
        }
        long measuredChargeUC = batteryStats.getBluetoothMeasuredBatteryConsumptionUC();
        int powerModel = BluetoothPowerCalculator.getPowerModel(measuredChargeUC, query);
        BatteryStats.ControllerActivityCounter activityCounter = batteryStats.getBluetoothControllerActivity();
        this.calculatePowerAndDuration(null, powerModel, measuredChargeUC, activityCounter, query.shouldForceUsePowerProfileModel(), powerAndDuration);
        long systemComponentDurationMs = Math.max(0L, powerAndDuration.durationMs - powerAndDuration.totalDurationMs);
        ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(0).setUsageDurationMillis(2, powerAndDuration.durationMs)).setConsumedPower(2, Math.max(powerAndDuration.powerMah, powerAndDuration.totalPowerMah), powerModel);
        ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(1).setUsageDurationMillis(2, powerAndDuration.totalDurationMs)).setConsumedPower(2, powerAndDuration.totalPowerMah, powerModel);
    }

    private void calculateApp(UidBatteryConsumer.Builder app, PowerAndDuration powerAndDuration, BatteryUsageStatsQuery query) {
        long measuredChargeUC = app.getBatteryStatsUid().getBluetoothMeasuredBatteryConsumptionUC();
        int powerModel = BluetoothPowerCalculator.getPowerModel(measuredChargeUC, query);
        BatteryStats.ControllerActivityCounter activityCounter = app.getBatteryStatsUid().getBluetoothControllerActivity();
        this.calculatePowerAndDuration(app.getBatteryStatsUid(), powerModel, measuredChargeUC, activityCounter, query.shouldForceUsePowerProfileModel(), powerAndDuration);
        ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(2, powerAndDuration.durationMs)).setConsumedPower(2, powerAndDuration.powerMah, powerModel);
        if (!app.isVirtualUid()) {
            powerAndDuration.totalDurationMs += powerAndDuration.durationMs;
            powerAndDuration.totalPowerMah += powerAndDuration.powerMah;
        }
        if (query.isProcessStateDataNeeded() && powerAndDuration.keys != null) {
            for (int j = 0; j < powerAndDuration.keys.length; ++j) {
                BatteryConsumer.Key key = powerAndDuration.keys[j];
                int processState = key.processState;
                if (processState == 0) continue;
                app.setConsumedPower(key, powerAndDuration.powerPerKeyMah[j], powerModel);
            }
        }
    }

    private void calculatePowerAndDuration(BatteryStats.Uid uid, int powerModel, long measuredChargeUC, BatteryStats.ControllerActivityCounter counter, boolean ignoreReportedPower, PowerAndDuration powerAndDuration) {
        if (counter == null) {
            powerAndDuration.durationMs = 0L;
            powerAndDuration.powerMah = 0.0;
            if (powerAndDuration.powerPerKeyMah != null) {
                Arrays.fill(powerAndDuration.powerPerKeyMah, 0.0);
            }
            return;
        }
        BatteryStats.LongCounter idleTimeCounter = counter.getIdleTimeCounter();
        BatteryStats.LongCounter rxTimeCounter = counter.getRxTimeCounter();
        BatteryStats.LongCounter txTimeCounter = counter.getTxTimeCounters()[0];
        long idleTimeMs = idleTimeCounter.getCountLocked(0);
        long rxTimeMs = rxTimeCounter.getCountLocked(0);
        long txTimeMs = txTimeCounter.getCountLocked(0);
        powerAndDuration.durationMs = idleTimeMs + rxTimeMs + txTimeMs;
        if (powerModel == 2) {
            powerAndDuration.powerMah = BluetoothPowerCalculator.uCtoMah(measuredChargeUC);
            if (uid != null && powerAndDuration.keys != null) {
                for (int i = 0; i < powerAndDuration.keys.length; ++i) {
                    BatteryConsumer.Key key = powerAndDuration.keys[i];
                    int processState = key.processState;
                    if (processState == 0) continue;
                    powerAndDuration.powerPerKeyMah[i] = BluetoothPowerCalculator.uCtoMah(uid.getBluetoothMeasuredBatteryConsumptionUC(processState));
                }
            }
        } else {
            double powerMah;
            if (!ignoreReportedPower && (powerMah = (double)counter.getPowerCounter().getCountLocked(0) / 3600000.0) != 0.0) {
                powerAndDuration.powerMah = powerMah;
                if (powerAndDuration.powerPerKeyMah != null) {
                    Arrays.fill(powerAndDuration.powerPerKeyMah, 0.0);
                }
                return;
            }
            if (this.mHasBluetoothPowerController) {
                powerAndDuration.powerMah = this.calculatePowerMah(rxTimeMs, txTimeMs, idleTimeMs);
                if (powerAndDuration.keys != null) {
                    for (int i = 0; i < powerAndDuration.keys.length; ++i) {
                        BatteryConsumer.Key key = powerAndDuration.keys[i];
                        int processState = key.processState;
                        if (processState == 0) continue;
                        powerAndDuration.powerPerKeyMah[i] = this.calculatePowerMah(rxTimeCounter.getCountForProcessState(processState), txTimeCounter.getCountForProcessState(processState), idleTimeCounter.getCountForProcessState(processState));
                    }
                }
            } else {
                powerAndDuration.powerMah = 0.0;
                if (powerAndDuration.powerPerKeyMah != null) {
                    Arrays.fill(powerAndDuration.powerPerKeyMah, 0.0);
                }
            }
        }
    }

    public double calculatePowerMah(long rxTimeMs, long txTimeMs, long idleTimeMs) {
        return ((double)idleTimeMs * this.mIdleMa + (double)rxTimeMs * this.mRxMa + (double)txTimeMs * this.mTxMa) / 3600000.0;
    }

    private static class PowerAndDuration {
        public long durationMs;
        public double powerMah;
        public BatteryConsumer.Key[] keys;
        public double[] powerPerKeyMah;
        public long totalDurationMs;
        public double totalPowerMah;

        private PowerAndDuration() {
        }
    }
}

