/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import java.util.Arrays;

public class CustomMeasuredPowerCalculator
extends PowerCalculator {
    private static final String TAG = "CustomMeasuredPowerCalc";

    public CustomMeasuredPowerCalculator(PowerProfile powerProfile) {
    }

    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return false;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        int i;
        double[] totalAppPowerMah = null;
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder2.getUidBatteryConsumerBuilders();
        for (int i2 = uidBatteryConsumerBuilders.size() - 1; i2 >= 0; --i2) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i2);
            totalAppPowerMah = this.calculateApp(app, app.getBatteryStatsUid(), totalAppPowerMah);
        }
        double[] customMeasuredPowerMah = this.calculateMeasuredEnergiesMah(batteryStats.getCustomConsumerMeasuredBatteryConsumptionUC());
        if (customMeasuredPowerMah != null) {
            AggregateBatteryConsumer.Builder deviceBatteryConsumerBuilder = builder2.getAggregateBatteryConsumerBuilder(0);
            for (i = 0; i < customMeasuredPowerMah.length; ++i) {
                deviceBatteryConsumerBuilder.setConsumedPowerForCustomComponent(1000 + i, customMeasuredPowerMah[i]);
            }
        }
        if (totalAppPowerMah != null) {
            AggregateBatteryConsumer.Builder appsBatteryConsumerBuilder = builder2.getAggregateBatteryConsumerBuilder(1);
            for (i = 0; i < totalAppPowerMah.length; ++i) {
                appsBatteryConsumerBuilder.setConsumedPowerForCustomComponent(1000 + i, totalAppPowerMah[i]);
            }
        }
    }

    private double[] calculateApp(UidBatteryConsumer.Builder app, BatteryStats.Uid u, double[] totalPowerMah) {
        double[] newTotalPowerMah = null;
        double[] customMeasuredPowerMah = this.calculateMeasuredEnergiesMah(u.getCustomConsumerMeasuredBatteryConsumptionUC());
        if (customMeasuredPowerMah != null) {
            if (totalPowerMah == null) {
                newTotalPowerMah = new double[customMeasuredPowerMah.length];
            } else if (totalPowerMah.length != customMeasuredPowerMah.length) {
                Slog.wtf(TAG, "Number of custom energy components is not the same for all apps: " + totalPowerMah.length + ", " + customMeasuredPowerMah.length);
                newTotalPowerMah = Arrays.copyOf(totalPowerMah, customMeasuredPowerMah.length);
            } else {
                newTotalPowerMah = totalPowerMah;
            }
            for (int i = 0; i < customMeasuredPowerMah.length; ++i) {
                app.setConsumedPowerForCustomComponent(1000 + i, customMeasuredPowerMah[i]);
                if (app.isVirtualUid()) continue;
                int n = i;
                newTotalPowerMah[n] = newTotalPowerMah[n] + customMeasuredPowerMah[i];
            }
        }
        return newTotalPowerMah;
    }

    private double[] calculateMeasuredEnergiesMah(long[] measuredChargeUC) {
        if (measuredChargeUC == null) {
            return null;
        }
        double[] measuredEnergiesMah = new double[measuredChargeUC.length];
        for (int i = 0; i < measuredChargeUC.length; ++i) {
            measuredEnergiesMah[i] = CustomMeasuredPowerCalculator.uCtoMah(measuredChargeUC[i]);
        }
        return measuredEnergiesMah;
    }
}

