/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.DropBoxManager;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;

public interface IDropBoxManagerService
extends IInterface {
    public void addData(String var1, byte[] var2, int var3) throws RemoteException;

    public void addFile(String var1, ParcelFileDescriptor var2, int var3) throws RemoteException;

    public boolean isTagEnabled(String var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, publicAlternatives="Use {@link android.os.DropBoxManager#getNextEntry} instead", overrideSourcePosition="frameworks/base/core/java/com/android/internal/os/IDropBoxManagerService.aidl:37:1:38:93")
    public DropBoxManager.Entry getNextEntry(String var1, long var2, String var4) throws RemoteException;

    public DropBoxManager.Entry getNextEntryWithAttribution(String var1, long var2, String var4, String var5) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDropBoxManagerService {
        public static final String DESCRIPTOR = "com.android.internal.os.IDropBoxManagerService";
        static final int TRANSACTION_addData = 1;
        static final int TRANSACTION_addFile = 2;
        static final int TRANSACTION_isTagEnabled = 3;
        static final int TRANSACTION_getNextEntry = 4;
        static final int TRANSACTION_getNextEntryWithAttribution = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDropBoxManagerService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IDropBoxManagerService) {
                return (IDropBoxManagerService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addData";
                }
                case 2: {
                    return "addFile";
                }
                case 3: {
                    return "isTagEnabled";
                }
                case 4: {
                    return "getNextEntry";
                }
                case 5: {
                    return "getNextEntryWithAttribution";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addFile(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isTagEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    DropBoxManager.Entry _result = this.getNextEntry(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    DropBoxManager.Entry _result = this.getNextEntryWithAttribution(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IDropBoxManagerService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addData(String tag2, byte[] data, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(tag2);
                    _data.writeByteArray(data);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addFile(String tag2, ParcelFileDescriptor fd, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(tag2);
                    _data.writeTypedObject(fd, 0);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTagEnabled(String tag2) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(tag2);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DropBoxManager.Entry getNextEntry(String tag2, long millis, String packageName) throws RemoteException {
                DropBoxManager.Entry _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(tag2);
                    _data.writeLong(millis);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DropBoxManager.Entry.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DropBoxManager.Entry getNextEntryWithAttribution(String tag2, long millis, String packageName, String attributionTag) throws RemoteException {
                DropBoxManager.Entry _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(tag2);
                    _data.writeLong(millis);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DropBoxManager.Entry.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IDropBoxManagerService {
        @Override
        public void addData(String tag2, byte[] data, int flags) throws RemoteException {
        }

        @Override
        public void addFile(String tag2, ParcelFileDescriptor fd, int flags) throws RemoteException {
        }

        @Override
        public boolean isTagEnabled(String tag2) throws RemoteException {
            return false;
        }

        @Override
        public DropBoxManager.Entry getNextEntry(String tag2, long millis, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public DropBoxManager.Entry getNextEntryWithAttribution(String tag2, long millis, String packageName, String attributionTag) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

