/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.util.Arrays;

public class KernelSingleProcessCpuThreadReader {
    private static final String TAG = "KernelSingleProcCpuThreadRdr";
    private static final boolean DEBUG = false;
    private final int mPid;
    private final CpuTimeInStateReader mCpuTimeInStateReader;
    private int[] mSelectedThreadNativeTids = new int[0];
    private int mFrequencyCount;
    private boolean mIsTracking;

    @VisibleForTesting
    public KernelSingleProcessCpuThreadReader(int pid, CpuTimeInStateReader cpuTimeInStateReader) throws IOException {
        this.mPid = pid;
        this.mCpuTimeInStateReader = cpuTimeInStateReader;
    }

    public static KernelSingleProcessCpuThreadReader create(int pid) {
        try {
            return new KernelSingleProcessCpuThreadReader(pid, null);
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to initialize KernelSingleProcessCpuThreadReader", e);
            return null;
        }
    }

    public void startTrackingThreadCpuTimes() {
        if (!this.mIsTracking) {
            if (!this.startTrackingProcessCpuTimes(this.mPid, this.mCpuTimeInStateReader)) {
                Slog.e(TAG, "Failed to start tracking process CPU times for " + this.mPid);
            }
            if (this.mSelectedThreadNativeTids.length > 0 && !this.startAggregatingThreadCpuTimes(this.mSelectedThreadNativeTids, this.mCpuTimeInStateReader)) {
                Slog.e(TAG, "Failed to start tracking aggregated thread CPU times for " + Arrays.toString(this.mSelectedThreadNativeTids));
            }
            this.mIsTracking = true;
        }
    }

    public void setSelectedThreadIds(int[] nativeTids) {
        this.mSelectedThreadNativeTids = (int[])nativeTids.clone();
        if (this.mIsTracking) {
            this.startAggregatingThreadCpuTimes(this.mSelectedThreadNativeTids, this.mCpuTimeInStateReader);
        }
    }

    public int getCpuFrequencyCount() {
        if (this.mFrequencyCount == 0) {
            this.mFrequencyCount = this.getCpuFrequencyCount(this.mCpuTimeInStateReader);
        }
        return this.mFrequencyCount;
    }

    public ProcessCpuUsage getProcessCpuUsage() {
        ProcessCpuUsage processCpuUsage = new ProcessCpuUsage(this.getCpuFrequencyCount());
        boolean result = this.readProcessCpuUsage(this.mPid, processCpuUsage.threadCpuTimesMillis, processCpuUsage.selectedThreadCpuTimesMillis, this.mCpuTimeInStateReader);
        if (!result) {
            return null;
        }
        return processCpuUsage;
    }

    private int getCpuFrequencyCount(CpuTimeInStateReader cpuTimeInStateReader) {
        return OverrideMethod.invokeI("com.android.internal.os.KernelSingleProcessCpuThreadReader#getCpuFrequencyCount(Lcom/android/internal/os/KernelSingleProcessCpuThreadReader$CpuTimeInStateReader;)I", true, this);
    }

    private boolean startTrackingProcessCpuTimes(int n, CpuTimeInStateReader cpuTimeInStateReader) {
        return OverrideMethod.invokeI("com.android.internal.os.KernelSingleProcessCpuThreadReader#startTrackingProcessCpuTimes(ILcom/android/internal/os/KernelSingleProcessCpuThreadReader$CpuTimeInStateReader;)Z", true, this) != 0;
    }

    private boolean startAggregatingThreadCpuTimes(int[] nArray, CpuTimeInStateReader cpuTimeInStateReader) {
        return OverrideMethod.invokeI("com.android.internal.os.KernelSingleProcessCpuThreadReader#startAggregatingThreadCpuTimes([ILcom/android/internal/os/KernelSingleProcessCpuThreadReader$CpuTimeInStateReader;)Z", true, this) != 0;
    }

    private boolean readProcessCpuUsage(int n, long[] lArray, long[] lArray2, CpuTimeInStateReader cpuTimeInStateReader) {
        return OverrideMethod.invokeI("com.android.internal.os.KernelSingleProcessCpuThreadReader#readProcessCpuUsage(I[J[JLcom/android/internal/os/KernelSingleProcessCpuThreadReader$CpuTimeInStateReader;)Z", true, this) != 0;
    }

    public static class ProcessCpuUsage {
        public long[] threadCpuTimesMillis;
        public long[] selectedThreadCpuTimesMillis;

        public ProcessCpuUsage(int cpuFrequencyCount) {
            this.threadCpuTimesMillis = new long[cpuFrequencyCount];
            this.selectedThreadCpuTimesMillis = new long[cpuFrequencyCount];
        }
    }

    @VisibleForTesting
    public static interface CpuTimeInStateReader {
        public int getCpuFrequencyCount();

        public boolean startTrackingProcessCpuTimes(int var1);

        public boolean startAggregatingTaskCpuTimes(int var1, int var2);

        public String[] getAggregatedTaskCpuFreqTimes(int var1);
    }
}

