/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.util.LongSparseArray;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;

public class MemoryPowerCalculator
extends PowerCalculator {
    public static final String TAG = "MemoryPowerCalculator";
    private final UsageBasedPowerEstimator[] mPowerEstimators;

    public MemoryPowerCalculator(PowerProfile profile) {
        int numBuckets = profile.getNumElements("memory.bandwidths");
        this.mPowerEstimators = new UsageBasedPowerEstimator[numBuckets];
        for (int i = 0; i < numBuckets; ++i) {
            this.mPowerEstimators[i] = new UsageBasedPowerEstimator(profile.getAveragePower("memory.bandwidths", i));
        }
    }

    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return powerComponent == 13;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        long durationMs = this.calculateDuration(batteryStats, rawRealtimeUs, 0);
        double powerMah = this.calculatePower(batteryStats, rawRealtimeUs, 0);
        ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(0).setUsageDurationMillis(13, durationMs)).setConsumedPower(13, powerMah);
    }

    private long calculateDuration(BatteryStats batteryStats, long rawRealtimeUs, int statsType) {
        long usageDurationMs = 0L;
        LongSparseArray<? extends BatteryStats.Timer> timers = batteryStats.getKernelMemoryStats();
        for (int i = 0; i < timers.size() && i < this.mPowerEstimators.length; ++i) {
            usageDurationMs += this.mPowerEstimators[i].calculateDuration(timers.valueAt(i), rawRealtimeUs, statsType);
        }
        return usageDurationMs;
    }

    private double calculatePower(BatteryStats batteryStats, long rawRealtimeUs, int statsType) {
        double powerMah = 0.0;
        LongSparseArray<? extends BatteryStats.Timer> timers = batteryStats.getKernelMemoryStats();
        for (int i = 0; i < timers.size() && i < this.mPowerEstimators.length; ++i) {
            UsageBasedPowerEstimator estimator = this.mPowerEstimators[(int)timers.keyAt(i)];
            long usageDurationMs = estimator.calculateDuration(timers.valueAt(i), rawRealtimeUs, statsType);
            powerMah += estimator.calculatePower(usageDurationMs);
        }
        return powerMah;
    }
}

