/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.telephony.CellSignalStrength;
import android.util.SparseArray;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;

public class MobileRadioPowerCalculator
extends PowerCalculator {
    private static final String TAG = "MobRadioPowerCalculator";
    private static final boolean DEBUG = false;
    private static final int NUM_SIGNAL_STRENGTH_LEVELS = CellSignalStrength.getNumSignalStrengthLevels();
    private static final BatteryConsumer.Key[] UNINITIALIZED_KEYS = new BatteryConsumer.Key[0];
    private final UsageBasedPowerEstimator mActivePowerEstimator;
    private final UsageBasedPowerEstimator[] mIdlePowerEstimators = new UsageBasedPowerEstimator[NUM_SIGNAL_STRENGTH_LEVELS];
    private final UsageBasedPowerEstimator mScanPowerEstimator;

    public MobileRadioPowerCalculator(PowerProfile profile) {
        int i;
        double powerRadioActiveMa = profile.getAveragePowerOrDefault("radio.active", -1.0);
        if (powerRadioActiveMa == -1.0) {
            double sum = 0.0;
            sum += profile.getAveragePower("modem.controller.rx");
            for (i = 0; i < NUM_SIGNAL_STRENGTH_LEVELS; ++i) {
                sum += profile.getAveragePower("modem.controller.tx", i);
            }
            powerRadioActiveMa = sum / (double)(NUM_SIGNAL_STRENGTH_LEVELS + 1);
        }
        this.mActivePowerEstimator = new UsageBasedPowerEstimator(powerRadioActiveMa);
        if (profile.getAveragePowerOrDefault("radio.on", -1.0) != -1.0) {
            for (int i2 = 0; i2 < NUM_SIGNAL_STRENGTH_LEVELS; ++i2) {
                this.mIdlePowerEstimators[i2] = new UsageBasedPowerEstimator(profile.getAveragePower("radio.on", i2));
            }
        } else {
            double idle = profile.getAveragePower("modem.controller.idle");
            this.mIdlePowerEstimators[0] = new UsageBasedPowerEstimator(idle * 25.0 / 180.0);
            for (i = 1; i < NUM_SIGNAL_STRENGTH_LEVELS; ++i) {
                this.mIdlePowerEstimators[i] = new UsageBasedPowerEstimator(Math.max(1.0, idle / 256.0));
            }
        }
        this.mScanPowerEstimator = new UsageBasedPowerEstimator(profile.getAveragePowerOrDefault("radio.scanning", 0.0));
    }

    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return powerComponent == 8;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        PowerAndDuration total = new PowerAndDuration();
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder2.getUidBatteryConsumerBuilders();
        Object keys = UNINITIALIZED_KEYS;
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            BatteryStats.Uid uid = app.getBatteryStatsUid();
            if (keys == UNINITIALIZED_KEYS) {
                keys = query.isProcessStateDataNeeded() ? app.getKeys(8) : null;
            }
            this.calculateApp(app, uid, total, query, (BatteryConsumer.Key[])keys);
        }
        long totalConsumptionUC = batteryStats.getMobileRadioMeasuredBatteryConsumptionUC();
        int powerModel = MobileRadioPowerCalculator.getPowerModel(totalConsumptionUC, query);
        this.calculateRemaining(total, powerModel, batteryStats, rawRealtimeUs, totalConsumptionUC);
        if (total.remainingPowerMah != 0.0 || total.totalAppPowerMah != 0.0) {
            ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(0).setUsageDurationMillis(8, total.durationMs)).setConsumedPower(8, total.remainingPowerMah + total.totalAppPowerMah, powerModel);
            ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(1).setUsageDurationMillis(8, total.durationMs)).setConsumedPower(8, total.totalAppPowerMah, powerModel);
        }
    }

    private void calculateApp(UidBatteryConsumer.Builder app, BatteryStats.Uid u, PowerAndDuration total, BatteryUsageStatsQuery query, BatteryConsumer.Key[] keys) {
        long radioActiveDurationMs = this.calculateDuration(u, 0);
        long consumptionUC = u.getMobileRadioMeasuredBatteryConsumptionUC();
        int powerModel = MobileRadioPowerCalculator.getPowerModel(consumptionUC, query);
        double powerMah = this.calculatePower(u, powerModel, radioActiveDurationMs, consumptionUC);
        if (!app.isVirtualUid()) {
            total.totalAppDurationMs += radioActiveDurationMs;
            total.totalAppPowerMah += powerMah;
        }
        ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(8, radioActiveDurationMs)).setConsumedPower(8, powerMah, powerModel);
        if (query.isProcessStateDataNeeded() && keys != null) {
            for (BatteryConsumer.Key key : keys) {
                int processState = key.processState;
                if (processState == 0) continue;
                long durationInStateMs = u.getMobileRadioActiveTimeInProcessState(processState) / 1000L;
                long consumptionInStateUc = u.getMobileRadioMeasuredBatteryConsumptionUC(processState);
                double powerInStateMah = this.calculatePower(u, powerModel, durationInStateMs, consumptionInStateUc);
                app.setConsumedPower(key, powerInStateMah, powerModel);
            }
        }
    }

    private long calculateDuration(BatteryStats.Uid u, int statsType) {
        return u.getMobileRadioActiveTime(statsType) / 1000L;
    }

    private double calculatePower(BatteryStats.Uid u, int powerModel, long radioActiveDurationMs, long measuredChargeUC) {
        if (powerModel == 2) {
            return MobileRadioPowerCalculator.uCtoMah(measuredChargeUC);
        }
        if (radioActiveDurationMs > 0L) {
            return this.calcPowerFromRadioActiveDurationMah(radioActiveDurationMs);
        }
        return 0.0;
    }

    private void calculateRemaining(PowerAndDuration total, int powerModel, BatteryStats batteryStats, long rawRealtimeUs, long totalConsumptionUC) {
        long signalTimeMs = 0L;
        double powerMah = 0.0;
        if (powerModel == 2 && (powerMah = MobileRadioPowerCalculator.uCtoMah(totalConsumptionUC) - total.totalAppPowerMah) < 0.0) {
            powerMah = 0.0;
        }
        for (int i = 0; i < NUM_SIGNAL_STRENGTH_LEVELS; ++i) {
            long strengthTimeMs = batteryStats.getPhoneSignalStrengthTime(i, rawRealtimeUs, 0) / 1000L;
            if (powerModel == 1) {
                double p = this.calcIdlePowerAtSignalStrengthMah(strengthTimeMs, i);
                powerMah += p;
            }
            signalTimeMs += strengthTimeMs;
            if (i != 0) continue;
            total.noCoverageDurationMs = strengthTimeMs;
        }
        long scanningTimeMs = batteryStats.getPhoneSignalScanningTime(rawRealtimeUs, 0) / 1000L;
        long radioActiveTimeMs = batteryStats.getMobileRadioActiveTime(rawRealtimeUs, 0) / 1000L;
        long remainingActiveTimeMs = radioActiveTimeMs - total.totalAppDurationMs;
        if (powerModel == 1) {
            double p = this.calcScanTimePowerMah(scanningTimeMs);
            powerMah += p;
            if (remainingActiveTimeMs > 0L) {
                powerMah += this.calcPowerFromRadioActiveDurationMah(remainingActiveTimeMs);
            }
        }
        total.durationMs = radioActiveTimeMs;
        total.remainingPowerMah = powerMah;
        total.signalDurationMs = signalTimeMs;
    }

    public double calcPowerFromRadioActiveDurationMah(long radioActiveDurationMs) {
        return this.mActivePowerEstimator.calculatePower(radioActiveDurationMs);
    }

    public double calcIdlePowerAtSignalStrengthMah(long strengthTimeMs, int strengthLevel) {
        return this.mIdlePowerEstimators[strengthLevel].calculatePower(strengthTimeMs);
    }

    public double calcScanTimePowerMah(long scanningTimeMs) {
        return this.mScanPowerEstimator.calculatePower(scanningTimeMs);
    }

    private static class PowerAndDuration {
        public long durationMs;
        public double remainingPowerMah;
        public long totalAppDurationMs;
        public double totalAppPowerMah;
        public long signalDurationMs;
        public long noCoverageDurationMs;

        private PowerAndDuration() {
        }
    }
}

