/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;

public class PhonePowerCalculator
extends PowerCalculator {
    private final UsageBasedPowerEstimator mPowerEstimator;

    public PhonePowerCalculator(PowerProfile powerProfile) {
        this.mPowerEstimator = new UsageBasedPowerEstimator(powerProfile.getAveragePower("radio.active"));
    }

    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return powerComponent == 14;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        long phoneOnTimeMs = batteryStats.getPhoneOnTime(rawRealtimeUs, 0) / 1000L;
        double phoneOnPower = this.mPowerEstimator.calculatePower(phoneOnTimeMs);
        if (phoneOnPower != 0.0) {
            ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(0).setConsumedPower(14, phoneOnPower)).setUsageDurationMillis(14, phoneOnTimeMs);
        }
    }
}

