/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.util.SparseArray;
import java.io.PrintWriter;

public abstract class PowerCalculator {
    protected static final boolean DEBUG = false;
    protected static final double MILLIAMPHOUR_PER_MICROCOULOMB = 2.777777777777778E-7;

    public abstract boolean isPowerComponentSupported(int var1);

    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder2.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            this.calculateApp(app, app.getBatteryStatsUid(), rawRealtimeUs, rawUptimeUs, query);
        }
    }

    protected void calculateApp(UidBatteryConsumer.Builder app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
    }

    public void reset() {
    }

    protected static int getPowerModel(long measuredEnergyUC, BatteryUsageStatsQuery query) {
        if (measuredEnergyUC != -1L && !query.shouldForceUsePowerProfileModel()) {
            return 2;
        }
        return 1;
    }

    protected static int getPowerModel(long measuredEnergyUC) {
        return measuredEnergyUC != -1L ? 2 : 1;
    }

    public static void printPowerMah(PrintWriter pw, double powerMah) {
        pw.print(BatteryStats.formatCharge(powerMah));
    }

    static double uCtoMah(long chargeUC) {
        return (double)chargeUC * 2.777777777777778E-7;
    }
}

