/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseLongArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;

public class ScreenPowerCalculator
extends PowerCalculator {
    private static final String TAG = "ScreenPowerCalculator";
    private static final boolean DEBUG = false;
    public static final long MIN_ACTIVE_TIME_FOR_SMEARING = 600000L;
    private final UsageBasedPowerEstimator[] mScreenOnPowerEstimators;
    private final UsageBasedPowerEstimator[] mScreenFullPowerEstimators;

    public ScreenPowerCalculator(PowerProfile powerProfile) {
        int numDisplays = powerProfile.getNumDisplays();
        this.mScreenOnPowerEstimators = new UsageBasedPowerEstimator[numDisplays];
        this.mScreenFullPowerEstimators = new UsageBasedPowerEstimator[numDisplays];
        for (int display = 0; display < numDisplays; ++display) {
            this.mScreenOnPowerEstimators[display] = new UsageBasedPowerEstimator(powerProfile.getAveragePowerForOrdinal("screen.on.display", display));
            this.mScreenFullPowerEstimators[display] = new UsageBasedPowerEstimator(powerProfile.getAveragePowerForOrdinal("screen.full.display", display));
        }
    }

    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return powerComponent == 0;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        PowerAndDuration totalPowerAndDuration = new PowerAndDuration();
        long consumptionUC = batteryStats.getScreenOnMeasuredBatteryConsumptionUC();
        int powerModel = ScreenPowerCalculator.getPowerModel(consumptionUC, query);
        this.calculateTotalDurationAndPower(totalPowerAndDuration, powerModel, batteryStats, rawRealtimeUs, 0, consumptionUC);
        double totalAppPower = 0.0;
        long totalAppDuration = 0L;
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder2.getUidBatteryConsumerBuilders();
        switch (powerModel) {
            case 2: {
                PowerAndDuration appPowerAndDuration = new PowerAndDuration();
                for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
                    UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
                    this.calculateAppUsingMeasuredEnergy(appPowerAndDuration, app.getBatteryStatsUid(), rawRealtimeUs);
                    ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(0, appPowerAndDuration.durationMs)).setConsumedPower(0, appPowerAndDuration.powerMah, powerModel);
                    if (app.isVirtualUid()) continue;
                    totalAppPower += appPowerAndDuration.powerMah;
                    totalAppDuration += appPowerAndDuration.durationMs;
                }
                break;
            }
            default: {
                this.smearScreenBatteryDrain(uidBatteryConsumerBuilders, totalPowerAndDuration, rawRealtimeUs);
                totalAppPower = totalPowerAndDuration.powerMah;
                totalAppDuration = totalPowerAndDuration.durationMs;
            }
        }
        ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(0).setConsumedPower(0, Math.max(totalPowerAndDuration.powerMah, totalAppPower), powerModel)).setUsageDurationMillis(0, totalPowerAndDuration.durationMs);
        ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(1).setConsumedPower(0, totalAppPower, powerModel)).setUsageDurationMillis(0, totalAppDuration);
    }

    private void calculateTotalDurationAndPower(PowerAndDuration totalPowerAndDuration, int powerModel, BatteryStats batteryStats, long rawRealtimeUs, int statsType, long consumptionUC) {
        totalPowerAndDuration.durationMs = this.calculateDuration(batteryStats, rawRealtimeUs, statsType);
        switch (powerModel) {
            case 2: {
                totalPowerAndDuration.powerMah = ScreenPowerCalculator.uCtoMah(consumptionUC);
                break;
            }
            default: {
                totalPowerAndDuration.powerMah = this.calculateTotalPowerFromBrightness(batteryStats, rawRealtimeUs);
            }
        }
    }

    private void calculateAppUsingMeasuredEnergy(PowerAndDuration appPowerAndDuration, BatteryStats.Uid u, long rawRealtimeUs) {
        appPowerAndDuration.durationMs = this.getProcessForegroundTimeMs(u, rawRealtimeUs);
        long chargeUC = u.getScreenOnMeasuredBatteryConsumptionUC();
        if (chargeUC < 0L) {
            Slog.wtf(TAG, "Screen energy not supported, so calculateApp shouldn't de called");
            appPowerAndDuration.powerMah = 0.0;
            return;
        }
        appPowerAndDuration.powerMah = ScreenPowerCalculator.uCtoMah(chargeUC);
    }

    private long calculateDuration(BatteryStats batteryStats, long rawRealtimeUs, int statsType) {
        return batteryStats.getScreenOnTime(rawRealtimeUs, statsType) / 1000L;
    }

    private double calculateTotalPowerFromBrightness(BatteryStats batteryStats, long rawRealtimeUs) {
        int numDisplays = this.mScreenOnPowerEstimators.length;
        double power = 0.0;
        for (int display = 0; display < numDisplays; ++display) {
            long displayTime = batteryStats.getDisplayScreenOnTime(display, rawRealtimeUs) / 1000L;
            power += this.mScreenOnPowerEstimators[display].calculatePower(displayTime);
            for (int bin = 0; bin < 5; ++bin) {
                long brightnessTime = batteryStats.getDisplayScreenBrightnessTime(display, bin, rawRealtimeUs) / 1000L;
                double binPowerMah = this.mScreenFullPowerEstimators[display].calculatePower(brightnessTime) * (double)((float)bin + 0.5f) / 5.0;
                power += binPowerMah;
            }
        }
        return power;
    }

    private void smearScreenBatteryDrain(SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders, PowerAndDuration totalPowerAndDuration, long rawRealtimeUs) {
        long totalActivityTimeMs = 0L;
        SparseLongArray activityTimeArray = new SparseLongArray();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            BatteryStats.Uid uid = app.getBatteryStatsUid();
            long timeMs = this.getProcessForegroundTimeMs(uid, rawRealtimeUs);
            activityTimeArray.put(uid.getUid(), timeMs);
            if (app.isVirtualUid()) continue;
            totalActivityTimeMs += timeMs;
        }
        if (totalActivityTimeMs >= 600000L) {
            double totalScreenPowerMah = totalPowerAndDuration.powerMah;
            for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
                UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
                long durationMs = activityTimeArray.get(app.getUid(), 0L);
                double powerMah = totalScreenPowerMah * (double)durationMs / (double)totalActivityTimeMs;
                ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(0, durationMs)).setConsumedPower(0, powerMah, 1);
            }
        }
    }

    @VisibleForTesting
    public long getProcessForegroundTimeMs(BatteryStats.Uid uid, long rawRealTimeUs) {
        int[] foregroundTypes = new int[]{0};
        long timeUs = 0L;
        for (int type : foregroundTypes) {
            long localTime = uid.getProcessStateTime(type, rawRealTimeUs, 0);
            timeUs += localTime;
        }
        return Math.min(timeUs, this.getForegroundActivityTotalTimeUs(uid, rawRealTimeUs)) / 1000L;
    }

    @VisibleForTesting
    public long getForegroundActivityTotalTimeUs(BatteryStats.Uid uid, long rawRealtimeUs) {
        BatteryStats.Timer timer = uid.getForegroundActivityTimer();
        if (timer == null) {
            return 0L;
        }
        return timer.getTotalTimeLocked(rawRealtimeUs, 0);
    }

    private static class PowerAndDuration {
        public long durationMs;
        public double powerMah;

        private PowerAndDuration() {
        }
    }
}

