/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.os.UserHandle;
import android.util.SparseArray;
import com.android.internal.os.PowerCalculator;
import com.android.internal.util.ArrayUtils;

public class UserPowerCalculator
extends PowerCalculator {
    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return true;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        int[] userIds = query.getUserIds();
        if (ArrayUtils.contains(userIds, -1)) {
            return;
        }
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder2.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            int userId;
            int uid;
            UidBatteryConsumer.Builder uidBuilder = uidBatteryConsumerBuilders.valueAt(i);
            if (uidBuilder.isVirtualUid() || UserHandle.getAppId(uid = uidBuilder.getUid()) < 10000 || ArrayUtils.contains(userIds, userId = UserHandle.getUserId(uid))) continue;
            uidBuilder.excludeFromBatteryUsageStats();
            builder2.getOrCreateUserBatteryConsumerBuilder(userId).addUidBatteryConsumer(uidBuilder);
        }
    }
}

