/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.util.SparseArray;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;
import java.util.Arrays;

public class WifiPowerCalculator
extends PowerCalculator {
    private static final boolean DEBUG = false;
    private static final String TAG = "WifiPowerCalculator";
    private static final BatteryConsumer.Key[] UNINITIALIZED_KEYS = new BatteryConsumer.Key[0];
    private final UsageBasedPowerEstimator mIdlePowerEstimator;
    private final UsageBasedPowerEstimator mTxPowerEstimator;
    private final UsageBasedPowerEstimator mRxPowerEstimator;
    private final UsageBasedPowerEstimator mPowerOnPowerEstimator;
    private final UsageBasedPowerEstimator mScanPowerEstimator;
    private final UsageBasedPowerEstimator mBatchScanPowerEstimator;
    private final boolean mHasWifiPowerController;
    private final double mWifiPowerPerPacket;

    public WifiPowerCalculator(PowerProfile profile) {
        this.mPowerOnPowerEstimator = new UsageBasedPowerEstimator(profile.getAveragePower("wifi.on"));
        this.mScanPowerEstimator = new UsageBasedPowerEstimator(profile.getAveragePower("wifi.scan"));
        this.mBatchScanPowerEstimator = new UsageBasedPowerEstimator(profile.getAveragePower("wifi.batchedscan"));
        this.mIdlePowerEstimator = new UsageBasedPowerEstimator(profile.getAveragePower("wifi.controller.idle"));
        this.mTxPowerEstimator = new UsageBasedPowerEstimator(profile.getAveragePower("wifi.controller.tx"));
        this.mRxPowerEstimator = new UsageBasedPowerEstimator(profile.getAveragePower("wifi.controller.rx"));
        this.mWifiPowerPerPacket = WifiPowerCalculator.getWifiPowerPerPacket(profile);
        this.mHasWifiPowerController = this.mIdlePowerEstimator.isSupported() && this.mTxPowerEstimator.isSupported() && this.mRxPowerEstimator.isSupported();
    }

    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return powerComponent == 11;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        BatteryConsumer.Key[] keys = UNINITIALIZED_KEYS;
        long totalAppDurationMs = 0L;
        double totalAppPowerMah = 0.0;
        PowerDurationAndTraffic powerDurationAndTraffic = new PowerDurationAndTraffic();
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder2.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            if (keys == UNINITIALIZED_KEYS) {
                if (query.isProcessStateDataNeeded()) {
                    keys = app.getKeys(11);
                    powerDurationAndTraffic.keys = keys;
                    powerDurationAndTraffic.powerPerKeyMah = new double[keys.length];
                } else {
                    keys = null;
                }
            }
            long consumptionUC = app.getBatteryStatsUid().getWifiMeasuredBatteryConsumptionUC();
            int powerModel = WifiPowerCalculator.getPowerModel(consumptionUC, query);
            this.calculateApp(powerDurationAndTraffic, app.getBatteryStatsUid(), powerModel, rawRealtimeUs, 0, batteryStats.hasWifiActivityReporting(), consumptionUC);
            if (!app.isVirtualUid()) {
                totalAppDurationMs += powerDurationAndTraffic.durationMs;
                totalAppPowerMah += powerDurationAndTraffic.powerMah;
            }
            app.setUsageDurationMillis(11, powerDurationAndTraffic.durationMs);
            app.setConsumedPower(11, powerDurationAndTraffic.powerMah, powerModel);
            if (!query.isProcessStateDataNeeded() || keys == null) continue;
            for (int j = 0; j < keys.length; ++j) {
                BatteryConsumer.Key key = keys[j];
                int processState = key.processState;
                if (processState == 0) continue;
                app.setConsumedPower(key, powerDurationAndTraffic.powerPerKeyMah[j], powerModel);
            }
        }
        long consumptionUC = batteryStats.getWifiMeasuredBatteryConsumptionUC();
        int powerModel = WifiPowerCalculator.getPowerModel(consumptionUC, query);
        this.calculateRemaining(powerDurationAndTraffic, powerModel, batteryStats, rawRealtimeUs, 0, batteryStats.hasWifiActivityReporting(), totalAppDurationMs, totalAppPowerMah, consumptionUC);
        ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(0).setUsageDurationMillis(11, powerDurationAndTraffic.durationMs)).setConsumedPower(11, totalAppPowerMah + powerDurationAndTraffic.powerMah, powerModel);
        builder2.getAggregateBatteryConsumerBuilder(1).setConsumedPower(11, totalAppPowerMah, powerModel);
    }

    private void calculateApp(PowerDurationAndTraffic powerDurationAndTraffic, BatteryStats.Uid u, int powerModel, long rawRealtimeUs, int statsType, boolean hasWifiActivityReporting, long consumptionUC) {
        powerDurationAndTraffic.wifiRxPackets = u.getNetworkActivityPackets(2, statsType);
        powerDurationAndTraffic.wifiTxPackets = u.getNetworkActivityPackets(3, statsType);
        powerDurationAndTraffic.wifiRxBytes = u.getNetworkActivityBytes(2, statsType);
        powerDurationAndTraffic.wifiTxBytes = u.getNetworkActivityBytes(3, statsType);
        if (hasWifiActivityReporting && this.mHasWifiPowerController) {
            BatteryStats.ControllerActivityCounter counter = u.getWifiControllerActivity();
            if (counter != null) {
                BatteryStats.LongCounter rxTimeCounter = counter.getRxTimeCounter();
                BatteryStats.LongCounter txTimeCounter = counter.getTxTimeCounters()[0];
                BatteryStats.LongCounter idleTimeCounter = counter.getIdleTimeCounter();
                long rxTime = rxTimeCounter.getCountLocked(statsType);
                long txTime = txTimeCounter.getCountLocked(statsType);
                long idleTime = idleTimeCounter.getCountLocked(statsType);
                powerDurationAndTraffic.durationMs = idleTime + rxTime + txTime;
                powerDurationAndTraffic.powerMah = powerModel == 1 ? this.calcPowerFromControllerDataMah(rxTime, txTime, idleTime) : WifiPowerCalculator.uCtoMah(consumptionUC);
                if (powerDurationAndTraffic.keys != null) {
                    for (int i = 0; i < powerDurationAndTraffic.keys.length; ++i) {
                        int processState = powerDurationAndTraffic.keys[i].processState;
                        if (processState == 0) continue;
                        powerDurationAndTraffic.powerPerKeyMah[i] = powerModel == 1 ? this.calcPowerFromControllerDataMah(rxTimeCounter.getCountForProcessState(processState), txTimeCounter.getCountForProcessState(processState), idleTimeCounter.getCountForProcessState(processState)) : WifiPowerCalculator.uCtoMah(u.getWifiMeasuredBatteryConsumptionUC(processState));
                    }
                }
            } else {
                powerDurationAndTraffic.durationMs = 0L;
                powerDurationAndTraffic.powerMah = 0.0;
                if (powerDurationAndTraffic.powerPerKeyMah != null) {
                    Arrays.fill(powerDurationAndTraffic.powerPerKeyMah, 0.0);
                }
            }
        } else {
            long wifiRunningTime;
            powerDurationAndTraffic.durationMs = wifiRunningTime = u.getWifiRunningTime(rawRealtimeUs, statsType) / 1000L;
            if (powerModel == 1) {
                long wifiScanTimeMs = u.getWifiScanTime(rawRealtimeUs, statsType) / 1000L;
                long batchTimeMs = 0L;
                for (int bin = 0; bin < 5; ++bin) {
                    batchTimeMs += u.getWifiBatchedScanTime(bin, rawRealtimeUs, statsType) / 1000L;
                }
                powerDurationAndTraffic.powerMah = this.calcPowerWithoutControllerDataMah(powerDurationAndTraffic.wifiRxPackets, powerDurationAndTraffic.wifiTxPackets, wifiRunningTime, wifiScanTimeMs, batchTimeMs);
            } else {
                powerDurationAndTraffic.powerMah = WifiPowerCalculator.uCtoMah(consumptionUC);
            }
            if (powerDurationAndTraffic.powerPerKeyMah != null) {
                Arrays.fill(powerDurationAndTraffic.powerPerKeyMah, 0.0);
            }
        }
    }

    private void calculateRemaining(PowerDurationAndTraffic powerDurationAndTraffic, int powerModel, BatteryStats stats, long rawRealtimeUs, int statsType, boolean hasWifiActivityReporting, long totalAppDurationMs, double totalAppPowerMah, long consumptionUC) {
        long totalDurationMs;
        double totalPowerMah = 0.0;
        if (powerModel == 2) {
            totalPowerMah = WifiPowerCalculator.uCtoMah(consumptionUC);
        }
        if (hasWifiActivityReporting && this.mHasWifiPowerController) {
            BatteryStats.ControllerActivityCounter counter = stats.getWifiControllerActivity();
            long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(statsType);
            long txTimeMs = counter.getTxTimeCounters()[0].getCountLocked(statsType);
            long rxTimeMs = counter.getRxTimeCounter().getCountLocked(statsType);
            totalDurationMs = idleTimeMs + rxTimeMs + txTimeMs;
            if (powerModel == 1 && (totalPowerMah = (double)counter.getPowerCounter().getCountLocked(statsType) / 3600000.0) == 0.0) {
                totalPowerMah = this.calcPowerFromControllerDataMah(rxTimeMs, txTimeMs, idleTimeMs);
            }
        } else {
            totalDurationMs = stats.getGlobalWifiRunningTime(rawRealtimeUs, statsType) / 1000L;
            if (powerModel == 1) {
                totalPowerMah = this.calcGlobalPowerWithoutControllerDataMah(totalDurationMs);
            }
        }
        powerDurationAndTraffic.durationMs = Math.max(0L, totalDurationMs - totalAppDurationMs);
        powerDurationAndTraffic.powerMah = Math.max(0.0, totalPowerMah - totalAppPowerMah);
    }

    public double calcPowerFromControllerDataMah(long rxTimeMs, long txTimeMs, long idleTimeMs) {
        return this.mRxPowerEstimator.calculatePower(rxTimeMs) + this.mTxPowerEstimator.calculatePower(txTimeMs) + this.mIdlePowerEstimator.calculatePower(idleTimeMs);
    }

    public double calcPowerWithoutControllerDataMah(long rxPackets, long txPackets, long wifiRunningTimeMs, long wifiScanTimeMs, long wifiBatchScanTimeMs) {
        return (double)(rxPackets + txPackets) * this.mWifiPowerPerPacket + this.mPowerOnPowerEstimator.calculatePower(wifiRunningTimeMs) + this.mScanPowerEstimator.calculatePower(wifiScanTimeMs) + this.mBatchScanPowerEstimator.calculatePower(wifiBatchScanTimeMs);
    }

    public double calcGlobalPowerWithoutControllerDataMah(long globalWifiRunningTimeMs) {
        return this.mPowerOnPowerEstimator.calculatePower(globalWifiRunningTimeMs);
    }

    private static double getWifiPowerPerPacket(PowerProfile profile) {
        long wifiBps = 1000000L;
        double averageWifiActivePower = profile.getAveragePower("wifi.active") / 3600.0;
        return averageWifiActivePower / 61.03515625;
    }

    private static class PowerDurationAndTraffic {
        public double powerMah;
        public long durationMs;
        public long wifiRxPackets;
        public long wifiTxPackets;
        public long wifiRxBytes;
        public long wifiTxBytes;
        public BatteryConsumer.Key[] keys;
        public double[] powerPerKeyMah;

        private PowerDurationAndTraffic() {
        }
    }
}

