/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.app.ITransientNotificationCallback;
import android.content.ComponentName;
import android.graphics.drawable.Icon;
import android.hardware.biometrics.IBiometricContextListener;
import android.hardware.biometrics.IBiometricSysuiReceiver;
import android.hardware.biometrics.PromptInfo;
import android.hardware.fingerprint.IUdfpsHbmListener;
import android.media.INearbyMediaDevicesProvider;
import android.media.MediaRoute2Info;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.InsetsVisibilities;
import com.android.internal.statusbar.IAddTileResultCallback;
import com.android.internal.statusbar.IUndoMediaTransferCallback;
import com.android.internal.statusbar.StatusBarIcon;
import com.android.internal.view.AppearanceRegion;

public interface IStatusBar
extends IInterface {
    public void setIcon(String var1, StatusBarIcon var2) throws RemoteException;

    public void removeIcon(String var1) throws RemoteException;

    public void disable(int var1, int var2, int var3) throws RemoteException;

    public void animateExpandNotificationsPanel() throws RemoteException;

    public void animateExpandSettingsPanel(String var1) throws RemoteException;

    public void animateCollapsePanels() throws RemoteException;

    public void togglePanel() throws RemoteException;

    public void showWirelessChargingAnimation(int var1) throws RemoteException;

    public void setImeWindowStatus(int var1, IBinder var2, int var3, int var4, boolean var5) throws RemoteException;

    public void setWindowState(int var1, int var2, int var3) throws RemoteException;

    public void showRecentApps(boolean var1) throws RemoteException;

    public void hideRecentApps(boolean var1, boolean var2) throws RemoteException;

    public void toggleRecentApps() throws RemoteException;

    public void toggleSplitScreen() throws RemoteException;

    public void preloadRecentApps() throws RemoteException;

    public void cancelPreloadRecentApps() throws RemoteException;

    public void showScreenPinningRequest(int var1) throws RemoteException;

    public void dismissKeyboardShortcutsMenu() throws RemoteException;

    public void toggleKeyboardShortcutsMenu(int var1) throws RemoteException;

    public void appTransitionPending(int var1) throws RemoteException;

    public void appTransitionCancelled(int var1) throws RemoteException;

    public void appTransitionStarting(int var1, long var2, long var4) throws RemoteException;

    public void appTransitionFinished(int var1) throws RemoteException;

    public void showAssistDisclosure() throws RemoteException;

    public void startAssist(Bundle var1) throws RemoteException;

    public void onCameraLaunchGestureDetected(int var1) throws RemoteException;

    public void onEmergencyActionLaunchGestureDetected() throws RemoteException;

    public void showPictureInPictureMenu() throws RemoteException;

    public void showGlobalActionsMenu() throws RemoteException;

    public void onProposedRotationChanged(int var1, boolean var2) throws RemoteException;

    public void setTopAppHidesStatusBar(boolean var1) throws RemoteException;

    public void addQsTile(ComponentName var1) throws RemoteException;

    public void remQsTile(ComponentName var1) throws RemoteException;

    public void clickQsTile(ComponentName var1) throws RemoteException;

    public void handleSystemKey(int var1) throws RemoteException;

    public void showPinningEnterExitToast(boolean var1) throws RemoteException;

    public void showPinningEscapeToast() throws RemoteException;

    public void showShutdownUi(boolean var1, String var2) throws RemoteException;

    public void showAuthenticationDialog(PromptInfo var1, IBiometricSysuiReceiver var2, int[] var3, boolean var4, boolean var5, int var6, long var7, String var9, long var10, int var12) throws RemoteException;

    public void onBiometricAuthenticated(int var1) throws RemoteException;

    public void onBiometricHelp(int var1, String var2) throws RemoteException;

    public void onBiometricError(int var1, int var2, int var3) throws RemoteException;

    public void hideAuthenticationDialog(long var1) throws RemoteException;

    public void setBiometicContextListener(IBiometricContextListener var1) throws RemoteException;

    public void setUdfpsHbmListener(IUdfpsHbmListener var1) throws RemoteException;

    public void onDisplayReady(int var1) throws RemoteException;

    public void onRecentsAnimationStateChanged(boolean var1) throws RemoteException;

    public void onSystemBarAttributesChanged(int var1, int var2, AppearanceRegion[] var3, boolean var4, int var5, InsetsVisibilities var6, String var7) throws RemoteException;

    public void showTransient(int var1, int[] var2, boolean var3) throws RemoteException;

    public void abortTransient(int var1, int[] var2) throws RemoteException;

    public void showInattentiveSleepWarning() throws RemoteException;

    public void dismissInattentiveSleepWarning(boolean var1) throws RemoteException;

    public void showToast(int var1, String var2, IBinder var3, CharSequence var4, IBinder var5, int var6, ITransientNotificationCallback var7, int var8) throws RemoteException;

    public void hideToast(String var1, IBinder var2) throws RemoteException;

    public void startTracing() throws RemoteException;

    public void stopTracing() throws RemoteException;

    public void handleWindowManagerLoggingCommand(String[] var1, ParcelFileDescriptor var2) throws RemoteException;

    public void suppressAmbientDisplay(boolean var1) throws RemoteException;

    public void requestWindowMagnificationConnection(boolean var1) throws RemoteException;

    public void passThroughShellCommand(String[] var1, ParcelFileDescriptor var2) throws RemoteException;

    public void setNavigationBarLumaSamplingEnabled(int var1, boolean var2) throws RemoteException;

    public void runGcForTest() throws RemoteException;

    public void requestTileServiceListeningState(ComponentName var1) throws RemoteException;

    public void requestAddTile(ComponentName var1, CharSequence var2, CharSequence var3, Icon var4, IAddTileResultCallback var5) throws RemoteException;

    public void cancelRequestAddTile(String var1) throws RemoteException;

    public void updateMediaTapToTransferSenderDisplay(int var1, MediaRoute2Info var2, IUndoMediaTransferCallback var3) throws RemoteException;

    public void updateMediaTapToTransferReceiverDisplay(int var1, MediaRoute2Info var2, Icon var3, CharSequence var4) throws RemoteException;

    public void registerNearbyMediaDevicesProvider(INearbyMediaDevicesProvider var1) throws RemoteException;

    public void unregisterNearbyMediaDevicesProvider(INearbyMediaDevicesProvider var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatusBar {
        public static final String DESCRIPTOR = "com.android.internal.statusbar.IStatusBar";
        static final int TRANSACTION_setIcon = 1;
        static final int TRANSACTION_removeIcon = 2;
        static final int TRANSACTION_disable = 3;
        static final int TRANSACTION_animateExpandNotificationsPanel = 4;
        static final int TRANSACTION_animateExpandSettingsPanel = 5;
        static final int TRANSACTION_animateCollapsePanels = 6;
        static final int TRANSACTION_togglePanel = 7;
        static final int TRANSACTION_showWirelessChargingAnimation = 8;
        static final int TRANSACTION_setImeWindowStatus = 9;
        static final int TRANSACTION_setWindowState = 10;
        static final int TRANSACTION_showRecentApps = 11;
        static final int TRANSACTION_hideRecentApps = 12;
        static final int TRANSACTION_toggleRecentApps = 13;
        static final int TRANSACTION_toggleSplitScreen = 14;
        static final int TRANSACTION_preloadRecentApps = 15;
        static final int TRANSACTION_cancelPreloadRecentApps = 16;
        static final int TRANSACTION_showScreenPinningRequest = 17;
        static final int TRANSACTION_dismissKeyboardShortcutsMenu = 18;
        static final int TRANSACTION_toggleKeyboardShortcutsMenu = 19;
        static final int TRANSACTION_appTransitionPending = 20;
        static final int TRANSACTION_appTransitionCancelled = 21;
        static final int TRANSACTION_appTransitionStarting = 22;
        static final int TRANSACTION_appTransitionFinished = 23;
        static final int TRANSACTION_showAssistDisclosure = 24;
        static final int TRANSACTION_startAssist = 25;
        static final int TRANSACTION_onCameraLaunchGestureDetected = 26;
        static final int TRANSACTION_onEmergencyActionLaunchGestureDetected = 27;
        static final int TRANSACTION_showPictureInPictureMenu = 28;
        static final int TRANSACTION_showGlobalActionsMenu = 29;
        static final int TRANSACTION_onProposedRotationChanged = 30;
        static final int TRANSACTION_setTopAppHidesStatusBar = 31;
        static final int TRANSACTION_addQsTile = 32;
        static final int TRANSACTION_remQsTile = 33;
        static final int TRANSACTION_clickQsTile = 34;
        static final int TRANSACTION_handleSystemKey = 35;
        static final int TRANSACTION_showPinningEnterExitToast = 36;
        static final int TRANSACTION_showPinningEscapeToast = 37;
        static final int TRANSACTION_showShutdownUi = 38;
        static final int TRANSACTION_showAuthenticationDialog = 39;
        static final int TRANSACTION_onBiometricAuthenticated = 40;
        static final int TRANSACTION_onBiometricHelp = 41;
        static final int TRANSACTION_onBiometricError = 42;
        static final int TRANSACTION_hideAuthenticationDialog = 43;
        static final int TRANSACTION_setBiometicContextListener = 44;
        static final int TRANSACTION_setUdfpsHbmListener = 45;
        static final int TRANSACTION_onDisplayReady = 46;
        static final int TRANSACTION_onRecentsAnimationStateChanged = 47;
        static final int TRANSACTION_onSystemBarAttributesChanged = 48;
        static final int TRANSACTION_showTransient = 49;
        static final int TRANSACTION_abortTransient = 50;
        static final int TRANSACTION_showInattentiveSleepWarning = 51;
        static final int TRANSACTION_dismissInattentiveSleepWarning = 52;
        static final int TRANSACTION_showToast = 53;
        static final int TRANSACTION_hideToast = 54;
        static final int TRANSACTION_startTracing = 55;
        static final int TRANSACTION_stopTracing = 56;
        static final int TRANSACTION_handleWindowManagerLoggingCommand = 57;
        static final int TRANSACTION_suppressAmbientDisplay = 58;
        static final int TRANSACTION_requestWindowMagnificationConnection = 59;
        static final int TRANSACTION_passThroughShellCommand = 60;
        static final int TRANSACTION_setNavigationBarLumaSamplingEnabled = 61;
        static final int TRANSACTION_runGcForTest = 62;
        static final int TRANSACTION_requestTileServiceListeningState = 63;
        static final int TRANSACTION_requestAddTile = 64;
        static final int TRANSACTION_cancelRequestAddTile = 65;
        static final int TRANSACTION_updateMediaTapToTransferSenderDisplay = 66;
        static final int TRANSACTION_updateMediaTapToTransferReceiverDisplay = 67;
        static final int TRANSACTION_registerNearbyMediaDevicesProvider = 68;
        static final int TRANSACTION_unregisterNearbyMediaDevicesProvider = 69;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IStatusBar asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IStatusBar) {
                return (IStatusBar)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setIcon";
                }
                case 2: {
                    return "removeIcon";
                }
                case 3: {
                    return "disable";
                }
                case 4: {
                    return "animateExpandNotificationsPanel";
                }
                case 5: {
                    return "animateExpandSettingsPanel";
                }
                case 6: {
                    return "animateCollapsePanels";
                }
                case 7: {
                    return "togglePanel";
                }
                case 8: {
                    return "showWirelessChargingAnimation";
                }
                case 9: {
                    return "setImeWindowStatus";
                }
                case 10: {
                    return "setWindowState";
                }
                case 11: {
                    return "showRecentApps";
                }
                case 12: {
                    return "hideRecentApps";
                }
                case 13: {
                    return "toggleRecentApps";
                }
                case 14: {
                    return "toggleSplitScreen";
                }
                case 15: {
                    return "preloadRecentApps";
                }
                case 16: {
                    return "cancelPreloadRecentApps";
                }
                case 17: {
                    return "showScreenPinningRequest";
                }
                case 18: {
                    return "dismissKeyboardShortcutsMenu";
                }
                case 19: {
                    return "toggleKeyboardShortcutsMenu";
                }
                case 20: {
                    return "appTransitionPending";
                }
                case 21: {
                    return "appTransitionCancelled";
                }
                case 22: {
                    return "appTransitionStarting";
                }
                case 23: {
                    return "appTransitionFinished";
                }
                case 24: {
                    return "showAssistDisclosure";
                }
                case 25: {
                    return "startAssist";
                }
                case 26: {
                    return "onCameraLaunchGestureDetected";
                }
                case 27: {
                    return "onEmergencyActionLaunchGestureDetected";
                }
                case 28: {
                    return "showPictureInPictureMenu";
                }
                case 29: {
                    return "showGlobalActionsMenu";
                }
                case 30: {
                    return "onProposedRotationChanged";
                }
                case 31: {
                    return "setTopAppHidesStatusBar";
                }
                case 32: {
                    return "addQsTile";
                }
                case 33: {
                    return "remQsTile";
                }
                case 34: {
                    return "clickQsTile";
                }
                case 35: {
                    return "handleSystemKey";
                }
                case 36: {
                    return "showPinningEnterExitToast";
                }
                case 37: {
                    return "showPinningEscapeToast";
                }
                case 38: {
                    return "showShutdownUi";
                }
                case 39: {
                    return "showAuthenticationDialog";
                }
                case 40: {
                    return "onBiometricAuthenticated";
                }
                case 41: {
                    return "onBiometricHelp";
                }
                case 42: {
                    return "onBiometricError";
                }
                case 43: {
                    return "hideAuthenticationDialog";
                }
                case 44: {
                    return "setBiometicContextListener";
                }
                case 45: {
                    return "setUdfpsHbmListener";
                }
                case 46: {
                    return "onDisplayReady";
                }
                case 47: {
                    return "onRecentsAnimationStateChanged";
                }
                case 48: {
                    return "onSystemBarAttributesChanged";
                }
                case 49: {
                    return "showTransient";
                }
                case 50: {
                    return "abortTransient";
                }
                case 51: {
                    return "showInattentiveSleepWarning";
                }
                case 52: {
                    return "dismissInattentiveSleepWarning";
                }
                case 53: {
                    return "showToast";
                }
                case 54: {
                    return "hideToast";
                }
                case 55: {
                    return "startTracing";
                }
                case 56: {
                    return "stopTracing";
                }
                case 57: {
                    return "handleWindowManagerLoggingCommand";
                }
                case 58: {
                    return "suppressAmbientDisplay";
                }
                case 59: {
                    return "requestWindowMagnificationConnection";
                }
                case 60: {
                    return "passThroughShellCommand";
                }
                case 61: {
                    return "setNavigationBarLumaSamplingEnabled";
                }
                case 62: {
                    return "runGcForTest";
                }
                case 63: {
                    return "requestTileServiceListeningState";
                }
                case 64: {
                    return "requestAddTile";
                }
                case 65: {
                    return "cancelRequestAddTile";
                }
                case 66: {
                    return "updateMediaTapToTransferSenderDisplay";
                }
                case 67: {
                    return "updateMediaTapToTransferReceiverDisplay";
                }
                case 68: {
                    return "registerNearbyMediaDevicesProvider";
                }
                case 69: {
                    return "unregisterNearbyMediaDevicesProvider";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    StatusBarIcon _arg1 = data.readTypedObject(StatusBarIcon.CREATOR);
                    data.enforceNoDataAvail();
                    this.setIcon(_arg0, _arg1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeIcon(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disable(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    this.animateExpandNotificationsPanel();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.animateExpandSettingsPanel(_arg0);
                    break;
                }
                case 6: {
                    this.animateCollapsePanels();
                    break;
                }
                case 7: {
                    this.togglePanel();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showWirelessChargingAnimation(_arg0);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    boolean _arg4 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setImeWindowStatus(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setWindowState(_arg0, _arg1, _arg2);
                    break;
                }
                case 11: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.showRecentApps(_arg0);
                    break;
                }
                case 12: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.hideRecentApps(_arg0, _arg1);
                    break;
                }
                case 13: {
                    this.toggleRecentApps();
                    break;
                }
                case 14: {
                    this.toggleSplitScreen();
                    break;
                }
                case 15: {
                    this.preloadRecentApps();
                    break;
                }
                case 16: {
                    this.cancelPreloadRecentApps();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showScreenPinningRequest(_arg0);
                    break;
                }
                case 18: {
                    this.dismissKeyboardShortcutsMenu();
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.toggleKeyboardShortcutsMenu(_arg0);
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.appTransitionPending(_arg0);
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.appTransitionCancelled(_arg0);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.appTransitionStarting(_arg0, _arg1, _arg2);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.appTransitionFinished(_arg0);
                    break;
                }
                case 24: {
                    this.showAssistDisclosure();
                    break;
                }
                case 25: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.startAssist(_arg0);
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCameraLaunchGestureDetected(_arg0);
                    break;
                }
                case 27: {
                    this.onEmergencyActionLaunchGestureDetected();
                    break;
                }
                case 28: {
                    this.showPictureInPictureMenu();
                    break;
                }
                case 29: {
                    this.showGlobalActionsMenu();
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onProposedRotationChanged(_arg0, _arg1);
                    break;
                }
                case 31: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setTopAppHidesStatusBar(_arg0);
                    break;
                }
                case 32: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.addQsTile(_arg0);
                    break;
                }
                case 33: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.remQsTile(_arg0);
                    break;
                }
                case 34: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.clickQsTile(_arg0);
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.handleSystemKey(_arg0);
                    break;
                }
                case 36: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.showPinningEnterExitToast(_arg0);
                    break;
                }
                case 37: {
                    this.showPinningEscapeToast();
                    break;
                }
                case 38: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.showShutdownUi(_arg0, _arg1);
                    break;
                }
                case 39: {
                    PromptInfo _arg0 = data.readTypedObject(PromptInfo.CREATOR);
                    IBiometricSysuiReceiver _arg1 = IBiometricSysuiReceiver.Stub.asInterface(data.readStrongBinder());
                    int[] _arg2 = data.createIntArray();
                    boolean _arg3 = data.readBoolean();
                    boolean _arg4 = data.readBoolean();
                    int _arg5 = data.readInt();
                    long _arg6 = data.readLong();
                    String _arg7 = data.readString();
                    long _arg8 = data.readLong();
                    int _arg9 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showAuthenticationDialog(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    break;
                }
                case 40: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBiometricAuthenticated(_arg0);
                    break;
                }
                case 41: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onBiometricHelp(_arg0, _arg1);
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBiometricError(_arg0, _arg1, _arg2);
                    break;
                }
                case 43: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.hideAuthenticationDialog(_arg0);
                    break;
                }
                case 44: {
                    IBiometricContextListener _arg0 = IBiometricContextListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setBiometicContextListener(_arg0);
                    break;
                }
                case 45: {
                    IUdfpsHbmListener _arg0 = IUdfpsHbmListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setUdfpsHbmListener(_arg0);
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDisplayReady(_arg0);
                    break;
                }
                case 47: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onRecentsAnimationStateChanged(_arg0);
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    AppearanceRegion[] _arg2 = data.createTypedArray(AppearanceRegion.CREATOR);
                    boolean _arg3 = data.readBoolean();
                    int _arg4 = data.readInt();
                    InsetsVisibilities _arg5 = data.readTypedObject(InsetsVisibilities.CREATOR);
                    String _arg6 = data.readString();
                    data.enforceNoDataAvail();
                    this.onSystemBarAttributesChanged(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    break;
                }
                case 49: {
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.showTransient(_arg0, _arg1, _arg2);
                    break;
                }
                case 50: {
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.abortTransient(_arg0, _arg1);
                    break;
                }
                case 51: {
                    this.showInattentiveSleepWarning();
                    break;
                }
                case 52: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.dismissInattentiveSleepWarning(_arg0);
                    break;
                }
                case 53: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IBinder _arg2 = data.readStrongBinder();
                    CharSequence _arg3 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    IBinder _arg4 = data.readStrongBinder();
                    int _arg5 = data.readInt();
                    ITransientNotificationCallback _arg6 = ITransientNotificationCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showToast(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 54: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.hideToast(_arg0, _arg1);
                    break;
                }
                case 55: {
                    this.startTracing();
                    break;
                }
                case 56: {
                    this.stopTracing();
                    break;
                }
                case 57: {
                    String[] _arg0 = data.createStringArray();
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.handleWindowManagerLoggingCommand(_arg0, _arg1);
                    break;
                }
                case 58: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.suppressAmbientDisplay(_arg0);
                    break;
                }
                case 59: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.requestWindowMagnificationConnection(_arg0);
                    break;
                }
                case 60: {
                    String[] _arg0 = data.createStringArray();
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.passThroughShellCommand(_arg0, _arg1);
                    break;
                }
                case 61: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNavigationBarLumaSamplingEnabled(_arg0, _arg1);
                    break;
                }
                case 62: {
                    this.runGcForTest();
                    break;
                }
                case 63: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestTileServiceListeningState(_arg0);
                    break;
                }
                case 64: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    CharSequence _arg1 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    CharSequence _arg2 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    Icon _arg3 = data.readTypedObject(Icon.CREATOR);
                    IAddTileResultCallback _arg4 = IAddTileResultCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestAddTile(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 65: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.cancelRequestAddTile(_arg0);
                    break;
                }
                case 66: {
                    int _arg0 = data.readInt();
                    MediaRoute2Info _arg1 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    IUndoMediaTransferCallback _arg2 = IUndoMediaTransferCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.updateMediaTapToTransferSenderDisplay(_arg0, _arg1, _arg2);
                    break;
                }
                case 67: {
                    int _arg0 = data.readInt();
                    MediaRoute2Info _arg1 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    Icon _arg2 = data.readTypedObject(Icon.CREATOR);
                    CharSequence _arg3 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.updateMediaTapToTransferReceiverDisplay(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 68: {
                    INearbyMediaDevicesProvider _arg0 = INearbyMediaDevicesProvider.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerNearbyMediaDevicesProvider(_arg0);
                    break;
                }
                case 69: {
                    INearbyMediaDevicesProvider _arg0 = INearbyMediaDevicesProvider.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterNearbyMediaDevicesProvider(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 68;
        }

        private static class Proxy
        implements IStatusBar {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIcon(String slot, StatusBarIcon icon2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(slot);
                    _data.writeTypedObject(icon2, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeIcon(String slot) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(slot);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disable(int displayId, int state1, int state2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(state1);
                    _data.writeInt(state2);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void animateExpandNotificationsPanel() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateExpandSettingsPanel(String subPanel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(subPanel);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void animateCollapsePanels() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void togglePanel() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showWirelessChargingAnimation(int batteryLevel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(batteryLevel);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImeWindowStatus(int displayId, IBinder token, int vis, int backDisposition, boolean showImeSwitcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(token);
                    _data.writeInt(vis);
                    _data.writeInt(backDisposition);
                    _data.writeBoolean(showImeSwitcher);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWindowState(int display, int window, int state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(display);
                    _data.writeInt(window);
                    _data.writeInt(state);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showRecentApps(boolean triggeredFromAltTab) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(triggeredFromAltTab);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideRecentApps(boolean triggeredFromAltTab, boolean triggeredFromHomeKey) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(triggeredFromAltTab);
                    _data.writeBoolean(triggeredFromHomeKey);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void toggleRecentApps() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void toggleSplitScreen() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void preloadRecentApps() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelPreloadRecentApps() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showScreenPinningRequest(int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void dismissKeyboardShortcutsMenu() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toggleKeyboardShortcutsMenu(int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionPending(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionCancelled(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionStarting(int displayId, long statusBarAnimationsStartTime, long statusBarAnimationsDuration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeLong(statusBarAnimationsStartTime);
                    _data.writeLong(statusBarAnimationsDuration);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionFinished(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showAssistDisclosure() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startAssist(Bundle args) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(args, 0);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCameraLaunchGestureDetected(int source) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(source);
                    boolean bl = this.mRemote.transact(26, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onEmergencyActionLaunchGestureDetected() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showPictureInPictureMenu() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showGlobalActionsMenu() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(29, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProposedRotationChanged(int rotation, boolean isValid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rotation);
                    _data.writeBoolean(isValid);
                    boolean bl = this.mRemote.transact(30, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTopAppHidesStatusBar(boolean hidesStatusBar) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(hidesStatusBar);
                    boolean bl = this.mRemote.transact(31, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addQsTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tile, 0);
                    boolean bl = this.mRemote.transact(32, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remQsTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tile, 0);
                    boolean bl = this.mRemote.transact(33, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clickQsTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tile, 0);
                    boolean bl = this.mRemote.transact(34, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleSystemKey(int key) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(key);
                    boolean bl = this.mRemote.transact(35, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showPinningEnterExitToast(boolean entering) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(entering);
                    boolean bl = this.mRemote.transact(36, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showPinningEscapeToast() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(37, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showShutdownUi(boolean isReboot, String reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isReboot);
                    _data.writeString(reason);
                    boolean bl = this.mRemote.transact(38, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showAuthenticationDialog(PromptInfo promptInfo, IBiometricSysuiReceiver sysuiReceiver, int[] sensorIds, boolean credentialAllowed, boolean requireConfirmation, int userId, long operationId, String opPackageName, long requestId, int multiSensorConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(promptInfo, 0);
                    _data.writeStrongInterface(sysuiReceiver);
                    _data.writeIntArray(sensorIds);
                    _data.writeBoolean(credentialAllowed);
                    _data.writeBoolean(requireConfirmation);
                    _data.writeInt(userId);
                    _data.writeLong(operationId);
                    _data.writeString(opPackageName);
                    _data.writeLong(requestId);
                    _data.writeInt(multiSensorConfig);
                    boolean bl = this.mRemote.transact(39, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricAuthenticated(int modality) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(modality);
                    boolean bl = this.mRemote.transact(40, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricHelp(int modality, String message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(modality);
                    _data.writeString(message);
                    boolean bl = this.mRemote.transact(41, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricError(int modality, int error, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(modality);
                    _data.writeInt(error);
                    _data.writeInt(vendorCode);
                    boolean bl = this.mRemote.transact(42, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideAuthenticationDialog(long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(requestId);
                    boolean bl = this.mRemote.transact(43, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBiometicContextListener(IBiometricContextListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean bl = this.mRemote.transact(44, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUdfpsHbmListener(IUdfpsHbmListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean bl = this.mRemote.transact(45, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayReady(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(46, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRecentsAnimationStateChanged(boolean running) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(running);
                    boolean bl = this.mRemote.transact(47, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSystemBarAttributesChanged(int displayId, int appearance, AppearanceRegion[] appearanceRegions, boolean navbarColorManagedByIme, int behavior, InsetsVisibilities requestedVisibilities, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(appearance);
                    _data.writeTypedArray(appearanceRegions, 0);
                    _data.writeBoolean(navbarColorManagedByIme);
                    _data.writeInt(behavior);
                    _data.writeTypedObject(requestedVisibilities, 0);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(48, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showTransient(int displayId, int[] types, boolean isGestureOnSystemBar) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeIntArray(types);
                    _data.writeBoolean(isGestureOnSystemBar);
                    boolean bl = this.mRemote.transact(49, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortTransient(int displayId, int[] types) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeIntArray(types);
                    boolean bl = this.mRemote.transact(50, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showInattentiveSleepWarning() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(51, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismissInattentiveSleepWarning(boolean animated) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(animated);
                    boolean bl = this.mRemote.transact(52, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showToast(int uid, String packageName, IBinder token, CharSequence text, IBinder windowToken, int duration, ITransientNotificationCallback callback2, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeStrongBinder(token);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(duration);
                    _data.writeStrongInterface(callback2);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(53, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideToast(String packageName, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(54, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void startTracing() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(55, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void stopTracing() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(56, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleWindowManagerLoggingCommand(String[] args, ParcelFileDescriptor outFd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(args);
                    _data.writeTypedObject(outFd, 0);
                    boolean bl = this.mRemote.transact(57, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suppressAmbientDisplay(boolean suppress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(suppress);
                    boolean bl = this.mRemote.transact(58, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestWindowMagnificationConnection(boolean connect) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(connect);
                    boolean bl = this.mRemote.transact(59, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void passThroughShellCommand(String[] args, ParcelFileDescriptor pfd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(args);
                    _data.writeTypedObject(pfd, 0);
                    boolean bl = this.mRemote.transact(60, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNavigationBarLumaSamplingEnabled(int displayId, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(enable);
                    boolean bl = this.mRemote.transact(61, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void runGcForTest() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(62, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestTileServiceListeningState(ComponentName componentName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(componentName, 0);
                    boolean bl = this.mRemote.transact(63, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestAddTile(ComponentName componentName, CharSequence appName, CharSequence label, Icon icon2, IAddTileResultCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(componentName, 0);
                    if (appName != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(appName, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (label != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(label, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedObject(icon2, 0);
                    _data.writeStrongInterface(callback2);
                    boolean bl = this.mRemote.transact(64, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelRequestAddTile(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(65, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateMediaTapToTransferSenderDisplay(int displayState, MediaRoute2Info routeInfo, IUndoMediaTransferCallback undoCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayState);
                    _data.writeTypedObject(routeInfo, 0);
                    _data.writeStrongInterface(undoCallback);
                    boolean bl = this.mRemote.transact(66, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateMediaTapToTransferReceiverDisplay(int displayState, MediaRoute2Info routeInfo, Icon appIcon, CharSequence appName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayState);
                    _data.writeTypedObject(routeInfo, 0);
                    _data.writeTypedObject(appIcon, 0);
                    if (appName != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(appName, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean bl = this.mRemote.transact(67, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNearbyMediaDevicesProvider(INearbyMediaDevicesProvider provider2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(provider2);
                    boolean bl = this.mRemote.transact(68, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNearbyMediaDevicesProvider(INearbyMediaDevicesProvider provider2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(provider2);
                    boolean bl = this.mRemote.transact(69, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStatusBar {
        @Override
        public void setIcon(String slot, StatusBarIcon icon2) throws RemoteException {
        }

        @Override
        public void removeIcon(String slot) throws RemoteException {
        }

        @Override
        public void disable(int displayId, int state1, int state2) throws RemoteException {
        }

        @Override
        public void animateExpandNotificationsPanel() throws RemoteException {
        }

        @Override
        public void animateExpandSettingsPanel(String subPanel) throws RemoteException {
        }

        @Override
        public void animateCollapsePanels() throws RemoteException {
        }

        @Override
        public void togglePanel() throws RemoteException {
        }

        @Override
        public void showWirelessChargingAnimation(int batteryLevel) throws RemoteException {
        }

        @Override
        public void setImeWindowStatus(int displayId, IBinder token, int vis, int backDisposition, boolean showImeSwitcher) throws RemoteException {
        }

        @Override
        public void setWindowState(int display, int window, int state) throws RemoteException {
        }

        @Override
        public void showRecentApps(boolean triggeredFromAltTab) throws RemoteException {
        }

        @Override
        public void hideRecentApps(boolean triggeredFromAltTab, boolean triggeredFromHomeKey) throws RemoteException {
        }

        @Override
        public void toggleRecentApps() throws RemoteException {
        }

        @Override
        public void toggleSplitScreen() throws RemoteException {
        }

        @Override
        public void preloadRecentApps() throws RemoteException {
        }

        @Override
        public void cancelPreloadRecentApps() throws RemoteException {
        }

        @Override
        public void showScreenPinningRequest(int taskId) throws RemoteException {
        }

        @Override
        public void dismissKeyboardShortcutsMenu() throws RemoteException {
        }

        @Override
        public void toggleKeyboardShortcutsMenu(int deviceId) throws RemoteException {
        }

        @Override
        public void appTransitionPending(int displayId) throws RemoteException {
        }

        @Override
        public void appTransitionCancelled(int displayId) throws RemoteException {
        }

        @Override
        public void appTransitionStarting(int displayId, long statusBarAnimationsStartTime, long statusBarAnimationsDuration) throws RemoteException {
        }

        @Override
        public void appTransitionFinished(int displayId) throws RemoteException {
        }

        @Override
        public void showAssistDisclosure() throws RemoteException {
        }

        @Override
        public void startAssist(Bundle args) throws RemoteException {
        }

        @Override
        public void onCameraLaunchGestureDetected(int source) throws RemoteException {
        }

        @Override
        public void onEmergencyActionLaunchGestureDetected() throws RemoteException {
        }

        @Override
        public void showPictureInPictureMenu() throws RemoteException {
        }

        @Override
        public void showGlobalActionsMenu() throws RemoteException {
        }

        @Override
        public void onProposedRotationChanged(int rotation, boolean isValid) throws RemoteException {
        }

        @Override
        public void setTopAppHidesStatusBar(boolean hidesStatusBar) throws RemoteException {
        }

        @Override
        public void addQsTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void remQsTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void clickQsTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void handleSystemKey(int key) throws RemoteException {
        }

        @Override
        public void showPinningEnterExitToast(boolean entering) throws RemoteException {
        }

        @Override
        public void showPinningEscapeToast() throws RemoteException {
        }

        @Override
        public void showShutdownUi(boolean isReboot, String reason) throws RemoteException {
        }

        @Override
        public void showAuthenticationDialog(PromptInfo promptInfo, IBiometricSysuiReceiver sysuiReceiver, int[] sensorIds, boolean credentialAllowed, boolean requireConfirmation, int userId, long operationId, String opPackageName, long requestId, int multiSensorConfig) throws RemoteException {
        }

        @Override
        public void onBiometricAuthenticated(int modality) throws RemoteException {
        }

        @Override
        public void onBiometricHelp(int modality, String message) throws RemoteException {
        }

        @Override
        public void onBiometricError(int modality, int error, int vendorCode) throws RemoteException {
        }

        @Override
        public void hideAuthenticationDialog(long requestId) throws RemoteException {
        }

        @Override
        public void setBiometicContextListener(IBiometricContextListener listener2) throws RemoteException {
        }

        @Override
        public void setUdfpsHbmListener(IUdfpsHbmListener listener2) throws RemoteException {
        }

        @Override
        public void onDisplayReady(int displayId) throws RemoteException {
        }

        @Override
        public void onRecentsAnimationStateChanged(boolean running) throws RemoteException {
        }

        @Override
        public void onSystemBarAttributesChanged(int displayId, int appearance, AppearanceRegion[] appearanceRegions, boolean navbarColorManagedByIme, int behavior, InsetsVisibilities requestedVisibilities, String packageName) throws RemoteException {
        }

        @Override
        public void showTransient(int displayId, int[] types, boolean isGestureOnSystemBar) throws RemoteException {
        }

        @Override
        public void abortTransient(int displayId, int[] types) throws RemoteException {
        }

        @Override
        public void showInattentiveSleepWarning() throws RemoteException {
        }

        @Override
        public void dismissInattentiveSleepWarning(boolean animated) throws RemoteException {
        }

        @Override
        public void showToast(int uid, String packageName, IBinder token, CharSequence text, IBinder windowToken, int duration, ITransientNotificationCallback callback2, int displayId) throws RemoteException {
        }

        @Override
        public void hideToast(String packageName, IBinder token) throws RemoteException {
        }

        @Override
        public void startTracing() throws RemoteException {
        }

        @Override
        public void stopTracing() throws RemoteException {
        }

        @Override
        public void handleWindowManagerLoggingCommand(String[] args, ParcelFileDescriptor outFd) throws RemoteException {
        }

        @Override
        public void suppressAmbientDisplay(boolean suppress) throws RemoteException {
        }

        @Override
        public void requestWindowMagnificationConnection(boolean connect) throws RemoteException {
        }

        @Override
        public void passThroughShellCommand(String[] args, ParcelFileDescriptor pfd) throws RemoteException {
        }

        @Override
        public void setNavigationBarLumaSamplingEnabled(int displayId, boolean enable) throws RemoteException {
        }

        @Override
        public void runGcForTest() throws RemoteException {
        }

        @Override
        public void requestTileServiceListeningState(ComponentName componentName) throws RemoteException {
        }

        @Override
        public void requestAddTile(ComponentName componentName, CharSequence appName, CharSequence label, Icon icon2, IAddTileResultCallback callback2) throws RemoteException {
        }

        @Override
        public void cancelRequestAddTile(String packageName) throws RemoteException {
        }

        @Override
        public void updateMediaTapToTransferSenderDisplay(int displayState, MediaRoute2Info routeInfo, IUndoMediaTransferCallback undoCallback) throws RemoteException {
        }

        @Override
        public void updateMediaTapToTransferReceiverDisplay(int displayState, MediaRoute2Info routeInfo, Icon appIcon, CharSequence appName) throws RemoteException {
        }

        @Override
        public void registerNearbyMediaDevicesProvider(INearbyMediaDevicesProvider provider2) throws RemoteException {
        }

        @Override
        public void unregisterNearbyMediaDevicesProvider(INearbyMediaDevicesProvider provider2) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

