/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.text.TextUtils;
import android.util.Log;

public class CellBroadcastUtils {
    private static final String TAG = "CellBroadcastUtils";
    private static final boolean VDBG = false;

    public static String getDefaultCellBroadcastReceiverPackageName(Context context) {
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(new Intent("android.provider.Telephony.SMS_CB_RECEIVED"), 0x100000);
        if (resolveInfo == null) {
            Log.e(TAG, "getDefaultCellBroadcastReceiverPackageName: no package found");
            return null;
        }
        String packageName = resolveInfo.activityInfo.applicationInfo.packageName;
        if (TextUtils.isEmpty(packageName) || packageManager.checkPermission("android.permission.READ_CELL_BROADCASTS", packageName) == -1) {
            Log.e(TAG, "getDefaultCellBroadcastReceiverPackageName: returning null; permission check failed for : " + packageName);
            return null;
        }
        return packageName;
    }

    public static ComponentName getDefaultCellBroadcastAlertDialogComponent(Context context) {
        String cellBroadcastReceiverPackageName = CellBroadcastUtils.getDefaultCellBroadcastReceiverPackageName(context);
        if (TextUtils.isEmpty(cellBroadcastReceiverPackageName)) {
            return null;
        }
        return ComponentName.createRelative(cellBroadcastReceiverPackageName, "com.android.cellbroadcastreceiver.CellBroadcastAlertDialog");
    }
}

