/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;

public class OperatorInfo
implements Parcelable {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private String mOperatorAlphaLong;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private String mOperatorAlphaShort;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private String mOperatorNumeric;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private State mState = State.UNKNOWN;
    private int mRan = 0;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final Parcelable.Creator<OperatorInfo> CREATOR = new Parcelable.Creator<OperatorInfo>(){

        @Override
        public OperatorInfo createFromParcel(Parcel in) {
            OperatorInfo opInfo = new OperatorInfo(in.readString(), in.readString(), in.readString(), in.readSerializable(State.class.getClassLoader(), State.class), in.readInt());
            return opInfo;
        }

        public OperatorInfo[] newArray(int size) {
            return new OperatorInfo[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public String getOperatorAlphaLong() {
        return this.mOperatorAlphaLong;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public String getOperatorAlphaShort() {
        return this.mOperatorAlphaShort;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public String getOperatorNumeric() {
        return this.mOperatorNumeric;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public State getState() {
        return this.mState;
    }

    public int getRan() {
        return this.mRan;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    OperatorInfo(String operatorAlphaLong, String operatorAlphaShort, String operatorNumeric, State state) {
        this.mOperatorAlphaLong = operatorAlphaLong;
        this.mOperatorAlphaShort = operatorAlphaShort;
        this.mOperatorNumeric = operatorNumeric;
        this.mState = state;
    }

    OperatorInfo(String operatorAlphaLong, String operatorAlphaShort, String operatorNumeric, State state, int ran) {
        this(operatorAlphaLong, operatorAlphaShort, operatorNumeric, state);
        this.mRan = ran;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public OperatorInfo(String operatorAlphaLong, String operatorAlphaShort, String operatorNumeric, String stateString) {
        this(operatorAlphaLong, operatorAlphaShort, operatorNumeric, OperatorInfo.rilStateToState(stateString));
    }

    public OperatorInfo(String operatorAlphaLong, String operatorAlphaShort, String operatorNumeric, int ran) {
        this(operatorAlphaLong, operatorAlphaShort, operatorNumeric);
        this.mRan = ran;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public OperatorInfo(String operatorAlphaLong, String operatorAlphaShort, String operatorNumeric) {
        this(operatorAlphaLong, operatorAlphaShort, operatorNumeric, State.UNKNOWN);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static State rilStateToState(String s) {
        if (s.equals("unknown")) {
            return State.UNKNOWN;
        }
        if (s.equals("available")) {
            return State.AVAILABLE;
        }
        if (s.equals("current")) {
            return State.CURRENT;
        }
        if (s.equals("forbidden")) {
            return State.FORBIDDEN;
        }
        throw new RuntimeException("RIL impl error: Invalid network state '" + s + "'");
    }

    public String toString() {
        return "OperatorInfo " + this.mOperatorAlphaLong + "/" + this.mOperatorAlphaShort + "/" + this.mOperatorNumeric + "/" + (Object)((Object)this.mState) + "/" + this.mRan;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mOperatorAlphaLong);
        dest.writeString(this.mOperatorAlphaShort);
        dest.writeString(this.mOperatorNumeric);
        dest.writeSerializable((Serializable)((Object)this.mState));
        dest.writeInt(this.mRan);
    }

    public static enum State {
        UNKNOWN,
        AVAILABLE,
        CURRENT,
        FORBIDDEN;

    }
}

