/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> T[] appendElement(Class<T> kind, T[] array2, T element) {
        return ArrayUtils.appendElement(kind, array2, element, false);
    }

    public static <T> T[] appendElement(Class<T> kind, T[] array2, T element, boolean allowDuplicates) {
        Object[] result;
        int end;
        if (array2 != null) {
            if (!allowDuplicates && ArrayUtils.contains(array2, element)) {
                return array2;
            }
            end = array2.length;
            result = (Object[])Array.newInstance(kind, end + 1);
            System.arraycopy(array2, 0, result, 0, end);
        } else {
            end = 0;
            result = (Object[])Array.newInstance(kind, 1);
        }
        result[end] = element;
        return result;
    }

    public static <T> T[] concatElements(Class<T> kind, T[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            return ArrayUtils.createEmptyArray(kind);
        }
        int totalLength = 0;
        for (T[] item : arrays) {
            if (item == null) continue;
            totalLength += item.length;
        }
        if (totalLength == 0) {
            return ArrayUtils.createEmptyArray(kind);
        }
        Object[] all = (Object[])Array.newInstance(kind, totalLength);
        int pos = 0;
        for (T[] item : arrays) {
            if (item == null || item.length == 0) continue;
            System.arraycopy(item, 0, all, pos, item.length);
            pos += item.length;
        }
        return all;
    }

    private static <T> T[] createEmptyArray(Class<T> kind) {
        if (kind == String.class) {
            return EmptyArray.STRING;
        }
        if (kind == Object.class) {
            return EmptyArray.OBJECT;
        }
        return (Object[])Array.newInstance(kind, 0);
    }

    public static boolean contains(char[] array2, char value2) {
        if (array2 == null) {
            return false;
        }
        for (char element : array2) {
            if (element != value2) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(Collection<T> cur, T val) {
        return cur != null ? cur.contains(val) : false;
    }

    public static boolean contains(int[] array2, int value2) {
        if (array2 == null) {
            return false;
        }
        for (int element : array2) {
            if (element != value2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] array2, long value2) {
        if (array2 == null) {
            return false;
        }
        for (long element : array2) {
            if (element != value2) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T[] array2, T value2) {
        return ArrayUtils.indexOf(array2, value2) != -1;
    }

    public static <T> int indexOf(T[] array2, T value2) {
        if (array2 == null) {
            return -1;
        }
        for (int i = 0; i < array2.length; ++i) {
            if (!Objects.equals(array2[i], value2)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isEmpty(Collection<?> array2) {
        return array2 == null || array2.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map2) {
        return map2 == null || map2.isEmpty();
    }

    public static <T> boolean isEmpty(T[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(int[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(long[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(byte[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(boolean[] array2) {
        return array2 == null || array2.length == 0;
    }

    private static class EmptyArray {
        public static final Object[] OBJECT = new Object[0];
        public static final String[] STRING = new String[0];

        private EmptyArray() {
        }
    }
}

