/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.util;

import android.content.Context;
import android.content.pm.ComponentInfo;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.os.SystemProperties;
import android.os._Original_Build;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class TelephonyUtils {
    public static boolean IS_USER = "user".equals(_Original_Build.TYPE);
    public static boolean IS_DEBUGGABLE = SystemProperties.getInt("ro.debuggable", 0) == 1;
    public static final Executor DIRECT_EXECUTOR = Runnable::run;

    public static boolean checkDumpPermission(Context context, String tag2, PrintWriter pw) {
        if (context.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump " + tag2 + " from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " due to missing android.permission.DUMP permission");
            return false;
        }
        return true;
    }

    public static String emptyIfNull(String str) {
        return str == null ? "" : str;
    }

    public static <T> List<T> emptyIfNull(List<T> cur) {
        return cur == null ? Collections.emptyList() : cur;
    }

    public static ComponentInfo getComponentInfo(ResolveInfo resolveInfo) {
        if (resolveInfo.activityInfo != null) {
            return resolveInfo.activityInfo;
        }
        if (resolveInfo.serviceInfo != null) {
            return resolveInfo.serviceInfo;
        }
        if (resolveInfo.providerInfo != null) {
            return resolveInfo.providerInfo;
        }
        throw new IllegalStateException("Missing ComponentInfo!");
    }

    public static void runWithCleanCallingIdentity(Runnable action2) {
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            action2.run();
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
    }

    public static void runWithCleanCallingIdentity(Runnable action2, Executor executor) {
        if (action2 != null) {
            if (executor != null) {
                executor.execute(() -> TelephonyUtils.runWithCleanCallingIdentity(action2));
            } else {
                TelephonyUtils.runWithCleanCallingIdentity(action2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithCleanCallingIdentity(Supplier<T> action2) {
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            T t = action2.get();
            return t;
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
    }

    public static Bundle filterValues(Bundle bundle) {
        Bundle ret = new Bundle(bundle);
        for (String key : bundle.keySet()) {
            Object value2 = bundle.get(key);
            if (value2 instanceof Integer || value2 instanceof Long || value2 instanceof Double || value2 instanceof String || value2 instanceof int[] || value2 instanceof long[] || value2 instanceof double[] || value2 instanceof String[] || value2 instanceof PersistableBundle || value2 == null || value2 instanceof Boolean || value2 instanceof boolean[]) continue;
            if (value2 instanceof Bundle) {
                ret.putBundle(key, TelephonyUtils.filterValues((Bundle)value2));
                continue;
            }
            if (value2.getClass().getName().startsWith("android.")) continue;
            ret.remove(key);
        }
        return ret;
    }

    public static void waitUntilReady(CountDownLatch latch, long timeoutMs) {
        try {
            latch.await(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String dataStateToString(int state) {
        switch (state) {
            case 0: {
                return "DISCONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 2: {
                return "CONNECTED";
            }
            case 3: {
                return "SUSPENDED";
            }
            case 4: {
                return "DISCONNECTING";
            }
            case -1: {
                return "UNKNOWN";
            }
        }
        return "UNKNOWN(" + state + ")";
    }
}

