/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.compat.annotation.UnsupportedAppUsage;

public class BitwiseInputStream {
    private byte[] mBuf;
    private int mPos;
    private int mEnd;

    @UnsupportedAppUsage
    public BitwiseInputStream(byte[] buf) {
        this.mBuf = buf;
        this.mEnd = buf.length << 3;
        this.mPos = 0;
    }

    @UnsupportedAppUsage
    public int available() {
        return this.mEnd - this.mPos;
    }

    @UnsupportedAppUsage
    public int read(int bits) throws AccessException {
        int index = this.mPos >>> 3;
        int offset2 = 16 - (this.mPos & 7) - bits;
        if (bits < 0 || bits > 8 || this.mPos + bits > this.mEnd) {
            throw new AccessException("illegal read (pos " + this.mPos + ", end " + this.mEnd + ", bits " + bits + ")");
        }
        int data = (this.mBuf[index] & 0xFF) << 8;
        if (offset2 < 8) {
            data |= this.mBuf[index + 1] & 0xFF;
        }
        data >>>= offset2;
        this.mPos += bits;
        return data &= -1 >>> 32 - bits;
    }

    @UnsupportedAppUsage
    public byte[] readByteArray(int bits) throws AccessException {
        int bytes = (bits >>> 3) + ((bits & 7) > 0 ? 1 : 0);
        byte[] arr = new byte[bytes];
        for (int i = 0; i < bytes; ++i) {
            int increment = Math.min(8, bits - (i << 3));
            arr[i] = (byte)(this.read(increment) << 8 - increment);
        }
        return arr;
    }

    @UnsupportedAppUsage
    public void skip(int bits) throws AccessException {
        if (this.mPos + bits > this.mEnd) {
            throw new AccessException("illegal skip (pos " + this.mPos + ", end " + this.mEnd + ", bits " + bits + ")");
        }
        this.mPos += bits;
    }

    public static class AccessException
    extends Exception {
        public AccessException(String s) {
            super("BitwiseInputStream access failed: " + s);
        }
    }
}

