/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.util.ArrayList;
import java.util.List;

public class CallbackRegistry<C, T, A>
implements Cloneable {
    private static final String TAG = "CallbackRegistry";
    private List<C> mCallbacks = new ArrayList<C>();
    private long mFirst64Removed = 0L;
    private long[] mRemainderRemoved;
    private int mNotificationLevel;
    private final NotifierCallback<C, T, A> mNotifier;

    public CallbackRegistry(NotifierCallback<C, T, A> notifier) {
        this.mNotifier = notifier;
    }

    public synchronized void notifyCallbacks(T sender, int arg, A arg2) {
        ++this.mNotificationLevel;
        this.notifyRecurseLocked(sender, arg, arg2);
        --this.mNotificationLevel;
        if (this.mNotificationLevel == 0) {
            if (this.mRemainderRemoved != null) {
                for (int i = this.mRemainderRemoved.length - 1; i >= 0; --i) {
                    long removedBits = this.mRemainderRemoved[i];
                    if (removedBits == 0L) continue;
                    this.removeRemovedCallbacks((i + 1) * 64, removedBits);
                    this.mRemainderRemoved[i] = 0L;
                }
            }
            if (this.mFirst64Removed != 0L) {
                this.removeRemovedCallbacks(0, this.mFirst64Removed);
                this.mFirst64Removed = 0L;
            }
        }
    }

    private void notifyFirst64Locked(T sender, int arg, A arg2) {
        int maxNotified = Math.min(64, this.mCallbacks.size());
        this.notifyCallbacksLocked(sender, arg, arg2, 0, maxNotified, this.mFirst64Removed);
    }

    private void notifyRecurseLocked(T sender, int arg, A arg2) {
        int callbackCount = this.mCallbacks.size();
        int remainderIndex = this.mRemainderRemoved == null ? -1 : this.mRemainderRemoved.length - 1;
        this.notifyRemainderLocked(sender, arg, arg2, remainderIndex);
        int startCallbackIndex = (remainderIndex + 2) * 64;
        this.notifyCallbacksLocked(sender, arg, arg2, startCallbackIndex, callbackCount, 0L);
    }

    private void notifyRemainderLocked(T sender, int arg, A arg2, int remainderIndex) {
        if (remainderIndex < 0) {
            this.notifyFirst64Locked(sender, arg, arg2);
        } else {
            long bits = this.mRemainderRemoved[remainderIndex];
            int startIndex = (remainderIndex + 1) * 64;
            int endIndex = Math.min(this.mCallbacks.size(), startIndex + 64);
            this.notifyRemainderLocked(sender, arg, arg2, remainderIndex - 1);
            this.notifyCallbacksLocked(sender, arg, arg2, startIndex, endIndex, bits);
        }
    }

    private void notifyCallbacksLocked(T sender, int arg, A arg2, int startIndex, int endIndex, long bits) {
        long bitMask = 1L;
        for (int i = startIndex; i < endIndex; ++i) {
            if ((bits & bitMask) == 0L) {
                this.mNotifier.onNotifyCallback(this.mCallbacks.get(i), sender, arg, arg2);
            }
            bitMask <<= 1;
        }
    }

    public synchronized void add(C callback2) {
        int index = this.mCallbacks.lastIndexOf(callback2);
        if (index < 0 || this.isRemovedLocked(index)) {
            this.mCallbacks.add(callback2);
        }
    }

    private boolean isRemovedLocked(int index) {
        if (index < 64) {
            long bitMask = 1L << index;
            return (this.mFirst64Removed & bitMask) != 0L;
        }
        if (this.mRemainderRemoved == null) {
            return false;
        }
        int maskIndex = index / 64 - 1;
        if (maskIndex >= this.mRemainderRemoved.length) {
            return false;
        }
        long bits = this.mRemainderRemoved[maskIndex];
        long bitMask = 1L << index % 64;
        return (bits & bitMask) != 0L;
    }

    private void removeRemovedCallbacks(int startIndex, long removed) {
        int endIndex = startIndex + 64;
        long bitMask = Long.MIN_VALUE;
        for (int i = endIndex - 1; i >= startIndex; --i) {
            if ((removed & bitMask) != 0L) {
                this.mCallbacks.remove(i);
            }
            bitMask >>>= 1;
        }
    }

    public synchronized void remove(C callback2) {
        if (this.mNotificationLevel == 0) {
            this.mCallbacks.remove(callback2);
        } else {
            int index = this.mCallbacks.lastIndexOf(callback2);
            if (index >= 0) {
                this.setRemovalBitLocked(index);
            }
        }
    }

    private void setRemovalBitLocked(int index) {
        if (index < 64) {
            long bitMask = 1L << index;
            this.mFirst64Removed |= bitMask;
        } else {
            int remainderIndex = index / 64 - 1;
            if (this.mRemainderRemoved == null) {
                this.mRemainderRemoved = new long[this.mCallbacks.size() / 64];
            } else if (this.mRemainderRemoved.length < remainderIndex) {
                long[] newRemainders = new long[this.mCallbacks.size() / 64];
                System.arraycopy(this.mRemainderRemoved, 0, newRemainders, 0, this.mRemainderRemoved.length);
                this.mRemainderRemoved = newRemainders;
            }
            long bitMask = 1L << index % 64;
            int n = remainderIndex;
            this.mRemainderRemoved[n] = this.mRemainderRemoved[n] | bitMask;
        }
    }

    public synchronized ArrayList<C> copyListeners() {
        ArrayList<C> callbacks = new ArrayList<C>(this.mCallbacks.size());
        int numListeners = this.mCallbacks.size();
        for (int i = 0; i < numListeners; ++i) {
            if (this.isRemovedLocked(i)) continue;
            callbacks.add(this.mCallbacks.get(i));
        }
        return callbacks;
    }

    public synchronized boolean isEmpty() {
        if (this.mCallbacks.isEmpty()) {
            return true;
        }
        if (this.mNotificationLevel == 0) {
            return false;
        }
        int numListeners = this.mCallbacks.size();
        for (int i = 0; i < numListeners; ++i) {
            if (this.isRemovedLocked(i)) continue;
            return false;
        }
        return true;
    }

    public synchronized void clear() {
        if (this.mNotificationLevel == 0) {
            this.mCallbacks.clear();
        } else if (!this.mCallbacks.isEmpty()) {
            for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
                this.setRemovalBitLocked(i);
            }
        }
    }

    public synchronized CallbackRegistry<C, T, A> clone() {
        CallbackRegistry clone = null;
        try {
            clone = (CallbackRegistry)super.clone();
            clone.mFirst64Removed = 0L;
            clone.mRemainderRemoved = null;
            clone.mNotificationLevel = 0;
            clone.mCallbacks = new ArrayList<C>();
            int numListeners = this.mCallbacks.size();
            for (int i = 0; i < numListeners; ++i) {
                if (this.isRemovedLocked(i)) continue;
                clone.mCallbacks.add(this.mCallbacks.get(i));
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public static abstract class NotifierCallback<C, T, A> {
        public abstract void onNotifyCallback(C var1, T var2, int var3, A var4);
    }
}

