/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.app.AppOpsManager;
import android.content.ComponentName;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.text.TextUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.ParseUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.function.Predicate;

public class DumpUtils {
    public static final ComponentName[] CRITICAL_SECTION_COMPONENTS = new ComponentName[]{new ComponentName("com.android.systemui", "com.android.systemui.SystemUIService")};
    private static final String TAG = "DumpUtils";
    private static final boolean DEBUG = false;

    private DumpUtils() {
    }

    public static void dumpAsync(Handler handler, final Dump dump, PrintWriter pw, final String prefix, long timeout) {
        final StringWriter sw = new StringWriter();
        if (handler.runWithScissors(new Runnable(){

            @Override
            public void run() {
                FastPrintWriter lpw = new FastPrintWriter(sw);
                dump.dump(lpw, prefix);
                ((PrintWriter)lpw).close();
            }
        }, timeout)) {
            pw.print(sw.toString());
        } else {
            pw.println("... timed out");
        }
    }

    private static void logMessage(PrintWriter pw, String msg) {
        pw.println(msg);
    }

    public static boolean checkDumpPermission(Context context, String tag2, PrintWriter pw) {
        if (context.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            DumpUtils.logMessage(pw, "Permission Denial: can't dump " + tag2 + " from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " due to missing android.permission.DUMP permission");
            return false;
        }
        return true;
    }

    public static boolean checkUsageStatsPermission(Context context, String tag2, PrintWriter pw) {
        int uid = Binder.getCallingUid();
        switch (uid) {
            case 0: 
            case 1000: 
            case 1067: 
            case 2000: {
                return true;
            }
        }
        if (context.checkCallingOrSelfPermission("android.permission.PACKAGE_USAGE_STATS") != 0) {
            DumpUtils.logMessage(pw, "Permission Denial: can't dump " + tag2 + " from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " due to missing android.permission.PACKAGE_USAGE_STATS permission");
            return false;
        }
        AppOpsManager appOps = context.getSystemService(AppOpsManager.class);
        String[] pkgs = context.getPackageManager().getPackagesForUid(uid);
        if (pkgs != null) {
            for (String pkg : pkgs) {
                switch (appOps.noteOpNoThrow(43, uid, pkg)) {
                    case 0: {
                        return true;
                    }
                    case 3: {
                        return true;
                    }
                }
            }
        }
        DumpUtils.logMessage(pw, "Permission Denial: can't dump " + tag2 + " from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " due to android:get_usage_stats app-op not allowed");
        return false;
    }

    public static boolean checkDumpAndUsageStatsPermission(Context context, String tag2, PrintWriter pw) {
        return DumpUtils.checkDumpPermission(context, tag2, pw) && DumpUtils.checkUsageStatsPermission(context, tag2, pw);
    }

    public static boolean isPlatformPackage(String packageName) {
        return packageName != null && (packageName.equals("android") || packageName.startsWith("android.") || packageName.startsWith("com.android."));
    }

    public static boolean isPlatformPackage(ComponentName cname) {
        return cname != null && DumpUtils.isPlatformPackage(cname.getPackageName());
    }

    public static boolean isPlatformPackage(ComponentName.WithComponentName wcn) {
        return wcn != null && DumpUtils.isPlatformPackage(wcn.getComponentName());
    }

    public static boolean isNonPlatformPackage(String packageName) {
        return packageName != null && !DumpUtils.isPlatformPackage(packageName);
    }

    public static boolean isNonPlatformPackage(ComponentName cname) {
        return cname != null && DumpUtils.isNonPlatformPackage(cname.getPackageName());
    }

    public static boolean isNonPlatformPackage(ComponentName.WithComponentName wcn) {
        return wcn != null && !DumpUtils.isPlatformPackage(wcn.getComponentName());
    }

    private static boolean isCriticalPackage(ComponentName cname) {
        if (cname == null) {
            return false;
        }
        for (int i = 0; i < CRITICAL_SECTION_COMPONENTS.length; ++i) {
            if (!cname.equals(CRITICAL_SECTION_COMPONENTS[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlatformCriticalPackage(ComponentName.WithComponentName wcn) {
        return wcn != null && DumpUtils.isPlatformPackage(wcn.getComponentName()) && DumpUtils.isCriticalPackage(wcn.getComponentName());
    }

    public static boolean isPlatformNonCriticalPackage(ComponentName.WithComponentName wcn) {
        return wcn != null && DumpUtils.isPlatformPackage(wcn.getComponentName()) && !DumpUtils.isCriticalPackage(wcn.getComponentName());
    }

    public static <TRec extends ComponentName.WithComponentName> Predicate<TRec> filterRecord(String filterString) {
        if (TextUtils.isEmpty(filterString)) {
            return rec -> false;
        }
        if ("all".equals(filterString)) {
            return Objects::nonNull;
        }
        if ("all-platform".equals(filterString)) {
            return DumpUtils::isPlatformPackage;
        }
        if ("all-non-platform".equals(filterString)) {
            return DumpUtils::isNonPlatformPackage;
        }
        if ("all-platform-critical".equals(filterString)) {
            return DumpUtils::isPlatformCriticalPackage;
        }
        if ("all-platform-non-critical".equals(filterString)) {
            return DumpUtils::isPlatformNonCriticalPackage;
        }
        ComponentName filterCname = ComponentName.unflattenFromString(filterString);
        if (filterCname != null) {
            return rec -> rec != null && filterCname.equals(rec.getComponentName());
        }
        int id2 = ParseUtils.parseIntWithBase(filterString, 16, -1);
        return rec -> {
            ComponentName cn = rec.getComponentName();
            return id2 != -1 && System.identityHashCode(rec) == id2 || cn.flattenToString().toLowerCase().contains(filterString.toLowerCase());
        };
    }

    public static interface Dump {
        public void dump(PrintWriter var1, String var2);
    }
}

