/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.Arrays;

public class ExponentiallyBucketedHistogram {
    private final int[] mData;

    public ExponentiallyBucketedHistogram(int numBuckets) {
        numBuckets = Preconditions.checkArgumentInRange(numBuckets, 1, 31, "numBuckets");
        this.mData = new int[numBuckets];
    }

    public void add(int value2) {
        if (value2 <= 0) {
            this.mData[0] = this.mData[0] + 1;
        } else {
            int n = Math.min(this.mData.length - 1, 32 - Integer.numberOfLeadingZeros(value2));
            this.mData[n] = this.mData[n] + 1;
        }
    }

    public void reset() {
        Arrays.fill(this.mData, 0);
    }

    public void log(String tag2, CharSequence prefix) {
        StringBuilder builder2 = new StringBuilder(prefix);
        builder2.append('[');
        for (int i = 0; i < this.mData.length; ++i) {
            if (i != 0) {
                builder2.append(", ");
            }
            if (i < this.mData.length - 1) {
                builder2.append("<");
                builder2.append(1 << i);
            } else {
                builder2.append(">=");
                builder2.append(1 << i - 1);
            }
            builder2.append(": ");
            builder2.append(this.mData[i]);
        }
        builder2.append("]");
        Log.d(tag2, builder2.toString());
    }
}

