/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import libcore.io.IoUtils;

public class FileRotator {
    private static final String TAG = "FileRotator";
    private static final boolean LOGD = false;
    private final File mBasePath;
    private final String mPrefix;
    private final long mRotateAgeMillis;
    private final long mDeleteAgeMillis;
    private static final String SUFFIX_BACKUP = ".backup";
    private static final String SUFFIX_NO_BACKUP = ".no_backup";

    public FileRotator(File basePath, String prefix, long rotateAgeMillis, long deleteAgeMillis) {
        this.mBasePath = Objects.requireNonNull(basePath);
        this.mPrefix = Objects.requireNonNull(prefix);
        this.mRotateAgeMillis = rotateAgeMillis;
        this.mDeleteAgeMillis = deleteAgeMillis;
        this.mBasePath.mkdirs();
        for (String name : this.mBasePath.list()) {
            File file2;
            if (!name.startsWith(this.mPrefix)) continue;
            if (name.endsWith(SUFFIX_BACKUP)) {
                File backupFile = new File(this.mBasePath, name);
                file2 = new File(this.mBasePath, name.substring(0, name.length() - SUFFIX_BACKUP.length()));
                backupFile.renameTo(file2);
                continue;
            }
            if (!name.endsWith(SUFFIX_NO_BACKUP)) continue;
            File noBackupFile = new File(this.mBasePath, name);
            file2 = new File(this.mBasePath, name.substring(0, name.length() - SUFFIX_NO_BACKUP.length()));
            noBackupFile.delete();
            file2.delete();
        }
    }

    public void deleteAll() {
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            if (!info.parse(name)) continue;
            new File(this.mBasePath, name).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpAll(OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        try {
            FileInfo info = new FileInfo(this.mPrefix);
            for (String name : this.mBasePath.list()) {
                if (!info.parse(name)) continue;
                ZipEntry entry = new ZipEntry(name);
                zos.putNextEntry(entry);
                File file2 = new File(this.mBasePath, name);
                FileInputStream is = new FileInputStream(file2);
                try {
                    FileUtils.copy(is, zos);
                }
                finally {
                    IoUtils.closeQuietly(is);
                }
                zos.closeEntry();
            }
        }
        finally {
            IoUtils.closeQuietly(zos);
        }
    }

    public void rewriteActive(Rewriter rewriter, long currentTimeMillis) throws IOException {
        String activeName = this.getActiveName(currentTimeMillis);
        this.rewriteSingle(rewriter, activeName);
    }

    @Deprecated
    public void combineActive(final Reader reader, final Writer writer, long currentTimeMillis) throws IOException {
        this.rewriteActive(new Rewriter(){

            @Override
            public void reset() {
            }

            @Override
            public void read(InputStream in) throws IOException {
                reader.read(in);
            }

            @Override
            public boolean shouldWrite() {
                return true;
            }

            @Override
            public void write(OutputStream out) throws IOException {
                writer.write(out);
            }
        }, currentTimeMillis);
    }

    public void rewriteAll(Rewriter rewriter) throws IOException {
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            if (!info.parse(name)) continue;
            this.rewriteSingle(rewriter, name);
        }
    }

    private void rewriteSingle(Rewriter rewriter, String name) throws IOException {
        File file2 = new File(this.mBasePath, name);
        rewriter.reset();
        if (file2.exists()) {
            FileRotator.readFile(file2, rewriter);
            if (!rewriter.shouldWrite()) {
                return;
            }
            File backupFile = new File(this.mBasePath, name + SUFFIX_BACKUP);
            file2.renameTo(backupFile);
            try {
                FileRotator.writeFile(file2, rewriter);
                backupFile.delete();
            }
            catch (Throwable t) {
                file2.delete();
                backupFile.renameTo(file2);
                throw FileRotator.rethrowAsIoException(t);
            }
        }
        File backupFile = new File(this.mBasePath, name + SUFFIX_NO_BACKUP);
        backupFile.createNewFile();
        try {
            FileRotator.writeFile(file2, rewriter);
            backupFile.delete();
        }
        catch (Throwable t) {
            file2.delete();
            backupFile.delete();
            throw FileRotator.rethrowAsIoException(t);
        }
    }

    public void rewriteSingle(Rewriter rewriter, long startTimeMillis, long endTimeMillis) throws IOException {
        FileInfo info = new FileInfo(this.mPrefix);
        info.startMillis = startTimeMillis;
        info.endMillis = endTimeMillis;
        this.rewriteSingle(rewriter, info.build());
    }

    public void readMatching(Reader reader, long matchStartMillis, long matchEndMillis) throws IOException {
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            if (!info.parse(name) || info.startMillis > matchEndMillis || matchStartMillis > info.endMillis) continue;
            File file2 = new File(this.mBasePath, name);
            FileRotator.readFile(file2, reader);
        }
    }

    private String getActiveName(long currentTimeMillis) {
        String oldestActiveName = null;
        long oldestActiveStart = Long.MAX_VALUE;
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            if (!info.parse(name) || !info.isActive() || info.startMillis >= currentTimeMillis || info.startMillis >= oldestActiveStart) continue;
            oldestActiveName = name;
            oldestActiveStart = info.startMillis;
        }
        if (oldestActiveName != null) {
            return oldestActiveName;
        }
        info.startMillis = currentTimeMillis;
        info.endMillis = Long.MAX_VALUE;
        return info.build();
    }

    public void maybeRotate(long currentTimeMillis) {
        long rotateBefore = currentTimeMillis - this.mRotateAgeMillis;
        long deleteBefore = currentTimeMillis - this.mDeleteAgeMillis;
        FileInfo info = new FileInfo(this.mPrefix);
        String[] baseFiles = this.mBasePath.list();
        if (baseFiles == null) {
            return;
        }
        for (String name : baseFiles) {
            File file2;
            if (!info.parse(name)) continue;
            if (info.isActive()) {
                if (info.startMillis > rotateBefore) continue;
                info.endMillis = currentTimeMillis;
                file2 = new File(this.mBasePath, name);
                File destFile = new File(this.mBasePath, info.build());
                file2.renameTo(destFile);
                continue;
            }
            if (info.endMillis > deleteBefore) continue;
            file2 = new File(this.mBasePath, name);
            file2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFile(File file2, Reader reader) throws IOException {
        FileInputStream fis = new FileInputStream(file2);
        BufferedInputStream bis = new BufferedInputStream(fis);
        try {
            reader.read(bis);
        }
        finally {
            IoUtils.closeQuietly(bis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File file2, Writer writer) throws IOException {
        FileOutputStream fos = new FileOutputStream(file2);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            writer.write(bos);
            bos.flush();
        }
        finally {
            try {
                fos.getFD().sync();
            }
            catch (IOException iOException) {}
            IoUtils.closeQuietly(bos);
        }
    }

    private static IOException rethrowAsIoException(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        throw new IOException(t.getMessage(), t);
    }

    private static class FileInfo {
        public final String prefix;
        public long startMillis;
        public long endMillis;

        public FileInfo(String prefix) {
            this.prefix = Objects.requireNonNull(prefix);
        }

        public boolean parse(String name) {
            this.endMillis = -1L;
            this.startMillis = -1L;
            int dotIndex = name.lastIndexOf(46);
            int dashIndex = name.lastIndexOf(45);
            if (dotIndex == -1 || dashIndex == -1) {
                return false;
            }
            if (!this.prefix.equals(name.substring(0, dotIndex))) {
                return false;
            }
            try {
                this.startMillis = Long.parseLong(name.substring(dotIndex + 1, dashIndex));
                this.endMillis = name.length() - dashIndex == 1 ? Long.MAX_VALUE : Long.parseLong(name.substring(dashIndex + 1));
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public String build() {
            StringBuilder name = new StringBuilder();
            name.append(this.prefix).append('.').append(this.startMillis).append('-');
            if (this.endMillis != Long.MAX_VALUE) {
                name.append(this.endMillis);
            }
            return name.toString();
        }

        public boolean isActive() {
            return this.endMillis == Long.MAX_VALUE;
        }
    }

    public static interface Rewriter
    extends Reader,
    Writer {
        public void reset();

        public boolean shouldWrite();
    }

    public static interface Writer {
        public void write(OutputStream var1) throws IOException;
    }

    public static interface Reader {
        public void read(InputStream var1) throws IOException;
    }
}

