/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ImageDecoder;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.Size;
import java.io.IOException;

public class ImageUtils {
    private static final int TOLERANCE = 20;
    private static final int ALPHA_TOLERANCE = 50;
    private static final int COMPACT_BITMAP_SIZE = 64;
    private int[] mTempBuffer;
    private Bitmap mTempCompactBitmap;
    private Canvas mTempCompactBitmapCanvas;
    private Paint mTempCompactBitmapPaint;
    private final Matrix mTempMatrix = new Matrix();

    public boolean isGrayscale(Bitmap bitmap) {
        int height2 = bitmap.getHeight();
        int width2 = bitmap.getWidth();
        if (height2 > 64 || width2 > 64) {
            if (this.mTempCompactBitmap == null) {
                this.mTempCompactBitmap = Bitmap.createBitmap(64, 64, Bitmap.Config.ARGB_8888);
                this.mTempCompactBitmapCanvas = new Canvas(this.mTempCompactBitmap);
                this.mTempCompactBitmapPaint = new Paint(1);
                this.mTempCompactBitmapPaint.setFilterBitmap(true);
            }
            this.mTempMatrix.reset();
            this.mTempMatrix.setScale(64.0f / (float)width2, 64.0f / (float)height2, 0.0f, 0.0f);
            this.mTempCompactBitmapCanvas.drawColor(0, PorterDuff.Mode.SRC);
            this.mTempCompactBitmapCanvas.drawBitmap(bitmap, this.mTempMatrix, this.mTempCompactBitmapPaint);
            bitmap = this.mTempCompactBitmap;
            height2 = 64;
            width2 = 64;
        }
        int size = height2 * width2;
        this.ensureBufferSize(size);
        bitmap.getPixels(this.mTempBuffer, 0, width2, 0, 0, width2, height2);
        for (int i = 0; i < size; ++i) {
            if (ImageUtils.isGrayscale(this.mTempBuffer[i])) continue;
            return false;
        }
        return true;
    }

    private void ensureBufferSize(int size) {
        if (this.mTempBuffer == null || this.mTempBuffer.length < size) {
            this.mTempBuffer = new int[size];
        }
    }

    public static boolean isGrayscale(int color2) {
        int alpha = 0xFF & color2 >> 24;
        if (alpha < 50) {
            return true;
        }
        int r = 0xFF & color2 >> 16;
        int g = 0xFF & color2 >> 8;
        int b = 0xFF & color2;
        return Math.abs(r - g) < 20 && Math.abs(r - b) < 20 && Math.abs(g - b) < 20;
    }

    public static Bitmap buildScaledBitmap(Drawable drawable2, int maxWidth, int maxHeight) {
        return ImageUtils.buildScaledBitmap(drawable2, maxWidth, maxHeight, false);
    }

    public static Bitmap buildScaledBitmap(Drawable drawable2, int maxWidth, int maxHeight, boolean allowUpscaling) {
        if (drawable2 == null) {
            return null;
        }
        int originalWidth = drawable2.getIntrinsicWidth();
        int originalHeight = drawable2.getIntrinsicHeight();
        if (originalWidth <= maxWidth && originalHeight <= maxHeight && drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        if (originalHeight <= 0 || originalWidth <= 0) {
            return null;
        }
        float ratio = Math.min((float)maxWidth / (float)originalWidth, (float)maxHeight / (float)originalHeight);
        if (!allowUpscaling) {
            ratio = Math.min(1.0f, ratio);
        }
        int scaledWidth = (int)(ratio * (float)originalWidth);
        int scaledHeight = (int)(ratio * (float)originalHeight);
        Bitmap result = Bitmap.createBitmap(scaledWidth, scaledHeight, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        drawable2.setBounds(0, 0, scaledWidth, scaledHeight);
        drawable2.draw(canvas);
        return result;
    }

    public static int calculateSampleSize(Size currentSize, Size requestedSize) {
        int inSampleSize = 1;
        if (currentSize.getHeight() > requestedSize.getHeight() || currentSize.getWidth() > requestedSize.getWidth()) {
            int halfHeight = currentSize.getHeight() / 2;
            int halfWidth = currentSize.getWidth() / 2;
            while (halfHeight / inSampleSize >= requestedSize.getHeight() && halfWidth / inSampleSize >= requestedSize.getWidth()) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static Bitmap loadThumbnail(ContentResolver resolver, Uri uri, Size size) throws IOException {
        try (ContentProviderClient client = resolver.acquireContentProviderClient(uri);){
            Bundle opts = new Bundle();
            opts.putParcelable("android.content.extra.SIZE", new Point(size.getWidth(), size.getHeight()));
            Bitmap bitmap = ImageDecoder.decodeBitmap(ImageDecoder.createSource(() -> client.openTypedAssetFile(uri, "image/*", opts, null)), (decoder, info, source) -> {
                decoder.setAllocator(1);
                int sample = ImageUtils.calculateSampleSize(info.getSize(), size);
                if (sample > 1) {
                    decoder.setTargetSampleSize(sample);
                }
            });
            return bitmap;
        }
    }
}

