/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.Context;
import android.os.SystemClock;
import android.os.Trace;
import android.os._Original_Build;
import android.provider.DeviceConfig;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.FrameworkStatsLog;
import com.android.internal.util.PerfettoTrigger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class LatencyTracker {
    private static final String TAG = "LatencyTracker";
    public static final String SETTINGS_ENABLED_KEY = "enabled";
    private static final String SETTINGS_SAMPLING_INTERVAL_KEY = "sampling_interval";
    private static final boolean DEBUG = false;
    private static final boolean DEFAULT_ENABLED = _Original_Build.IS_DEBUGGABLE;
    private static final int DEFAULT_SAMPLING_INTERVAL = 5;
    public static final int ACTION_EXPAND_PANEL = 0;
    public static final int ACTION_TOGGLE_RECENTS = 1;
    public static final int ACTION_FINGERPRINT_WAKE_AND_UNLOCK = 2;
    public static final int ACTION_CHECK_CREDENTIAL = 3;
    public static final int ACTION_CHECK_CREDENTIAL_UNLOCKED = 4;
    public static final int ACTION_TURN_ON_SCREEN = 5;
    public static final int ACTION_ROTATE_SCREEN = 6;
    public static final int ACTION_FACE_WAKE_AND_UNLOCK = 7;
    public static final int ACTION_START_RECENTS_ANIMATION = 8;
    public static final int ACTION_ROTATE_SCREEN_SENSOR = 9;
    public static final int ACTION_ROTATE_SCREEN_CAMERA_CHECK = 10;
    public static final int ACTION_LOCKSCREEN_UNLOCK = 11;
    public static final int ACTION_USER_SWITCH = 12;
    public static final int ACTION_SWITCH_DISPLAY_UNFOLD = 13;
    public static final int ACTION_UDFPS_ILLUMINATE = 14;
    public static final int ACTION_SHOW_BACK_ARROW = 15;
    public static final int ACTION_LOAD_SHARE_SHEET = 16;
    private static final int[] ACTIONS_ALL = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final int[] STATSD_ACTION = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 10, 12, 13, 14, 15, 16, 17};
    private static LatencyTracker sLatencyTracker;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final SparseArray<Session> mSessions = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final int[] mTraceThresholdPerAction = new int[ACTIONS_ALL.length];
    @GuardedBy(value={"mLock"})
    private int mSamplingInterval = 5;
    @GuardedBy(value={"mLock"})
    private boolean mEnabled = DEFAULT_ENABLED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LatencyTracker getInstance(Context context) {
        if (sLatencyTracker != null) return sLatencyTracker;
        Class<LatencyTracker> clazz = LatencyTracker.class;
        synchronized (LatencyTracker.class) {
            if (sLatencyTracker != null) return sLatencyTracker;
            sLatencyTracker = new LatencyTracker();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sLatencyTracker;
        }
    }

    private LatencyTracker() {
        BackgroundThread.getHandler().post(() -> this.updateProperties(DeviceConfig.getProperties("latency_tracker", new String[0])));
        DeviceConfig.addOnPropertiesChangedListener("latency_tracker", BackgroundThread.getExecutor(), this::updateProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProperties(DeviceConfig.Properties properties2) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSamplingInterval = properties2.getInt(SETTINGS_SAMPLING_INTERVAL_KEY, 5);
            this.mEnabled = properties2.getBoolean(SETTINGS_ENABLED_KEY, DEFAULT_ENABLED);
            for (int action2 : ACTIONS_ALL) {
                this.mTraceThresholdPerAction[action2] = properties2.getInt(LatencyTracker.getNameOfAction(STATSD_ACTION[action2]), -1);
            }
        }
    }

    public static String getNameOfAction(int atomsProtoAction) {
        switch (atomsProtoAction) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "ACTION_EXPAND_PANEL";
            }
            case 2: {
                return "ACTION_TOGGLE_RECENTS";
            }
            case 3: {
                return "ACTION_FINGERPRINT_WAKE_AND_UNLOCK";
            }
            case 4: {
                return "ACTION_CHECK_CREDENTIAL";
            }
            case 5: {
                return "ACTION_CHECK_CREDENTIAL_UNLOCKED";
            }
            case 6: {
                return "ACTION_TURN_ON_SCREEN";
            }
            case 7: {
                return "ACTION_ROTATE_SCREEN";
            }
            case 8: {
                return "ACTION_FACE_WAKE_AND_UNLOCK";
            }
            case 9: {
                return "ACTION_START_RECENTS_ANIMATION";
            }
            case 10: {
                return "ACTION_ROTATE_SCREEN_CAMERA_CHECK";
            }
            case 11: {
                return "ACTION_ROTATE_SCREEN_SENSOR";
            }
            case 12: {
                return "ACTION_LOCKSCREEN_UNLOCK";
            }
            case 13: {
                return "ACTION_USER_SWITCH";
            }
            case 14: {
                return "ACTION_SWITCH_DISPLAY_UNFOLD";
            }
            case 15: {
                return "ACTION_UDFPS_ILLUMINATE";
            }
            case 16: {
                return "ACTION_SHOW_BACK_ARROW";
            }
            case 17: {
                return "ACTION_LOAD_SHARE_SHEET";
            }
        }
        throw new IllegalArgumentException("Invalid action");
    }

    private static String getTraceNameOfAction(int action2, String tag2) {
        if (TextUtils.isEmpty(tag2)) {
            return "L<" + LatencyTracker.getNameOfAction(STATSD_ACTION[action2]) + ">";
        }
        return "L<" + LatencyTracker.getNameOfAction(STATSD_ACTION[action2]) + "::" + tag2 + ">";
    }

    private static String getTraceTriggerNameForAction(int action2) {
        return "com.android.telemetry.latency-tracker-" + LatencyTracker.getNameOfAction(STATSD_ACTION[action2]);
    }

    public static boolean isEnabled(Context ctx) {
        return LatencyTracker.getInstance(ctx).isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEnabled;
        }
    }

    public void onActionStart(int action2) {
        this.onActionStart(action2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActionStart(int action2, String tag2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.mSessions.get(action2) != null) {
                return;
            }
            Session session = new Session(action2, tag2);
            session.begin(() -> this.onActionCancel(action2));
            this.mSessions.put(action2, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActionEnd(int action2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isEnabled()) {
                return;
            }
            Session session = this.mSessions.get(action2);
            if (session == null) {
                return;
            }
            session.end();
            this.mSessions.delete(action2);
            this.logAction(action2, session.duration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActionCancel(int action2) {
        Object object = this.mLock;
        synchronized (object) {
            Session session = this.mSessions.get(action2);
            if (session == null) {
                return;
            }
            session.cancel();
            this.mSessions.delete(action2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAction(int action2, int duration) {
        int traceThreshold;
        boolean shouldSample;
        Object object = this.mLock;
        synchronized (object) {
            shouldSample = ThreadLocalRandom.current().nextInt() % this.mSamplingInterval == 0;
            traceThreshold = this.mTraceThresholdPerAction[action2];
        }
        if (traceThreshold > 0 && duration >= traceThreshold) {
            PerfettoTrigger.trigger(LatencyTracker.getTraceTriggerNameForAction(action2));
        }
        LatencyTracker.logActionDeprecated(action2, duration, shouldSample);
    }

    public static void logActionDeprecated(int action2, int duration, boolean writeToStatsLog) {
        Log.i(TAG, LatencyTracker.getNameOfAction(STATSD_ACTION[action2]) + " latency=" + duration);
        EventLog.writeEvent(36070, action2, duration);
        if (writeToStatsLog) {
            FrameworkStatsLog.write(306, STATSD_ACTION[action2], duration);
        }
    }

    static class Session {
        private final int mAction;
        private final String mTag;
        private final String mName;
        private Runnable mTimeoutRunnable;
        private long mStartRtc = -1L;
        private long mEndRtc = -1L;

        Session(int action2, String tag2) {
            this.mAction = action2;
            this.mTag = tag2;
            this.mName = TextUtils.isEmpty(this.mTag) ? LatencyTracker.getNameOfAction(STATSD_ACTION[this.mAction]) : LatencyTracker.getNameOfAction(STATSD_ACTION[this.mAction]) + "::" + this.mTag;
        }

        String name() {
            return this.mName;
        }

        String traceName() {
            return LatencyTracker.getTraceNameOfAction(this.mAction, this.mTag);
        }

        void begin(Runnable timeoutAction) {
            this.mStartRtc = SystemClock.elapsedRealtime();
            Trace.asyncTraceBegin(4096L, this.traceName(), 0);
            this.mTimeoutRunnable = timeoutAction;
            BackgroundThread.getHandler().postDelayed(this.mTimeoutRunnable, TimeUnit.SECONDS.toMillis(15L));
        }

        void end() {
            this.mEndRtc = SystemClock.elapsedRealtime();
            Trace.asyncTraceEnd(4096L, this.traceName(), 0);
            BackgroundThread.getHandler().removeCallbacks(this.mTimeoutRunnable);
            this.mTimeoutRunnable = null;
        }

        void cancel() {
            Trace.asyncTraceEnd(4096L, this.traceName(), 0);
            BackgroundThread.getHandler().removeCallbacks(this.mTimeoutRunnable);
            this.mTimeoutRunnable = null;
        }

        int duration() {
            return (int)(this.mEndRtc - this.mStartRtc);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Action {
    }
}

