/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

public class ParseUtils {
    private ParseUtils() {
    }

    public static int parseInt(String value2, int defValue) {
        return ParseUtils.parseIntWithBase(value2, 10, defValue);
    }

    public static int parseIntWithBase(String value2, int base, int defValue) {
        if (value2 == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(value2, base);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public static long parseLong(String value2, long defValue) {
        return ParseUtils.parseLongWithBase(value2, 10, defValue);
    }

    public static long parseLongWithBase(String value2, int base, long defValue) {
        if (value2 == null) {
            return defValue;
        }
        try {
            return Long.parseLong(value2, base);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public static float parseFloat(String value2, float defValue) {
        if (value2 == null) {
            return defValue;
        }
        try {
            return Float.parseFloat(value2);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public static double parseDouble(String value2, double defValue) {
        if (value2 == null) {
            return defValue;
        }
        try {
            return Double.parseDouble(value2);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public static boolean parseBoolean(String value2, boolean defValue) {
        if ("true".equals(value2)) {
            return true;
        }
        if ("false".equals(value2)) {
            return false;
        }
        return ParseUtils.parseInt(value2, defValue ? 1 : 0) != 0;
    }
}

