/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;

public class UserIcons {
    private static final int[] USER_ICON_COLORS = new int[]{17171120, 17171121, 17171122, 17171123, 17171124, 17171125, 17171126, 17171127};

    public static Bitmap convertToBitmap(Drawable icon2) {
        return UserIcons.convertToBitmapAtSize(icon2, icon2.getIntrinsicWidth(), icon2.getIntrinsicHeight());
    }

    public static Bitmap convertToBitmapAtUserIconSize(Resources res, Drawable icon2) {
        int size = res.getDimensionPixelSize(17105619);
        return UserIcons.convertToBitmapAtSize(icon2, size, size);
    }

    private static Bitmap convertToBitmapAtSize(Drawable icon2, int width2, int height2) {
        if (icon2 == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap(width2, height2, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        icon2.setBounds(0, 0, width2, height2);
        icon2.draw(canvas);
        return bitmap;
    }

    public static Drawable getDefaultUserIcon(Resources resources, int userId, boolean light) {
        int colorResId;
        int n = colorResId = light ? 17171129 : 17171128;
        if (userId != -10000) {
            colorResId = USER_ICON_COLORS[userId % USER_ICON_COLORS.length];
        }
        return UserIcons.getDefaultUserIconInColor(resources, resources.getColor(colorResId, null));
    }

    public static Drawable getDefaultUserIconInColor(Resources resources, int color2) {
        Drawable icon2 = resources.getDrawable(17302309, null).mutate();
        icon2.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        icon2.setBounds(0, 0, icon2.getIntrinsicWidth(), icon2.getIntrinsicHeight());
        return icon2;
    }

    public static int[] getUserIconColors(Resources resources) {
        int[] result = new int[USER_ICON_COLORS.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = resources.getColor(USER_ICON_COLORS[i], null);
        }
        return result;
    }
}

