/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import com.android.internal.R;

public class ActionBarPolicy {
    @UnsupportedAppUsage
    private Context mContext;

    @UnsupportedAppUsage
    public static ActionBarPolicy get(Context context) {
        return new ActionBarPolicy(context);
    }

    @UnsupportedAppUsage
    private ActionBarPolicy(Context context) {
        this.mContext = context;
    }

    @UnsupportedAppUsage
    public int getMaxActionButtons() {
        Configuration config = this.mContext.getResources().getConfiguration();
        int width2 = config.screenWidthDp;
        int height2 = config.screenHeightDp;
        int smallest = config.smallestScreenWidthDp;
        if (smallest > 600 || width2 > 960 && height2 > 720 || width2 > 720 && height2 > 960) {
            return 5;
        }
        if (width2 >= 500 || width2 > 640 && height2 > 480 || width2 > 480 && height2 > 640) {
            return 4;
        }
        if (width2 >= 360) {
            return 3;
        }
        return 2;
    }

    @UnsupportedAppUsage
    public boolean showsOverflowMenuButton() {
        return true;
    }

    @UnsupportedAppUsage
    public int getEmbeddedMenuWidthLimit() {
        return this.mContext.getResources().getDisplayMetrics().widthPixels / 2;
    }

    @UnsupportedAppUsage
    public boolean hasEmbeddedTabs() {
        int targetSdk = this.mContext.getApplicationInfo().targetSdkVersion;
        if (targetSdk >= 16) {
            return this.mContext.getResources().getBoolean(0x111000A);
        }
        Configuration configuration = this.mContext.getResources().getConfiguration();
        int width2 = configuration.screenWidthDp;
        int height2 = configuration.screenHeightDp;
        return configuration.orientation == 2 || width2 >= 480 || width2 >= 640 && height2 >= 480;
    }

    @UnsupportedAppUsage
    public int getTabContainerHeight() {
        TypedArray a = this.mContext.obtainStyledAttributes(null, R.styleable.ActionBar, 16843470, 0);
        int height2 = a.getLayoutDimension(4, 0);
        Resources r = this.mContext.getResources();
        if (!this.hasEmbeddedTabs()) {
            height2 = Math.min(height2, r.getDimensionPixelSize(17104928));
        }
        a.recycle();
        return height2;
    }

    public boolean enableHomeButtonByDefault() {
        return this.mContext.getApplicationInfo().targetSdkVersion < 14;
    }

    @UnsupportedAppUsage
    public int getStackedTabMaxWidth() {
        return this.mContext.getResources().getDimensionPixelSize(17104929);
    }
}

