/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.annotation.NonNull;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.InsetsFlags;
import android.view.ViewDebug;
import com.android.internal.util.AnnotationValidations;

public class AppearanceRegion
implements Parcelable {
    private int mAppearance;
    private Rect mBounds;
    public static final Parcelable.Creator<AppearanceRegion> CREATOR = new Parcelable.Creator<AppearanceRegion>(){

        public AppearanceRegion[] newArray(int size) {
            return new AppearanceRegion[size];
        }

        @Override
        public AppearanceRegion createFromParcel(Parcel in) {
            return new AppearanceRegion(in);
        }
    };

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppearanceRegion sa = (AppearanceRegion)o;
        return this.mAppearance == sa.mAppearance && this.mBounds.equals(sa.mBounds);
    }

    public String toString() {
        String appearanceString = ViewDebug.flagsToString(InsetsFlags.class, "appearance", this.mAppearance);
        return "AppearanceRegion{" + appearanceString + " bounds=" + this.mBounds.toShortString() + "}";
    }

    public AppearanceRegion(int appearance, Rect bounds2) {
        this.mAppearance = appearance;
        this.mBounds = bounds2;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBounds);
    }

    public int getAppearance() {
        return this.mAppearance;
    }

    public Rect getBounds() {
        return this.mBounds;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mAppearance);
        dest.writeTypedObject(this.mBounds, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected AppearanceRegion(Parcel in) {
        int appearance = in.readInt();
        Rect bounds2 = in.readTypedObject(Rect.CREATOR);
        this.mAppearance = appearance;
        this.mBounds = bounds2;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBounds);
    }

    @Deprecated
    private void __metadata() {
    }
}

