/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.view.View;
import android.view.ViewTreeObserver;

public class OneShotPreDrawListener
implements ViewTreeObserver.OnPreDrawListener,
View.OnAttachStateChangeListener {
    private final View mView;
    private ViewTreeObserver mViewTreeObserver;
    private final Runnable mRunnable;
    private final boolean mReturnValue;

    private OneShotPreDrawListener(View view2, boolean returnValue, Runnable runnable) {
        this.mView = view2;
        this.mViewTreeObserver = view2.getViewTreeObserver();
        this.mRunnable = runnable;
        this.mReturnValue = returnValue;
    }

    public static OneShotPreDrawListener add(View view2, Runnable runnable) {
        return OneShotPreDrawListener.add(view2, true, runnable);
    }

    public static OneShotPreDrawListener add(View view2, boolean returnValue, Runnable runnable) {
        OneShotPreDrawListener listener2 = new OneShotPreDrawListener(view2, returnValue, runnable);
        view2.getViewTreeObserver().addOnPreDrawListener(listener2);
        view2.addOnAttachStateChangeListener(listener2);
        return listener2;
    }

    @Override
    public boolean onPreDraw() {
        this.removeListener();
        this.mRunnable.run();
        return this.mReturnValue;
    }

    public void removeListener() {
        if (this.mViewTreeObserver.isAlive()) {
            this.mViewTreeObserver.removeOnPreDrawListener(this);
        } else {
            this.mView.getViewTreeObserver().removeOnPreDrawListener(this);
        }
        this.mView.removeOnAttachStateChangeListener(this);
    }

    @Override
    public void onViewAttachedToWindow(View v) {
        this.mViewTreeObserver = v.getViewTreeObserver();
    }

    @Override
    public void onViewDetachedFromWindow(View v) {
        this.removeListener();
    }
}

