/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Rect;
import android.os.CancellationSignal;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.ScrollCaptureViewHelper;
import java.util.function.Consumer;

public class RecyclerViewCaptureHelper
implements ScrollCaptureViewHelper<ViewGroup> {
    private static final String TAG = "RVCaptureHelper";
    private int mScrollDelta;
    private boolean mScrollBarWasEnabled;
    private int mOverScrollMode;

    @Override
    public boolean onAcceptSession(ViewGroup view2) {
        return view2.isVisibleToUser() && (view2.canScrollVertically(-1) || view2.canScrollVertically(1));
    }

    @Override
    public void onPrepareForStart(ViewGroup view2, Rect scrollBounds) {
        this.mScrollDelta = 0;
        this.mOverScrollMode = view2.getOverScrollMode();
        view2.setOverScrollMode(2);
        this.mScrollBarWasEnabled = view2.isVerticalScrollBarEnabled();
        view2.setVerticalScrollBarEnabled(false);
    }

    @Override
    public void onScrollRequested(ViewGroup recyclerView, Rect scrollBounds, Rect requestRect, CancellationSignal signal, Consumer<ScrollCaptureViewHelper.ScrollResult> resultConsumer) {
        ScrollCaptureViewHelper.ScrollResult result = new ScrollCaptureViewHelper.ScrollResult();
        result.requestedArea = new Rect(requestRect);
        result.scrollDelta = this.mScrollDelta;
        result.availableArea = new Rect();
        if (!recyclerView.isVisibleToUser() || recyclerView.getChildCount() == 0) {
            Log.w(TAG, "recyclerView is empty or not visible, cannot continue");
            resultConsumer.accept(result);
            return;
        }
        Rect requestedContainerBounds = new Rect(requestRect);
        requestedContainerBounds.offset(0, -this.mScrollDelta);
        requestedContainerBounds.offset(scrollBounds.left, scrollBounds.top);
        View anchor = RecyclerViewCaptureHelper.findChildNearestTarget(recyclerView, requestedContainerBounds);
        if (anchor == null) {
            Log.w(TAG, "Failed to locate anchor view");
            resultConsumer.accept(result);
            return;
        }
        Rect requestedContentBounds = new Rect(requestedContainerBounds);
        recyclerView.offsetRectIntoDescendantCoords(anchor, requestedContentBounds);
        int prevAnchorTop = anchor.getTop();
        Rect input = new Rect(requestedContentBounds);
        int remainingHeight = recyclerView.getHeight() - recyclerView.getPaddingTop() - recyclerView.getPaddingBottom() - input.height();
        if (remainingHeight > 0) {
            input.inset(0, -remainingHeight / 2);
        }
        if (recyclerView.requestChildRectangleOnScreen(anchor, input, true)) {
            int scrolled = prevAnchorTop - anchor.getTop();
            this.mScrollDelta += scrolled;
            result.scrollDelta = this.mScrollDelta;
        }
        requestedContainerBounds.set(requestedContentBounds);
        recyclerView.offsetDescendantRectToMyCoords(anchor, requestedContainerBounds);
        Rect recyclerLocalVisible = new Rect(scrollBounds);
        recyclerView.getLocalVisibleRect(recyclerLocalVisible);
        if (!requestedContainerBounds.intersect(recyclerLocalVisible)) {
            resultConsumer.accept(result);
            return;
        }
        Rect available = new Rect(requestedContainerBounds);
        available.offset(-scrollBounds.left, -scrollBounds.top);
        available.offset(0, this.mScrollDelta);
        result.availableArea = available;
        resultConsumer.accept(result);
    }

    static View findChildNearestTarget(ViewGroup parent, Rect targetRect) {
        View selected = null;
        int minCenterDistance = Integer.MAX_VALUE;
        boolean maxOverlap = false;
        float preferredRangeFromCenterPercent = 0.25f;
        int preferredDistance = (int)(0.25f * (float)targetRect.height());
        Rect parentLocalVis = new Rect();
        parent.getLocalVisibleRect(parentLocalVis);
        Rect frame = new Rect();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View child = parent.getChildAt(i);
            child.getHitRect(frame);
            if (child.getVisibility() != 0) continue;
            int centerDistance = Math.abs(targetRect.centerY() - frame.centerY());
            if (centerDistance < minCenterDistance) {
                minCenterDistance = centerDistance;
                selected = child;
                continue;
            }
            if (!frame.intersect(targetRect) || frame.height() <= preferredDistance) continue;
            selected = child;
        }
        return selected;
    }

    @Override
    public void onPrepareForEnd(ViewGroup view2) {
        view2.scrollBy(0, -this.mScrollDelta);
        view2.setOverScrollMode(this.mOverScrollMode);
        view2.setVerticalScrollBarEnabled(this.mScrollBarWasEnabled);
    }
}

