/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.CancellationSignal;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.ScrollCaptureViewHelper;
import java.util.function.Consumer;

public class ScrollViewCaptureHelper
implements ScrollCaptureViewHelper<ViewGroup> {
    private int mStartScrollY;
    private boolean mScrollBarEnabled;
    private int mOverScrollMode;

    @Override
    public boolean onAcceptSession(ViewGroup view2) {
        return view2.isVisibleToUser() && (view2.canScrollVertically(-1) || view2.canScrollVertically(1));
    }

    @Override
    public void onPrepareForStart(ViewGroup view2, Rect scrollBounds) {
        this.mStartScrollY = view2.getScrollY();
        this.mOverScrollMode = view2.getOverScrollMode();
        if (this.mOverScrollMode != 2) {
            view2.setOverScrollMode(2);
        }
        this.mScrollBarEnabled = view2.isVerticalScrollBarEnabled();
        if (this.mScrollBarEnabled) {
            view2.setVerticalScrollBarEnabled(false);
        }
    }

    @Override
    public void onScrollRequested(ViewGroup view2, Rect scrollBounds, Rect requestRect, CancellationSignal signal, Consumer<ScrollCaptureViewHelper.ScrollResult> resultConsumer) {
        int scrollDelta = view2.getScrollY() - this.mStartScrollY;
        ScrollCaptureViewHelper.ScrollResult result = new ScrollCaptureViewHelper.ScrollResult();
        result.requestedArea = new Rect(requestRect);
        result.scrollDelta = scrollDelta;
        result.availableArea = new Rect();
        View contentView = view2.getChildAt(0);
        if (contentView == null) {
            resultConsumer.accept(result);
            return;
        }
        Rect requestedContainerBounds = new Rect(requestRect);
        requestedContainerBounds.offset(0, -scrollDelta);
        requestedContainerBounds.offset(scrollBounds.left, scrollBounds.top);
        Rect requestedContentBounds = new Rect(requestedContainerBounds);
        requestedContentBounds.offset(view2.getScrollX() - contentView.getLeft(), view2.getScrollY() - contentView.getTop());
        Rect input = new Rect(requestedContentBounds);
        int remainingHeight = view2.getHeight() - view2.getPaddingTop() - view2.getPaddingBottom() - input.height();
        if (remainingHeight > 0) {
            input.inset(0, -remainingHeight / 2);
        }
        contentView.requestRectangleOnScreen(input, true);
        result.scrollDelta = scrollDelta = view2.getScrollY() - this.mStartScrollY;
        Point offset2 = new Point();
        Rect available = new Rect(requestedContentBounds);
        if (!view2.getChildVisibleRect(contentView, available, offset2)) {
            available.setEmpty();
            result.availableArea = available;
            resultConsumer.accept(result);
            return;
        }
        available.offset(-offset2.x, -offset2.y);
        available.offset(contentView.getLeft() - view2.getScrollX(), contentView.getTop() - view2.getScrollY());
        available.offset(-scrollBounds.left, -scrollBounds.top);
        available.offset(0, scrollDelta);
        result.availableArea = new Rect(available);
        resultConsumer.accept(result);
    }

    @Override
    public void onPrepareForEnd(ViewGroup view2) {
        view2.scrollTo(0, this.mStartScrollY);
        if (this.mOverScrollMode != 2) {
            view2.setOverScrollMode(this.mOverScrollMode);
        }
        if (this.mScrollBarEnabled) {
            view2.setVerticalScrollBarEnabled(true);
        }
    }
}

