/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Rect;
import android.os.CancellationSignal;
import android.util.MathUtils;
import android.webkit.WebView;
import com.android.internal.view.ScrollCaptureViewHelper;
import java.util.function.Consumer;

public class WebViewCaptureHelper
implements ScrollCaptureViewHelper<WebView> {
    private static final String TAG = "WebViewScrollCapture";
    private final Rect mRequestWebViewLocal = new Rect();
    private final Rect mWebViewBounds = new Rect();
    private int mOriginScrollY;
    private int mOriginScrollX;

    @Override
    public boolean onAcceptSession(WebView view2) {
        return view2.isVisibleToUser() && (float)view2.getContentHeight() * view2.getScale() > (float)view2.getHeight();
    }

    @Override
    public void onPrepareForStart(WebView view2, Rect scrollBounds) {
        this.mOriginScrollX = view2.getScrollX();
        this.mOriginScrollY = view2.getScrollY();
    }

    @Override
    public void onScrollRequested(WebView view2, Rect scrollBounds, Rect requestRect, CancellationSignal cancellationSignal, Consumer<ScrollCaptureViewHelper.ScrollResult> resultConsumer) {
        int scrollDelta = view2.getScrollY() - this.mOriginScrollY;
        ScrollCaptureViewHelper.ScrollResult result = new ScrollCaptureViewHelper.ScrollResult();
        result.requestedArea = new Rect(requestRect);
        result.availableArea = new Rect();
        result.scrollDelta = scrollDelta;
        this.mWebViewBounds.set(0, 0, view2.getWidth(), view2.getHeight());
        if (!view2.isVisibleToUser()) {
            resultConsumer.accept(result);
        }
        this.mRequestWebViewLocal.set(requestRect);
        this.mRequestWebViewLocal.offset(0, -scrollDelta);
        int upLimit = Math.min(0, -view2.getScrollY());
        int contentHeightPx = (int)((float)view2.getContentHeight() * view2.getScale());
        int downLimit = Math.max(0, contentHeightPx - view2.getHeight() - view2.getScrollY());
        int scrollToCenter = this.mRequestWebViewLocal.centerY() - this.mWebViewBounds.centerY();
        int scrollMovement = MathUtils.constrain(scrollToCenter, upLimit, downLimit);
        view2.scrollBy(this.mOriginScrollX, scrollMovement);
        scrollDelta = view2.getScrollY() - this.mOriginScrollY;
        this.mRequestWebViewLocal.offset(0, -scrollMovement);
        result.scrollDelta = scrollDelta;
        if (this.mRequestWebViewLocal.intersect(this.mWebViewBounds)) {
            result.availableArea = new Rect(this.mRequestWebViewLocal);
            result.availableArea.offset(0, result.scrollDelta);
        }
        resultConsumer.accept(result);
    }

    @Override
    public void onPrepareForEnd(WebView view2) {
        view2.scrollTo(this.mOriginScrollX, this.mOriginScrollY);
    }
}

