/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.inline;

import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.provider.DeviceConfig;
import android.provider.Settings;
import android.transition.Transition;
import android.util.Slog;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.view.autofill.Helper;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.inline.InlineContentView;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;

public class InlineTooltipUi
extends PopupWindow
implements AutoCloseable {
    private static final String TAG = "InlineTooltipUi";
    private static final int FIRST_TIME_SHOW_DEFAULT_DELAY_MS = 250;
    private final WindowManager mWm;
    private final ViewGroup mContentContainer;
    private boolean mShowing;
    private WindowManager.LayoutParams mWindowLayoutParams;
    private DelayShowRunnable mDelayShowTooltip;
    private boolean mHasEverDetached;
    private boolean mDelayShowAtStart = true;
    private boolean mDelaying = false;
    private int mShowDelayConfigMs;
    private final Rect mTmpRect = new Rect();
    private final View.OnAttachStateChangeListener mAnchorOnAttachStateChangeListener = new View.OnAttachStateChangeListener(){

        @Override
        public void onViewAttachedToWindow(View v) {
        }

        @Override
        public void onViewDetachedFromWindow(View v) {
            InlineTooltipUi.this.mHasEverDetached = true;
            InlineTooltipUi.this.dismiss();
        }
    };
    private final View.OnLayoutChangeListener mAnchoredOnLayoutChangeListener = new View.OnLayoutChangeListener(){
        int mHeight;

        @Override
        public void onLayoutChange(View v, int left, int top, int right2, int bottom2, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            if (InlineTooltipUi.this.mHasEverDetached) {
                return;
            }
            if (this.mHeight != bottom2 - top) {
                this.mHeight = bottom2 - top;
                InlineTooltipUi.this.adjustPosition();
            }
        }
    };

    public InlineTooltipUi(Context context) {
        this.mContentContainer = new LinearLayout(new ContextWrapper(context));
        this.mWm = context.getSystemService(WindowManager.class);
        this.mShowDelayConfigMs = DeviceConfig.getInt("autofill", "autofill_inline_tooltip_first_show_delay", 250);
        this.setTouchModal(false);
        this.setOutsideTouchable(true);
        this.setInputMethodMode(2);
        this.setFocusable(false);
    }

    public void setTooltipView(InlineContentView v) {
        this.mContentContainer.removeAllViews();
        this.mContentContainer.addView(v);
        this.mContentContainer.setVisibility(0);
    }

    @Override
    public void close() {
        this.dismiss();
    }

    @Override
    protected boolean hasContentView() {
        return true;
    }

    @Override
    protected boolean hasDecorView() {
        return true;
    }

    @Override
    protected WindowManager.LayoutParams getDecorViewLayoutParams() {
        return this.mWindowLayoutParams;
    }

    public void update(View anchor) {
        if (anchor == null) {
            View oldAnchor = this.getAnchor();
            if (oldAnchor != null) {
                this.removeDelayShowTooltip(oldAnchor);
            }
            return;
        }
        if (this.mDelayShowAtStart) {
            this.mDelayShowAtStart = false;
            this.mDelaying = true;
            if (this.mDelayShowTooltip == null) {
                this.mDelayShowTooltip = new DelayShowRunnable(anchor);
            }
            int delayTimeMs = this.mShowDelayConfigMs;
            try {
                float scale = Settings.Global.getFloat(anchor.getContext().getContentResolver(), "animator_duration_scale");
                delayTimeMs = (int)((float)delayTimeMs * scale);
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                // empty catch block
            }
            anchor.postDelayed(this.mDelayShowTooltip, delayTimeMs);
        } else if (!this.mDelaying) {
            this.updateInner(anchor);
        }
    }

    private void removeDelayShowTooltip(View anchor) {
        if (this.mDelayShowTooltip != null) {
            anchor.removeCallbacks(this.mDelayShowTooltip);
            this.mDelayShowTooltip = null;
        }
    }

    private void updateInner(View anchor) {
        if (this.mHasEverDetached) {
            return;
        }
        this.setWindowLayoutType(1005);
        int offsetY = -anchor.getHeight() - this.getPreferHeight(anchor);
        if (!this.isShowing()) {
            this.setWidth(-2);
            this.setHeight(-2);
            this.showAsDropDown(anchor, 0, offsetY, 49);
        } else {
            this.update(anchor, 0, offsetY, -2, -2);
        }
    }

    private int getPreferHeight(View anchor) {
        int achoredHeight = this.mContentContainer.getHeight();
        return achoredHeight == 0 ? anchor.getHeight() : achoredHeight;
    }

    @Override
    protected boolean findDropDownPosition(View anchor, WindowManager.LayoutParams outParams, int xOffset, int yOffset, int width2, int height2, int gravity, boolean allowScroll) {
        boolean isAbove = super.findDropDownPosition(anchor, outParams, xOffset, yOffset, width2, height2, gravity, allowScroll);
        ViewParent parent = anchor.getParent();
        if (parent instanceof View) {
            Rect r = this.mTmpRect;
            ((View)((Object)parent)).getGlobalVisibleRect(r);
            outParams.y = isAbove ? r.top - this.getPreferHeight(anchor) : r.bottom + 1;
        }
        return isAbove;
    }

    @Override
    protected void update(View anchor, WindowManager.LayoutParams params) {
        if (anchor.isVisibleToUser()) {
            this.show(params);
        } else {
            this.hide();
        }
    }

    @Override
    public void showAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        if (this.isShowing()) {
            return;
        }
        this.setShowing(true);
        this.setDropDown(true);
        this.attachToAnchor(anchor, xoff, yoff, gravity);
        WindowManager.LayoutParams p = this.mWindowLayoutParams = this.createPopupLayoutParams(anchor.getWindowToken());
        boolean aboveAnchor = this.findDropDownPosition(anchor, p, xoff, yoff, p.width, p.height, gravity, this.getAllowScrollingAnchorParent());
        this.updateAboveAnchor(aboveAnchor);
        p.accessibilityIdOfAnchor = anchor.getAccessibilityViewId();
        p.packageName = anchor.getContext().getPackageName();
        this.show(p);
    }

    @Override
    protected void attachToAnchor(View anchor, int xoff, int yoff, int gravity) {
        super.attachToAnchor(anchor, xoff, yoff, gravity);
        anchor.addOnAttachStateChangeListener(this.mAnchorOnAttachStateChangeListener);
    }

    @Override
    protected void detachFromAnchor() {
        View anchor = this.getAnchor();
        if (anchor != null) {
            anchor.removeOnAttachStateChangeListener(this.mAnchorOnAttachStateChangeListener);
            this.removeDelayShowTooltip(anchor);
        }
        this.mHasEverDetached = true;
        super.detachFromAnchor();
    }

    @Override
    public void dismiss() {
        if (!this.isShowing() || this.isTransitioningToDismiss()) {
            return;
        }
        this.setTransitioningToDismiss(true);
        this.hide();
        this.detachFromAnchor();
        if (this.getOnDismissListener() != null) {
            this.getOnDismissListener().onDismiss();
        }
        super.dismiss();
    }

    private void adjustPosition() {
        View anchor = this.getAnchor();
        if (anchor == null) {
            return;
        }
        this.update(anchor);
    }

    private void show(WindowManager.LayoutParams params) {
        this.mWindowLayoutParams = params;
        try {
            params.packageName = "android";
            params.setTitle("Autofill Inline Tooltip");
            if (!this.mShowing) {
                if (Helper.sVerbose) {
                    Slog.v(TAG, "show()");
                }
                params.flags = 40;
                params.privateFlags |= 0x400000;
                this.mContentContainer.addOnLayoutChangeListener(this.mAnchoredOnLayoutChangeListener);
                this.mWm.addView(this.mContentContainer, params);
                this.mShowing = true;
            } else {
                this.mWm.updateViewLayout(this.mContentContainer, params);
            }
        }
        catch (WindowManager.BadTokenException e) {
            Slog.d(TAG, "Failed with token " + params.token + " gone.");
        }
        catch (IllegalStateException e) {
            Slog.wtf(TAG, "Exception showing window " + params, e);
        }
    }

    private void hide() {
        try {
            if (this.mShowing) {
                if (Helper.sVerbose) {
                    Slog.v(TAG, "hide()");
                }
                this.mContentContainer.removeOnLayoutChangeListener(this.mAnchoredOnLayoutChangeListener);
                this.mWm.removeView(this.mContentContainer);
                this.mShowing = false;
            }
        }
        catch (IllegalStateException e) {
            Slog.e(TAG, "Exception hiding window ", e);
        }
    }

    @Override
    public int getAnimationStyle() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public Drawable getBackground() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public View getContentView() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public float getElevation() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public Transition getEnterTransition() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public Transition getExitTransition() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setBackgroundDrawable(Drawable background) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setContentView(View contentView) {
        if (contentView != null) {
            throw new IllegalStateException("You can't call this!");
        }
    }

    @Override
    public void setElevation(float elevation) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setEnterTransition(Transition enterTransition) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setExitTransition(Transition exitTransition) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setTouchInterceptor(View.OnTouchListener l) {
        throw new IllegalStateException("You can't call this!");
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        if (this.mContentContainer != null) {
            pw.print(prefix);
            pw.print("Window: ");
            String prefix2 = prefix + "  ";
            pw.println();
            pw.print(prefix2);
            pw.print("showing: ");
            pw.println(this.mShowing);
            pw.print(prefix2);
            pw.print("view: ");
            pw.println(this.mContentContainer);
            if (this.mWindowLayoutParams != null) {
                pw.print(prefix2);
                pw.print("params: ");
                pw.println(this.mWindowLayoutParams);
            }
            pw.print(prefix2);
            pw.print("screen coordinates: ");
            if (this.mContentContainer == null) {
                pw.println("N/A");
            } else {
                int[] coordinates = this.mContentContainer.getLocationOnScreen();
                pw.print(coordinates[0]);
                pw.print("x");
                pw.println(coordinates[1]);
            }
        }
    }

    private class DelayShowRunnable
    implements Runnable {
        WeakReference<View> mAnchor;

        DelayShowRunnable(View anchor) {
            this.mAnchor = new WeakReference<View>(anchor);
        }

        @Override
        public void run() {
            InlineTooltipUi.this.mDelaying = false;
            View anchor = (View)this.mAnchor.get();
            if (anchor != null) {
                InlineTooltipUi.this.updateInner(anchor);
            }
        }

        public void setAnchor(View anchor) {
            this.mAnchor.clear();
            this.mAnchor = new WeakReference<View>(anchor);
        }
    }
}

