/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.graphics.Rect;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import com.android.internal.view.menu.MenuAdapter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.ShowableListMenu;

public abstract class MenuPopup
implements ShowableListMenu,
MenuPresenter,
AdapterView.OnItemClickListener {
    private Rect mEpicenterBounds;

    public abstract void setForceShowIcon(boolean var1);

    public abstract void addMenu(MenuBuilder var1);

    public abstract void setGravity(int var1);

    public abstract void setAnchorView(View var1);

    public abstract void setHorizontalOffset(int var1);

    public abstract void setVerticalOffset(int var1);

    public void setEpicenterBounds(Rect bounds2) {
        this.mEpicenterBounds = bounds2;
    }

    public Rect getEpicenterBounds() {
        return this.mEpicenterBounds;
    }

    public abstract void setShowTitle(boolean var1);

    public abstract void setOnDismissListener(PopupWindow.OnDismissListener var1);

    @Override
    public void initForMenu(Context context, MenuBuilder menu2) {
    }

    @Override
    public MenuView getMenuView(ViewGroup root) {
        throw new UnsupportedOperationException("MenuPopups manage their own views");
    }

    @Override
    public boolean expandItemActionView(MenuBuilder menu2, MenuItemImpl item) {
        return false;
    }

    @Override
    public boolean collapseItemActionView(MenuBuilder menu2, MenuItemImpl item) {
        return false;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view2, int position, long id2) {
        ListAdapter outerAdapter = (ListAdapter)parent.getAdapter();
        MenuAdapter wrappedAdapter = MenuPopup.toMenuAdapter(outerAdapter);
        wrappedAdapter.mAdapterMenu.performItemAction((MenuItem)outerAdapter.getItem(position), 0);
    }

    protected static int measureIndividualMenuWidth(ListAdapter adapter, ViewGroup parent, Context context, int maxAllowedWidth) {
        int maxWidth = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if (parent == null) {
                parent = new FrameLayout(context);
            }
            itemView = adapter.getView(i, itemView, parent);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            int itemWidth = itemView.getMeasuredWidth();
            if (itemWidth >= maxAllowedWidth) {
                return maxAllowedWidth;
            }
            if (itemWidth <= maxWidth) continue;
            maxWidth = itemWidth;
        }
        return maxWidth;
    }

    protected static MenuAdapter toMenuAdapter(ListAdapter adapter) {
        if (adapter instanceof HeaderViewListAdapter) {
            return (MenuAdapter)((HeaderViewListAdapter)adapter).getWrappedAdapter();
        }
        return (MenuAdapter)adapter;
    }

    protected static boolean shouldPreserveIconSpacing(MenuBuilder menu2) {
        boolean preserveIconSpacing = false;
        int count = menu2.size();
        for (int i = 0; i < count; ++i) {
            MenuItem childItem = menu2.getItem(i);
            if (!childItem.isVisible() || childItem.getIcon() == null) continue;
            preserveIconSpacing = true;
            break;
        }
        return preserveIconSpacing;
    }
}

