/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;

public class SubMenuBuilder
extends MenuBuilder
implements SubMenu {
    private MenuBuilder mParentMenu;
    private MenuItemImpl mItem;

    public SubMenuBuilder(Context context, MenuBuilder parentMenu, MenuItemImpl item) {
        super(context);
        this.mParentMenu = parentMenu;
        this.mItem = item;
    }

    @Override
    public void setQwertyMode(boolean isQwerty) {
        this.mParentMenu.setQwertyMode(isQwerty);
    }

    @Override
    public boolean isQwertyMode() {
        return this.mParentMenu.isQwertyMode();
    }

    @Override
    public void setShortcutsVisible(boolean shortcutsVisible) {
        this.mParentMenu.setShortcutsVisible(shortcutsVisible);
    }

    @Override
    public boolean isShortcutsVisible() {
        return this.mParentMenu.isShortcutsVisible();
    }

    public Menu getParentMenu() {
        return this.mParentMenu;
    }

    @Override
    public MenuItem getItem() {
        return this.mItem;
    }

    @Override
    @UnsupportedAppUsage
    public void setCallback(MenuBuilder.Callback callback2) {
        this.mParentMenu.setCallback(callback2);
    }

    @Override
    @UnsupportedAppUsage
    public MenuBuilder getRootMenu() {
        return this.mParentMenu.getRootMenu();
    }

    @Override
    boolean dispatchMenuItemSelected(MenuBuilder menu2, MenuItem item) {
        return super.dispatchMenuItemSelected(menu2, item) || this.mParentMenu.dispatchMenuItemSelected(menu2, item);
    }

    @Override
    public SubMenu setIcon(Drawable icon2) {
        this.mItem.setIcon(icon2);
        return this;
    }

    @Override
    public SubMenu setIcon(int iconRes) {
        this.mItem.setIcon(iconRes);
        return this;
    }

    @Override
    public SubMenu setHeaderIcon(Drawable icon2) {
        return (SubMenu)((Object)super.setHeaderIconInt(icon2));
    }

    @Override
    public SubMenu setHeaderIcon(int iconRes) {
        return (SubMenu)((Object)super.setHeaderIconInt(iconRes));
    }

    @Override
    public SubMenu setHeaderTitle(CharSequence title) {
        return (SubMenu)((Object)super.setHeaderTitleInt(title));
    }

    @Override
    public SubMenu setHeaderTitle(int titleRes) {
        return (SubMenu)((Object)super.setHeaderTitleInt(titleRes));
    }

    @Override
    public SubMenu setHeaderView(View view2) {
        return (SubMenu)((Object)super.setHeaderViewInt(view2));
    }

    @Override
    public boolean expandItemActionView(MenuItemImpl item) {
        return this.mParentMenu.expandItemActionView(item);
    }

    @Override
    public boolean collapseItemActionView(MenuItemImpl item) {
        return this.mParentMenu.collapseItemActionView(item);
    }

    @Override
    public String getActionViewStatesKey() {
        int itemId;
        int n = itemId = this.mItem != null ? this.mItem.getItemId() : 0;
        if (itemId == 0) {
            return null;
        }
        return super.getActionViewStatesKey() + ":" + itemId;
    }

    @Override
    public void setGroupDividerEnabled(boolean groupDividerEnabled) {
        this.mParentMenu.setGroupDividerEnabled(groupDividerEnabled);
    }

    @Override
    public boolean isGroupDividerEnabled() {
        return this.mParentMenu.isGroupDividerEnabled();
    }
}

