/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.internal.widget.AccountViewAdapter;

public class AccountItemView
extends LinearLayout {
    private ImageView mAccountIcon;
    private TextView mAccountName;
    private TextView mAccountNumber;

    public AccountItemView(Context context) {
        this(context, null);
    }

    public AccountItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflator = (LayoutInflater)context.getSystemService("layout_inflater");
        View view2 = inflator.inflate(17367322, null);
        this.addView(view2);
        this.initViewItem(view2);
    }

    private void initViewItem(View view2) {
        this.mAccountIcon = (ImageView)view2.findViewById(16908294);
        this.mAccountName = (TextView)view2.findViewById(16908310);
        this.mAccountNumber = (TextView)view2.findViewById(0x1020010);
    }

    public void setViewItem(AccountViewAdapter.AccountElements element) {
        Drawable drawable2 = element.getDrawable();
        if (drawable2 != null) {
            this.setAccountIcon(drawable2);
        } else {
            this.setAccountIcon(element.getIcon());
        }
        this.setAccountName(element.getName());
        this.setAccountNumber(element.getNumber());
    }

    public void setAccountIcon(int resId) {
        this.mAccountIcon.setImageResource(resId);
    }

    public void setAccountIcon(Drawable drawable2) {
        this.mAccountIcon.setBackgroundDrawable(drawable2);
    }

    public void setAccountName(String name) {
        this.setText(this.mAccountName, name);
    }

    public void setAccountNumber(String number) {
        this.setText(this.mAccountNumber, number);
    }

    private void setText(TextView view2, String text) {
        if (TextUtils.isEmpty(text)) {
            view2.setVisibility(8);
        } else {
            view2.setText(text);
            view2.setVisibility(0);
        }
    }
}

